/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.openal;

import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.openal.OpenALAudioBuffer;
import com.jmex.audio.openal.OpenALMemoryAudioPlayer;
import com.jmex.audio.openal.OpenALStreamedAudioPlayer;
import com.jmex.audio.stream.AudioInputStream;
import com.jmex.audio.stream.OggInputStream;
import com.jmex.audio.stream.WavInputStream;
import com.jmex.audio.util.AudioLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenALAudioTrack
extends AudioTrack {
    private static final Logger logger = Logger.getLogger(OpenALAudioTrack.class.getName());

    public OpenALAudioTrack(URL uRL, boolean bl) {
        super(uRL, bl);
        if (uRL != null) {
            if (bl) {
                try {
                    AudioTrack.Format format = AudioInputStream.sniffFormat(uRL.openStream());
                    if (AudioTrack.Format.WAV.equals((Object)format)) {
                        WavInputStream wavInputStream = new WavInputStream(uRL);
                        this.setPlayer(new OpenALStreamedAudioPlayer(wavInputStream, this));
                    } else if (AudioTrack.Format.OGG.equals((Object)format)) {
                        Object object;
                        float f = -1.0f;
                        try {
                            object = !uRL.getProtocol().equals("file") ? new VorbisFile(uRL.openStream(), null, 0) : new VorbisFile(URLDecoder.decode(new File(uRL.getFile()).getPath(), "UTF-8"));
                            f = object.time_total(-1);
                        }
                        catch (JOrbisException jOrbisException) {
                            logger.log(Level.WARNING, "Error creating VorbisFile", jOrbisException);
                        }
                        object = new OggInputStream(uRL, f);
                        this.setPlayer(new OpenALStreamedAudioPlayer((AudioInputStream)object, this));
                    } else {
                        throw new IllegalArgumentException("Given url is not a recognized audio type. Must be OGG or RIFF/WAV: " + uRL);
                    }
                    this.getPlayer().init();
                }
                catch (IOException iOException) {
                    logger.logp(Level.SEVERE, this.getClass().toString(), "OpenALAudioTrack(URL resource, boolean stream)", "Exception", iOException);
                }
            } else {
                OpenALAudioBuffer openALAudioBuffer = OpenALAudioBuffer.generateBuffer();
                try {
                    AudioLoader.fillBuffer(openALAudioBuffer, uRL);
                }
                catch (IOException iOException) {
                    logger.logp(Level.SEVERE, this.getClass().toString(), "OpenALAudioTrack(URL resource, boolean stream)", "Exception", iOException);
                    return;
                }
                this.setPlayer(new OpenALMemoryAudioPlayer(openALAudioBuffer, this));
            }
        }
    }

    public OpenALAudioTrack(URL uRL, OpenALAudioBuffer openALAudioBuffer) {
        super(uRL, false);
        this.setPlayer(new OpenALMemoryAudioPlayer(openALAudioBuffer, this));
    }

    public OpenALAudioTrack(URL uRL, AudioInputStream audioInputStream) {
        super(uRL, true);
        this.setPlayer(new OpenALStreamedAudioPlayer(audioInputStream, this));
    }
}

