/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.audio;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WavUtils {
    public static Log log = LogFactory.getLog(WavUtils.class);
    private static final float DELTA = 1.0E-9f;

    public static AudioInputStream convertDefaultWavAudioType(File inputFile) {
        AudioInputStream stream;
        boolean bDesiredBigEndian;
        float fDesiredSampleRate;
        AudioFormat.Encoding desiredEncoding;
        int nDesiredSampleSizeInBits;
        int nDesiredChannels;
        block8: {
            nDesiredChannels = 2;
            nDesiredSampleSizeInBits = 16;
            desiredEncoding = AudioFormat.Encoding.PCM_SIGNED;
            fDesiredSampleRate = 48000.0f;
            bDesiredBigEndian = false;
            AudioFileFormat inputFileFormat = AudioSystem.getAudioFileFormat(inputFile);
            inputFileFormat.getType();
            stream = null;
            stream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat format = stream.getFormat();
            if (WavUtils.isPcm(format.getEncoding())) break block8;
            log.warn((Object)"file not wav");
            return null;
        }
        try {
            if (stream.getFormat().getChannels() != nDesiredChannels) {
                log.info((Object)"converting channels...");
                stream = WavUtils.convertChannels(nDesiredChannels, stream);
                log.info((Object)("stream: " + stream));
                log.info((Object)("format: " + stream.getFormat()));
            }
            boolean bDoConvertSampleSize = stream.getFormat().getSampleSizeInBits() != nDesiredSampleSizeInBits;
            boolean bDoConvertEndianess = stream.getFormat().isBigEndian() ^ bDesiredBigEndian;
            if (bDoConvertSampleSize || bDoConvertEndianess) {
                log.info((Object)"converting sample size and endianess...");
                stream = WavUtils.convertSampleSizeAndEndianess(nDesiredSampleSizeInBits, bDesiredBigEndian, stream);
                log.info((Object)("stream: " + stream));
                log.info((Object)("format: " + stream.getFormat()));
            }
            if (!WavUtils.equals(stream.getFormat().getSampleRate(), fDesiredSampleRate)) {
                log.info((Object)"converting sample rate...");
                stream = WavUtils.convertSampleRate(fDesiredSampleRate, stream);
                log.info((Object)("stream: " + stream));
                log.info((Object)("format: " + stream.getFormat()));
            }
            if (!stream.getFormat().getEncoding().equals(desiredEncoding)) {
                log.info((Object)("converting to " + desiredEncoding + "..."));
                stream = WavUtils.convertEncoding(desiredEncoding, stream);
                log.info((Object)("stream: " + stream));
                log.info((Object)("format: " + stream.getFormat()));
            }
            return stream;
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AudioInputStream convertEncoding(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        return AudioSystem.getAudioInputStream(targetEncoding, sourceStream);
    }

    public static AudioInputStream convertChannels(int nChannels, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), nChannels, WavUtils.calculateFrameSize(nChannels, sourceFormat.getSampleSizeInBits()), sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
        return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
    }

    public static AudioInputStream convertSampleSizeAndEndianess(int nSampleSizeInBits, boolean bBigEndian, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), nSampleSizeInBits, sourceFormat.getChannels(), WavUtils.calculateFrameSize(sourceFormat.getChannels(), nSampleSizeInBits), sourceFormat.getFrameRate(), bBigEndian);
        return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
    }

    public static AudioInputStream convertSampleRate(float fSampleRate, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(sourceFormat.getEncoding(), fSampleRate, sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), fSampleRate, sourceFormat.isBigEndian());
        return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
    }

    private static int calculateFrameSize(int nChannels, int nSampleSizeInBits) {
        return (nSampleSizeInBits + 7) / 8 * nChannels;
    }

    private static boolean equals(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-9f;
    }

    public static boolean isPcm(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED);
    }
}

