/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.rcp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegJpegPipeWriter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.text_douga.DougaLogger;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.VideoOutInfo;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.parser.SimpleParser;
import jp.sourceforge.akjrcp.text_douga.rcp.Activator;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import jp.sourceforge.akjrcp.text_douga.video.DirectoryVideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.PipedVideoWriter;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.RCPFileApplication;
import jp.sourceforge.akjrcp.util.ClipboardUtil;
import jp.sourceforge.akjrcp.util.DropFileListener;
import jp.sourceforge.akjrcp.util.DropFileMonitor;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.PrintWriterPrinter;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TextDougaView
extends ViewPart {
    public static Log log = LogFactory.getLog(TextDougaView.class);
    public static final String ID = TextDougaView.class.getName();
    private TextDougaExecute textDougaExecute;
    private TextDougaApplication textDougaApplication;
    public static final String SEQUENCE_DIR = "sequence";
    public static final String WORKING_DIR = "temporary";
    public static final String DOWNLOADED_DIR = "downloaded";
    private DougaLogger dougaLogger = new DougaLoggerImp();
    private boolean processVideo = true;
    private boolean processAudio = true;
    public static final int AVI = 0;
    public static final int VIDEO_AUDIO = 1;
    public static final int IMAGE_AUDIO = 2;
    public static final int MODE_MUX = 0;
    public static final int MODE_VIDEO = 1;
    public static final int MODE_AUDIO = 2;
    private int exportType;
    private boolean defaultProcessAudio = true;
    private boolean defaultProcessVideo = true;
    private String outputPath;
    private String dText;
    private File iFile;
    private FileDirChoicer outputFileChooser;
    private Text dougaText;
    private Text logText;
    private Button saveButton;
    private Text fileNameText;
    private Text baseName;
    private Button imageAudioRadio;
    private Button videoAudioRadio;
    private Button aviRadio;
    private Button playButton;
    private Button muxRadio;
    private Button videoRadio;
    private Button audioRadio;

    public String getText() {
        return this.dougaText.getText();
    }

    public void setText(String text) {
        this.dougaText.setText(text);
    }

    public void createPartControl(Composite parent) {
        Activator.getDefault().getPreferenceStore().getString("init");
        this.textDougaExecute = new TextDougaExecute();
        this.textDougaApplication = new TextDougaApplication();
        this.textDougaApplication.setOpenFilterExtensions(new String[]{"*.txt;.txtd"});
        this.textDougaApplication.setSaveFilterExtensions(new String[]{"*.txt", ".txtd"});
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite dougaPanel = new Composite(parent, 0);
        dougaPanel.setLayout((Layout)new GridLayout(6, false));
        this.createDougaActionButtons(dougaPanel);
        Composite logPanel = new Composite(parent, 0);
        logPanel.setLayout((Layout)new FillLayout());
        Label label = new Label(logPanel, 0);
        label.setText("Log");
        Composite dougaTextMix = new Composite(parent, 0);
        dougaTextMix.setLayoutData((Object)new GridData(1808));
        dougaTextMix.setLayout((Layout)new GridLayout());
        this.fileNameText = new Text(dougaTextMix, 2056);
        this.fileNameText.setLayoutData((Object)new GridData(768));
        this.dougaText = new Text(dougaTextMix, 770);
        this.dougaText.setLayoutData((Object)new GridData(1808));
        this.dougaText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextDougaView.this.textDougaApplication.setNeedSave(true);
                TextDougaView.this.textDougaExecute.updateControlSwitch();
            }
        });
        new DropFileMonitor((Control)this.dougaText, new DropFileListener(){

            public void dropFile(String[] arg0) {
                File tmp;
                File file = null;
                int i = 0;
                while (i < arg0.length) {
                    tmp = new File(arg0[i]);
                    if (tmp.isFile() && (tmp.getName().toLowerCase().endsWith(".txt") || tmp.getName().toLowerCase().endsWith(".txtd"))) {
                        file = tmp;
                        break;
                    }
                    ++i;
                }
                if (file != null) {
                    TextDougaView.this.textDougaApplication.openFile(file);
                } else {
                    i = 0;
                    while (i < arg0.length) {
                        tmp = new File(arg0[i]);
                        if (tmp.isFile()) {
                            int type = ParserUtils.getFileType(tmp.getName());
                            if (type == 2 || type == 5 || type == 1 || type == 6) {
                                TextDougaView.this.insertFilePathLine(tmp);
                            }
                        } else {
                            TextDougaView.this.insertFilePathLine(tmp);
                        }
                        ++i;
                    }
                }
            }
        });
        this.logText = new Text(parent, 2626);
        GridData gdata = new GridData(1040);
        gdata.widthHint = 200;
        this.logText.setLayoutData((Object)gdata);
        Composite exportPanel = new Composite(parent, 0);
        GridData g2 = new GridData(768);
        g2.horizontalSpan = 2;
        exportPanel.setLayoutData((Object)g2);
        exportPanel.setLayout((Layout)new GridLayout(1, false));
        this.createDougaExportButtons(this.textDougaExecute, exportPanel);
        this.textDougaExecute.updateControlSwitch();
        try {
            String dir = System.getProperty("user.dir");
            long check = 0x100000L;
            long kbyte = FileSystemUtils.freeSpaceKb((String)dir);
            if (kbyte < check) {
                this.dougaLogger.warn(Messages.getString("log.more_freespace"));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void muxMode() {
        this.defaultProcessAudio = true;
        this.defaultProcessVideo = true;
        this.aviRadio.setEnabled(true);
        this.imageAudioRadio.setEnabled(true);
        this.videoAudioRadio.setEnabled(true);
    }

    private void videoMode() {
        this.defaultProcessAudio = false;
        this.defaultProcessVideo = true;
        this.aviRadio.setEnabled(true);
        this.imageAudioRadio.setEnabled(true);
        this.videoAudioRadio.setEnabled(true);
    }

    private void audioMode() {
        this.defaultProcessAudio = true;
        this.defaultProcessVideo = false;
        this.aviRadio.setEnabled(false);
        this.imageAudioRadio.setEnabled(false);
        this.videoAudioRadio.setEnabled(false);
    }

    private void createDougaExportButtons(TextDougaExecute executer, Composite composite) {
        Composite muxRow = new Composite(composite, 0);
        muxRow.setLayout((Layout)new GridLayout(4, false));
        ExecutingControler.ExecutingControlButton exec = new ExecutingControler.ExecutingControlButton(muxRow, 0, (ExecutingControler)executer, Messages.getString("textdouga.exec"), Messages.getString("textdouga.cancel"));
        GridData execData = new GridData();
        execData.widthHint = 150;
        exec.setLayoutData((Object)execData);
        this.muxRadio = new Button(muxRow, 16);
        this.muxRadio.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.mux"));
        this.muxRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.muxMode();
            }
        });
        this.muxRadio.setSelection(true);
        this.videoRadio = new Button(muxRow, 16);
        this.videoRadio.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.video_only"));
        this.videoRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.videoMode();
            }
        });
        this.audioRadio = new Button(muxRow, 16);
        this.audioRadio.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.audio_only"));
        this.audioRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.audioMode();
            }
        });
        Composite exportRow = new Composite(composite, 0);
        exportRow.setLayoutData((Object)new GridData(768));
        exportRow.setLayout((Layout)new GridLayout(4, false));
        Group textGroup = new Group(exportRow, 0);
        GridData textData = new GridData(1040);
        textData.widthHint = 100;
        textGroup.setLayoutData((Object)textData);
        textGroup.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.baseName"));
        textGroup.setToolTipText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.baseName_tooltip"));
        textGroup.setLayout((Layout)new FillLayout());
        this.baseName = new Text((Composite)textGroup, 0);
        this.baseName.setToolTipText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.baseName_tooltip"));
        this.baseName.setText(Messages.getString("textdouga.default_export_video"));
        this.baseName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextDougaView.this.updatePlayButton();
            }
        });
        this.outputFileChooser = new FileDirChoicer(exportRow, 2048, 1, Messages.getString("textdouga.outputfile"));
        this.outputFileChooser.setLayoutData((Object)new GridData(768));
        this.outputFileChooser.addFileListChangeListener((FileDirChoicer.FileStatusChangeListener)new FileSelected());
        this.outputFileChooser.setFilePath(System.getProperty("user.dir"));
        this.textDougaExecute.addControl((Control)this.outputFileChooser);
        Button openDir = new Button(exportRow, 0);
        openDir.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/showin.gif").createImage());
        openDir.setToolTipText(Messages.getString("textdouga.tooltip_opendir"));
        openDir.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (TextDougaView.this.outputFileChooser.getFile() == null) {
                    return;
                }
                Runtime r = Runtime.getRuntime();
                try {
                    r.exec(new String[]{"explorer", TextDougaView.this.outputFileChooser.getFile().getAbsolutePath()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.playButton = new Button(exportRow, 0);
        this.playButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/play.gif").createImage());
        this.playButton.setToolTipText(Messages.getString("textdouga.tooltip_play"));
        this.playButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (TextDougaView.this.outputFileChooser.getFile() == null || !TextDougaView.this.outputFileChooser.getFile().exists()) {
                    return;
                }
                String aviPath = String.valueOf(TextDougaView.this.outputFileChooser.getAbsoluteFilePath()) + "\\" + TextDougaView.this.baseName.getText() + ".avi";
                if (!new File(aviPath).exists()) {
                    return;
                }
                Program.launch((String)aviPath);
            }
        });
        this.textDougaExecute.addControl((Control)this.playButton);
        Composite typeRow = new Composite(composite, 0);
        typeRow.setLayoutData((Object)new GridData(768));
        typeRow.setLayout((Layout)new GridLayout(3, true));
        this.aviRadio = new Button(typeRow, 16);
        this.aviRadio.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.export_avi"));
        this.aviRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.exportType = 0;
            }
        });
        this.videoAudioRadio = new Button(typeRow, 16);
        this.videoAudioRadio.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.export_video_audio"));
        this.videoAudioRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.exportType = 1;
            }
        });
        this.imageAudioRadio = new Button(typeRow, 16);
        this.imageAudioRadio.setText(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.export_image_audio"));
        this.imageAudioRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.exportType = 2;
            }
        });
        this.aviRadio.setSelection(true);
        this.updatePlayButton();
    }

    public void setExportMode(int mode) {
        if (mode == 0) {
            this.muxRadio.setSelection(true);
            this.videoRadio.setSelection(false);
            this.audioRadio.setSelection(false);
            this.muxMode();
        } else if (mode == 1) {
            this.muxRadio.setSelection(false);
            this.videoRadio.setSelection(true);
            this.audioRadio.setSelection(false);
            this.videoMode();
        } else if (mode == 2) {
            this.muxRadio.setSelection(false);
            this.videoRadio.setSelection(false);
            this.audioRadio.setSelection(true);
            this.audioMode();
        }
    }

    public void setExportType(int type) {
        if (type == 0) {
            this.aviRadio.setSelection(true);
            this.videoAudioRadio.setSelection(false);
            this.imageAudioRadio.setSelection(false);
        } else if (type == 1) {
            this.aviRadio.setSelection(false);
            this.videoAudioRadio.setSelection(true);
            this.imageAudioRadio.setSelection(false);
        } else if (type == 2) {
            this.aviRadio.setSelection(false);
            this.videoAudioRadio.setSelection(false);
            this.imageAudioRadio.setSelection(true);
        }
        this.exportType = type;
    }

    private void pasteClipboard() {
        String text = ClipboardUtil.getCurrentText((Display)PlatformUI.getWorkbench().getDisplay());
        if (text != null) {
            this.dougaText.setText(text);
        }
    }

    private void createDougaActionButtons(Composite composite) {
        Button newButton = new Button(composite, 0);
        newButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/text_new.gif").createImage());
        newButton.setToolTipText(Messages.getString("textdouga.tooltip_new"));
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.textDougaApplication.newFile();
            }
        });
        Button openButton = new Button(composite, 0);
        openButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/opendir.gif").createImage());
        openButton.setToolTipText(Messages.getString("textdouga.tooltip_open"));
        openButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.textDougaApplication.openFile();
            }
        });
        Button pasteButton = new Button(composite, 0);
        pasteButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/text_paste.gif").createImage());
        pasteButton.setToolTipText(Messages.getString("textdouga.tooltip_paste"));
        pasteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextDougaView.this.pasteClipboard();
            }
        });
        this.saveButton = new Button(composite, 0);
        this.saveButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/text_save.gif").createImage());
        this.saveButton.setToolTipText(Messages.getString("textdouga.tooltip_save"));
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean result = TextDougaView.this.textDougaApplication.saveFile();
                log.info((Object)result);
            }
        });
        this.saveButton.setEnabled(false);
        Button saveasButton = new Button(composite, 0);
        saveasButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"text_movie", (String)"icons/text_saveas.gif").createImage());
        saveasButton.setToolTipText(Messages.getString("textdouga.tooltip_saveas"));
        saveasButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean result = TextDougaView.this.textDougaApplication.saveAsFile();
                log.info((Object)result);
            }
        });
    }

    public void setFocus() {
    }

    public void updatePlayButton() {
        String aviPath;
        boolean status = true;
        if (this.outputFileChooser.getFile() == null || !this.outputFileChooser.getFile().exists()) {
            status = false;
        }
        if (!new File(aviPath = String.valueOf(this.outputFileChooser.getAbsoluteFilePath()) + "\\" + this.baseName.getText() + ".avi").exists()) {
            status = false;
        }
        log.trace((Object)(String.valueOf(status) + "," + aviPath));
        this.playButton.setEnabled(status);
    }

    private void insertFilePathLine(File file) {
        this.dougaText.insert(String.valueOf(file.getAbsolutePath()) + "\r\n");
    }

    public class AddText
    extends Thread {
        private String text;

        public AddText(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            String t = TextDougaView.this.logText.getText();
            TextDougaView.this.logText.setText(String.valueOf(t) + this.text);
            int last = t.length();
            TextDougaView.this.logText.setSelection(last, TextDougaView.this.logText.getText().length());
        }
    }

    public class DougaLoggerImp
    implements DougaLogger {
        @Override
        public void info(String logText) {
            log.info((Object)logText);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new AddText(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.info")) + logText + "\r\n"));
        }

        @Override
        public void trace(String logText) {
            log.trace((Object)logText);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new AddText(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.trace")) + logText + "\r\n"));
        }

        @Override
        public void warn(String logText) {
            log.warn((Object)logText);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new AddText(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.warn")) + logText + "\r\n"));
        }

        @Override
        public void error(String logText) {
            log.error((Object)logText);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new AddText(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.error")) + logText + "\r\n"));
        }
    }

    public class FileSelected
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            TextDougaView.this.textDougaExecute.updateControlSwitch();
            TextDougaView.this.updatePlayButton();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            TextDougaView.this.textDougaExecute.updateControlSwitch();
            TextDougaView.this.updatePlayButton();
        }
    }

    public class OverwriteCheck
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            File f = new File(event.getFilePath());
            if (f.exists()) {
                FileOverwriteControler controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                boolean r = controler.canOverwrite(f);
                System.out.println(r);
                if (!r) {
                    ((FileDirChoicer)event.getSource()).removePath();
                }
            }
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
        }
    }

    public class TextDougaApplication
    extends RCPFileApplication {
        protected void execNew() {
            TextDougaView.this.dougaText.setText("");
            TextDougaView.this.textDougaApplication.setNeedSave(false);
            TextDougaView.this.fileNameText.setText("");
            TextDougaView.this.baseName.setText(Messages.getString("textdouga.default_export_video"));
        }

        protected void execOpen() {
            File file = this.getFile();
            try {
                String text = IOUtils.toString((InputStream)new FileInputStream(file));
                TextDougaView.this.dougaText.setText(text);
                TextDougaView.this.textDougaApplication.setNeedSave(false);
                TextDougaView.this.fileNameText.setText(file.getName());
                String name = FileNameUtils.getRemovedExtensionName((String)file.getName());
                TextDougaView.this.baseName.setText(name);
                TextDougaView.this.textDougaExecute.updateControlSwitch();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected void execSave() {
            String text = TextDougaView.this.dougaText.getText();
            File file = this.getFile();
            try {
                FileUtils.writeStringToFile((File)file, (String)text);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String name = FileNameUtils.getRemovedExtensionName((String)file.getName());
            TextDougaView.this.baseName.setText(name);
        }

        protected void saveStatusChanged() {
            log.trace((Object)("status:" + this.isNeedSave()));
            TextDougaView.this.saveButton.setEnabled(this.isNeedSave());
        }
    }

    public class TextDougaExecute
    extends ExecutingControler {
        private SimpleCommandExecuter simpleExecuter;
        private SimpleParser parser;
        private BufferedOutputStream bout;
        private File workingDir;
        private boolean deleteSequences = true;
        private String baseFileName;
        boolean encodeStarted;
        boolean encodeFinished;

        public void afterExecute() {
            this.simpleExecuter = null;
            this.parser = null;
            this.bout = null;
            log.info((Object)("delete workdir" + this.workingDir));
            if (this.deleteSequences) {
                this.clearExportDir();
            }
            TextDougaView.this.updatePlayButton();
        }

        public void beforeExecute() {
            log.info((Object)"beforeExecute");
            this.baseFileName = TextDougaView.this.baseName.getText();
            TextDougaView.this.outputPath = TextDougaView.this.outputFileChooser.getAbsoluteFilePath();
            TextDougaView.this.dText = TextDougaView.this.dougaText.getText();
            TextDougaView.this.iFile = TextDougaView.this.textDougaApplication.getFile();
            log.info((Object)TextDougaView.this.iFile);
            log.info((Object)TextDougaView.this.dText);
        }

        public boolean canExecute() {
            return !TextDougaView.this.outputFileChooser.getAbsoluteFilePath().equals("") && TextDougaView.this.dougaText.getText().length() > 0;
        }

        public void cancelExecuting() {
            Process process;
            DougaSystem.cancelling = true;
            if (this.parser != null) {
                this.parser.setCancelling(true);
            }
            if (this.bout != null) {
                try {
                    this.bout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.simpleExecuter != null && (process = this.simpleExecuter.getProcess()) != null) {
                process.destroy();
            }
        }

        public void clearExportDir() {
            String[] v;
            if (this.workingDir != null && (v = this.workingDir.list()) != null) {
                int i = 0;
                while (i < v.length) {
                    if (v[i].endsWith(".jpg") || v[i].endsWith(".pcm")) {
                        new File(this.workingDir, v[i]).delete();
                    } else if (v[i].endsWith(".avi")) {
                        new File(this.workingDir, v[i]).delete();
                    } else {
                        log.info((Object)("other remain:" + v[i]));
                    }
                    ++i;
                }
            }
        }

        public void inExecute() {
            String[] options;
            int i;
            String[] ffcommand;
            File file;
            String size;
            this.encodeFinished = false;
            this.encodeStarted = false;
            long startTime = System.currentTimeMillis();
            DougaSystem.setDougaLogger(TextDougaView.this.dougaLogger);
            String finalReport = "";
            String ffmpegPath = FFMpegUI.getFFmpegOrPureFFMpeg();
            if (ffmpegPath == null) {
                TextDougaView.this.dougaLogger.error(Messages.getString("log.no_ffmpeg"));
                TextDougaView.this.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                return;
            }
            String trueFFMpegPath = FFMpegUI.getFFmpeg();
            String videoCodec = Activator.getDefault().getPreferenceStore().getString("textdouga.avisetting.video");
            String audioCodec = Activator.getDefault().getPreferenceStore().getString("textdouga.avisetting.audio");
            log.info((Object)videoCodec);
            log.info((Object)audioCodec);
            if (!ffmpegPath.equals(trueFFMpegPath)) {
                boolean error = false;
                if (!FFMpegUI.isPureFFMpegSupportedVideoCodec((String)videoCodec)) {
                    TextDougaView.this.dougaLogger.warn(Messages.getString("log.not_supported_video"));
                    error = true;
                }
                if (!FFMpegUI.isPureFFMpegSupportedAudioCodec((String)audioCodec)) {
                    TextDougaView.this.dougaLogger.warn(Messages.getString("log.not_supported_audio"));
                }
                if (error) {
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
            }
            String fpsv = Activator.getDefault().getPreferenceStore().getString("textdouga.video_fps");
            double fps = 30.0;
            if (!fpsv.equals("")) {
                if (fpsv.equals("textdouga.video_fps.other")) {
                    fpsv = Activator.getDefault().getPreferenceStore().getString("textdouga.video_fps.other");
                }
                try {
                    fps = Double.parseDouble(fpsv);
                }
                catch (Exception exception) {
                    DougaSystem.dougaLogger.warn(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga_wrong_fps"));
                    fps = 30.0;
                }
            }
            if ((size = Activator.getDefault().getPreferenceStore().getString("textdouga.video_size")).equals("textdouga.video_size.other")) {
                size = Activator.getDefault().getPreferenceStore().getString("textdouga.video_size.other");
            }
            int[] w_h = null;
            try {
                w_h = FFMpegUtils.sizeToWidthHeight((String)size);
            }
            catch (Exception exception) {}
            if (w_h == null) {
                DougaSystem.dougaLogger.warn(jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga_wrong_size"));
                w_h = new int[]{320, 240};
            }
            String youtubeDLPath = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.exe");
            String youtubeDLPyPath = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.py");
            String pythonPath = PlatformUI.getPreferenceStore().getString("youtubedl.path_python");
            if (youtubeDLPath.equals("") && (youtubeDLPyPath.equals("") || pythonPath.equals(""))) {
                TextDougaView.this.dougaLogger.warn(Messages.getString("log.no_youtubedl"));
            }
            String dir = String.valueOf(System.getProperty("user.dir")) + "\\" + TextDougaView.WORKING_DIR;
            File downloaded = new File(dir, TextDougaView.DOWNLOADED_DIR);
            this.workingDir = new File(dir, TextDougaView.SEQUENCE_DIR);
            this.workingDir.mkdirs();
            this.clearExportDir();
            File pcm = new File(this.workingDir, "audio.pcm");
            File workingAvi = new File(this.workingDir, "video.avi");
            if (this.baseFileName.equals("")) {
                this.baseFileName = Messages.getString("textdouga.default_export_video");
            }
            File outputVideo = new File(TextDougaView.this.outputPath, String.valueOf(this.baseFileName) + ".avi");
            String audioExtension = FFMpegUtils.audioCodecToExtension((String)audioCodec);
            if (audioExtension == null) {
                log.warn((Object)("invalid audioCodec:" + audioCodec));
                DougaSystem.dougaLogger.info("invalid audioCodec:" + audioCodec);
                DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                return;
            }
            File outputAudio = new File(TextDougaView.this.outputPath, String.valueOf(this.baseFileName) + "." + audioExtension);
            long l = System.currentTimeMillis() / 1000L;
            File tmpVideoOutput = new File(outputVideo.getParent(), String.valueOf(l) + "_" + outputVideo.getName());
            File tmpAudioOutput = new File(outputVideo.getParent(), String.valueOf(l) + "_" + outputAudio.getName());
            DougaPreference dougaPreference = new DougaPreference();
            dougaPreference.setFps(fps);
            dougaPreference.setWidth(w_h[0]);
            dougaPreference.setHeight(w_h[1]);
            dougaPreference.setFfmpegPath(ffmpegPath);
            log.info((Object)("wh=" + dougaPreference.getWidth() + "," + dougaPreference.getHeight()));
            String fpath = "";
            this.parser = new SimpleParser(ffmpegPath, downloaded, null, youtubeDLPath);
            File inputDir = new File(System.getProperty("user.dir"));
            if (TextDougaView.this.iFile != null) {
                inputDir = TextDougaView.this.iFile.getParentFile();
                fpath = TextDougaView.this.iFile.getAbsolutePath();
            }
            DougaSystem.setDougaLogger(TextDougaView.this.dougaLogger);
            TextDougaView.this.dougaLogger.trace(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.start_text_douga")) + " " + fpath);
            DougaSystem system = null;
            try {
                system = this.parser.parseTextDouga(TextDougaView.this.dText, inputDir, dougaPreference);
                fps = system.getVideoSystem().getDougaPreference().getFps();
                if (system == null) {
                    log.info((Object)"System is null");
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
            }
            catch (IOException e1) {
                DougaSystem.dougaLogger.warn(e1.getMessage());
                e1.printStackTrace();
                DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                return;
            }
            log.info((Object)("parse finished: fps=" + fps + ",w=" + system.getVideoSystem().getDougaPreference().getWidth() + " height=" + system.getVideoSystem().getDougaPreference().getHeight()));
            TextDougaView.this.processVideo = TextDougaView.this.defaultProcessVideo;
            TextDougaView.this.processAudio = TextDougaView.this.defaultProcessAudio;
            if (system.getVideoSystem().getVideoDatas().length == 0) {
                TextDougaView.this.dougaLogger.warn(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.novideo"));
                TextDougaView.this.processVideo = false;
            }
            if (system.getAudioSystem().getAudioDatas().length == 0) {
                TextDougaView.this.dougaLogger.warn(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.noaudio"));
                TextDougaView.this.processAudio = false;
            }
            if (!TextDougaView.this.processVideo && !TextDougaView.this.processAudio) {
                DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.nothing_todo"));
                return;
            }
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            if (this.isCanceling()) {
                DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                return;
            }
            ConvertResult convertResult = null;
            if (TextDougaView.this.exportType == 2) {
                File imageExportDir = new File(TextDougaView.this.outputPath, this.baseFileName);
                if (TextDougaView.this.processVideo) {
                    String newName;
                    boolean r;
                    File oldDir = new File(TextDougaView.this.outputPath, this.baseFileName);
                    if (oldDir.exists() && !(r = oldDir.renameTo(new File(newName = FileNameUtils.getNotFoundFileName((File)oldDir))))) {
                        DougaSystem.dougaLogger.warn(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.dir_rename_faild"));
                    }
                    imageExportDir.mkdir();
                    if (!imageExportDir.exists()) {
                        log.info((Object)("can't make dir " + imageExportDir));
                        DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                        return;
                    }
                    finalReport = String.valueOf(finalReport) + jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.image_dir") + ":" + imageExportDir.getName() + "\r\n";
                }
                if ((convertResult = this.convertImageBased(system, ffmpegPath, pcm, fps, videoCodec, audioCodec, imageExportDir, store)) == null) {
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
                if (!convertResult.isSuccessed()) {
                    log.info((Object)"image faild");
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
            } else if (Activator.getDefault().getPreferenceStore().getBoolean("textdouga.use_high_speed")) {
                convertResult = this.convertSpeedBased(system, ffmpegPath, pcm, fps, videoCodec, audioCodec, workingAvi, store);
                if (convertResult == null) {
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
                if (!convertResult.isSuccessed()) {
                    log.info((Object)"high speed faild");
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
            } else {
                convertResult = this.convertQualityBased(system, ffmpegPath, pcm, fps, videoCodec, audioCodec, tmpVideoOutput);
                if (convertResult == null) {
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
                if (!convertResult.isSuccessed()) {
                    log.info((Object)"quality faild");
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
            }
            log.info((Object)("convertResult:video=" + convertResult.getVideoPath()));
            log.info((Object)("convertResult:audio=" + convertResult.getAudioPath()));
            if (convertResult.getVideoPath() == null && convertResult.getAudioPath() != null) {
                if (convertResult.getAudioPath() != null) {
                    this.encodeAudio(ffmpegPath, convertResult.getAudioPath(), audioCodec, store, tmpAudioOutput);
                }
            } else if (TextDougaView.this.exportType == 0) {
                file = new File(convertResult.getVideoPath());
                ffcommand = null;
                if (file.isFile()) {
                    if (convertResult.getAudioPath() == null) {
                        boolean r = false;
                        i = 0;
                        while (i < 120) {
                            r = workingAvi.renameTo(tmpVideoOutput);
                            log.info((Object)("tried rename:" + (i + 1)));
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (r) break;
                            ++i;
                        }
                        if (!r) {
                            log.warn((Object)("avi:rename faild:" + tmpVideoOutput));
                            DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                            return;
                        }
                    } else {
                        TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.muxing_videos"));
                        ffcommand = FFMpegCommandUtil.makeMuxPCMAndVideoCommand((String)ffmpegPath, (String)convertResult.getVideoPath(), (String)convertResult.getAudioPath(), (String)"copy", (String)audioCodec, (String[])new String[]{"-ab", String.valueOf(store.getString("textdouga.audio_bitrate")) + "k", "-ar", store.getString("textdouga.audio_samplerate"), "-ac", store.getString("textdouga.audio_channel")}, (String)tmpVideoOutput.getAbsolutePath());
                    }
                } else {
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.muxing_videos"));
                    options = videoCodec.equals("xvid") ? new String[]{"-b", String.valueOf(store.getString("textdouga.video_bitrate")) + "k", "-vtag", "XVID", "-ab", String.valueOf(store.getString("textdouga.audio_bitrate")) + "k", "-ar", store.getString("textdouga.audio_samplerate"), "-ac", store.getString("textdouga.audio_channel")} : new String[]{"-b", String.valueOf(store.getString("textdouga.video_bitrate")) + "k", "-ab", String.valueOf(store.getString("textdouga.audio_bitrate")) + "k", "-ar", store.getString("textdouga.audio_samplerate"), "-ac", store.getString("textdouga.audio_channel")};
                    ffcommand = FFMpegCommandUtil.makeJpegInputCommand((String)ffmpegPath, (String)convertResult.getVideoPath(), (String)"", (int)5, (String)".jpg", (String)("" + fps), (String)convertResult.getAudioPath(), (String)videoCodec, (String)audioCodec, (String[])options, (String)tmpVideoOutput.getAbsolutePath());
                }
                if (ffcommand != null) {
                    int i2 = 0;
                    while (i2 < ffcommand.length) {
                        System.out.print("\"" + ffcommand[i2] + "\"" + " ");
                        ++i2;
                    }
                    PrintWriterPrinter printer = new PrintWriterPrinter(System.out);
                    this.simpleExecuter = new SimpleCommandExecuter(ffcommand);
                    this.simpleExecuter.setPrinter((ProcessPrinter)printer);
                    this.simpleExecuter.execute();
                }
            } else if (TextDougaView.this.exportType == 1) {
                file = new File(convertResult.getVideoPath());
                ffcommand = null;
                if (file.isFile()) {
                    boolean r = false;
                    i = 0;
                    while (i < 120) {
                        r = workingAvi.renameTo(tmpVideoOutput);
                        log.info((Object)("tried rename:" + (i + 1)));
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (r) break;
                        ++i;
                    }
                    if (!r) {
                        log.warn((Object)("video_audio:rename faild:" + tmpVideoOutput));
                        DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                        return;
                    }
                    if (convertResult.getAudioPath() != null) {
                        this.encodeAudio(ffmpegPath, convertResult.getAudioPath(), audioCodec, store, tmpAudioOutput);
                    }
                } else {
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.muxing_videos"));
                    options = new String[]{"-b", String.valueOf(store.getString("textdouga.video_bitrate")) + "k", "-ab", String.valueOf(store.getString("textdouga.audio_bitrate")) + "k", "-ar", store.getString("textdouga.audio_samplerate"), "-ac", store.getString("textdouga.audio_channel")};
                    ffcommand = FFMpegCommandUtil.makeJpegInputCommand((String)ffmpegPath, (String)convertResult.getVideoPath(), (String)"", (int)5, (String)".jpg", (String)("" + fps), null, (String)videoCodec, (String)audioCodec, (String[])options, (String)tmpVideoOutput.getAbsolutePath());
                    i = 0;
                    while (i < ffcommand.length) {
                        System.out.print("\"" + ffcommand[i] + "\"" + " ");
                        ++i;
                    }
                    PrintWriterPrinter printer = new PrintWriterPrinter(System.out);
                    this.simpleExecuter = new SimpleCommandExecuter(ffcommand);
                    this.simpleExecuter.setPrinter((ProcessPrinter)printer);
                    this.simpleExecuter.execute();
                }
                if (this.isCanceling()) {
                    DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                    return;
                }
                if (convertResult.getAudioPath() != null) {
                    this.encodeAudio(ffmpegPath, convertResult.getAudioPath(), audioCodec, store, tmpAudioOutput);
                }
            } else if (TextDougaView.this.exportType == 2 && convertResult.getAudioPath() != null) {
                this.encodeAudio(ffmpegPath, convertResult.getAudioPath(), audioCodec, store, tmpAudioOutput);
            }
            if (this.isCanceling()) {
                DougaSystem.dougaLogger.info(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.cancelled"));
                return;
            }
            TextDougaView.this.dougaLogger.trace(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.finished")) + "\r\n");
            boolean faild = false;
            if (TextDougaView.this.processVideo && TextDougaView.this.exportType != 2) {
                boolean b;
                if (outputVideo.exists()) {
                    String newName = FileNameUtils.getNotFoundFileName((File)outputVideo);
                    outputVideo.renameTo(new File(newName));
                }
                if (!(b = tmpVideoOutput.renameTo(outputVideo))) {
                    TextDougaView.this.dougaLogger.error(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.rename_faild")) + ":" + tmpVideoOutput);
                    faild = true;
                    finalReport = String.valueOf(finalReport) + jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.video_file") + ":" + tmpVideoOutput.getName() + "\r\n";
                } else {
                    finalReport = String.valueOf(finalReport) + jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.video_file") + ":" + outputVideo.getName() + "\r\n";
                }
            }
            if (TextDougaView.this.processAudio && (TextDougaView.this.exportType != 0 || !TextDougaView.this.processVideo)) {
                boolean b;
                if (outputAudio.exists()) {
                    String newName = FileNameUtils.getNotFoundFileName((File)outputAudio);
                    outputAudio.renameTo(new File(newName));
                }
                if (!(b = tmpAudioOutput.renameTo(outputAudio))) {
                    TextDougaView.this.dougaLogger.error(String.valueOf(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.rename_faild")) + ":" + tmpAudioOutput);
                    faild = true;
                    finalReport = String.valueOf(finalReport) + jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.audio_file") + ":" + tmpAudioOutput.getName() + "\r\n";
                } else {
                    finalReport = String.valueOf(finalReport) + jp.sourceforge.akjrcp.text_douga.Messages.getString("textdouga.audio_file") + ":" + outputAudio.getName() + "\r\n";
                }
            }
            TextDougaView.this.dougaLogger.trace(finalReport);
            long end = System.currentTimeMillis();
            int sec = (int)((end - startTime) / 1000L);
            TextDougaView.this.dougaLogger.info(String.valueOf(Messages.getString("textdouga.complete")) + " time: " + sec + " sec" + "\r\n");
            if (faild) {
                return;
            }
        }

        private void encodeAudio(String ffmpegPath, String pcmPath, String audioCodec, IPreferenceStore store, File finalOutput) {
            String[] options = FFMpegCommandUtil.makePCMInputCommand((String)ffmpegPath, (String)pcmPath, (String)audioCodec, (String[])new String[]{"-ab", String.valueOf(store.getString("textdouga.audio_bitrate")) + "k", "-ar", store.getString("textdouga.audio_samplerate"), "-ac", store.getString("textdouga.audio_channel")}, (String)finalOutput.getAbsolutePath());
            PrintWriterPrinter printer = new PrintWriterPrinter(System.out);
            this.simpleExecuter = new SimpleCommandExecuter(options);
            this.simpleExecuter.setPrinter((ProcessPrinter)printer);
            this.simpleExecuter.execute();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ConvertResult convertSpeedBased(DougaSystem system, String ffmpegPath, File pcm, double fps, String videoCodec, String audioCodec, File tmpOutput, IPreferenceStore store) {
            log.info((Object)"start convertSpeedBased");
            ConvertResult converResult = new ConvertResult();
            log.warn((Object)("encodeStarted:" + this.encodeStarted));
            try {
                if (TextDougaView.this.processVideo) {
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.create_video_sequence"));
                    String[] options = videoCodec.equals("xvid") ? new String[]{"-vcodec", videoCodec, "-b", String.valueOf(store.getString("textdouga.video_bitrate")) + "k", "-vtag", "XVID", "-an"} : new String[]{"-vcodec", videoCodec, "-b", String.valueOf(store.getString("textdouga.video_bitrate")) + "k", "-an"};
                    FFMpegJpegPipeWriter ffwriter = new FFMpegJpegPipeWriter(ffmpegPath, true, new String[]{"-r", "" + fps}, options, tmpOutput.getAbsolutePath());
                    ffwriter.setProcessListener(new ProcessListener(){

                        public void finished() {
                            TextDougaExecute.this.encodeFinished = true;
                        }

                        public void started() {
                            TextDougaExecute.this.encodeStarted = true;
                        }
                    });
                    new Thread((Runnable)ffwriter).start();
                    long waitStart1 = System.currentTimeMillis();
                    while (!this.encodeStarted) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (System.currentTimeMillis() > waitStart1 + 30000L) {
                            log.warn((Object)"faild started");
                            break;
                        }
                        log.info((Object)"wait start");
                    }
                    log.info((Object)"video write");
                    PipedVideoWriter videoWriter = new PipedVideoWriter(system.getVideoSystem().getDougaPreference(), ffwriter.getJpegPipeWriter(), this.workingDir);
                    videoWriter.setItemDatas(system.getVideoSystem().getSortedItemDatas());
                    videoWriter.setEffectDatas(system.getVideoSystem().getEffectDatas());
                    system.getVideoSystem().writeDatas(videoWriter);
                    converResult.setVideoPath(tmpOutput.getAbsolutePath());
                    long maxwait = 30000L;
                    long waitStart = System.currentTimeMillis();
                    while (!this.encodeFinished) {
                        if (this.isCanceling()) {
                            return null;
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        log.info((Object)"wait finish");
                        if (waitStart + maxwait >= System.currentTimeMillis()) continue;
                        log.warn((Object)"over time wait finish:maybe cancelled");
                        break;
                    }
                    while (!tmpOutput.exists()) {
                        if (this.isCanceling()) {
                            return null;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        log.info((Object)"wait finish file");
                        if (waitStart + maxwait >= System.currentTimeMillis()) continue;
                        log.warn((Object)"over time wait finish:maybe cancelled");
                        break;
                    }
                }
                if (TextDougaView.this.processAudio) {
                    if (this.isCanceling()) {
                        return null;
                    }
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.create_audio_sequence"));
                    FileOutputStream aout = new FileOutputStream(pcm);
                    system.getAudioSystem().writeDatas(aout);
                    converResult.setAudioPath(pcm.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.canceldExecute();
                return null;
            }
            this.encodeStarted = false;
            converResult.setSuccessed(true);
            return converResult;
        }

        private ConvertResult convertImageBased(DougaSystem system, String ffmpegPath, File pcm, double fps, String videoCodec, String audioCodec, File exportDir, IPreferenceStore store) {
            ConvertResult converResult = new ConvertResult();
            try {
                if (TextDougaView.this.processVideo) {
                    DirectoryVideoWriter videoWriter = new DirectoryVideoWriter(exportDir, this.workingDir);
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.create_video_sequence"));
                    VideoOutInfo[] infos = system.getVideoSystem().writeDatas(videoWriter);
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.insert_item_and_effect"));
                    system.getVideoSystem().writeItemAndEffect(videoWriter.getExportDir(), infos);
                    converResult.setVideoPath(exportDir.getAbsolutePath());
                }
                if (TextDougaView.this.processAudio) {
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.create_audio_sequence"));
                    FileOutputStream aout = new FileOutputStream(pcm);
                    system.getAudioSystem().writeDatas(aout);
                    converResult.setAudioPath(pcm.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.encodeStarted = false;
            converResult.setSuccessed(true);
            return converResult;
        }

        private ConvertResult convertQualityBased(DougaSystem system, String ffmpegPath, File pcm, double fps, String videoCodec, String audioCodec, File tmpOutput) {
            ConvertResult converResult = new ConvertResult();
            try {
                if (TextDougaView.this.processVideo) {
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.create_video_sequence"));
                    VideoOutInfo[] infos = system.getVideoSystem().writeDatas(this.workingDir);
                    if (this.isCanceling()) {
                        return converResult;
                    }
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.insert_item_and_effect"));
                    system.getVideoSystem().writeItemAndEffect(this.workingDir, infos);
                    if (this.isCanceling()) {
                        return converResult;
                    }
                    converResult.setVideoPath(this.workingDir.getAbsolutePath());
                }
                if (TextDougaView.this.processAudio) {
                    TextDougaView.this.dougaLogger.trace(jp.sourceforge.akjrcp.text_douga.Messages.getString("log.create_audio_sequence"));
                    this.bout = new BufferedOutputStream(new FileOutputStream(pcm));
                    system.getAudioSystem().writeDatas(this.bout);
                    if (this.isCanceling()) {
                        return converResult;
                    }
                    converResult.setAudioPath(pcm.getAbsolutePath());
                }
            }
            catch (IOException e) {
                TextDougaView.this.dougaLogger.error(e.getMessage());
                e.printStackTrace();
            }
            if (this.isCanceling()) {
                return converResult;
            }
            converResult.setSuccessed(true);
            return converResult;
        }

        public class ConvertResult {
            private String videoPath;
            private String audioPath;
            private boolean successed;

            public String getAudioPath() {
                return this.audioPath;
            }

            public void setAudioPath(String audioPath) {
                this.audioPath = audioPath;
            }

            public boolean isSuccessed() {
                return this.successed;
            }

            public void setSuccessed(boolean successed) {
                this.successed = successed;
            }

            public String getVideoPath() {
                return this.videoPath;
            }

            public void setVideoPath(String videoPath) {
                this.videoPath = videoPath;
            }
        }
    }
}

