/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public final class ServiceLocator
implements IDisposable,
INestable,
IServiceLocator {
    private final IServiceLocator parent;
    private Map services = null;

    public ServiceLocator() {
        this(null);
    }

    public ServiceLocator(IServiceLocator parent) {
        this.parent = parent;
    }

    public final void activate() {
        if (this.services != null) {
            Iterator serviceItr = this.services.values().iterator();
            while (serviceItr.hasNext()) {
                Object service = serviceItr.next();
                if (!(service instanceof INestable)) continue;
                INestable nestableService = (INestable)service;
                nestableService.activate();
            }
        }
    }

    public final void deactivate() {
        if (this.services != null) {
            Iterator serviceItr = this.services.values().iterator();
            while (serviceItr.hasNext()) {
                Object service = serviceItr.next();
                if (!(service instanceof INestable)) continue;
                INestable nestableService = (INestable)service;
                nestableService.deactivate();
            }
        }
    }

    public final void dispose() {
        if (this.services != null) {
            Iterator serviceItr = this.services.values().iterator();
            while (serviceItr.hasNext()) {
                Object object = serviceItr.next();
                if (!(object instanceof IDisposable)) continue;
                IDisposable service = (IDisposable)object;
                service.dispose();
            }
            this.services = null;
        }
    }

    public final Object getService(Class key) {
        Object service = this.services != null ? this.services.get(key) : null;
        if (service == null && this.parent != null) {
            return this.parent.getService(key);
        }
        return service;
    }

    public final boolean hasService(Class key) {
        return this.services != null && this.services.containsKey(key);
    }

    public final void registerService(Class api, Object service) {
        Object currentService;
        if (api == null) {
            throw new NullPointerException("The service key cannot be null");
        }
        if (!api.isInstance(service)) {
            throw new IllegalArgumentException("The service does not implement the given interface");
        }
        if (this.services == null) {
            this.services = new HashMap();
        }
        if (this.services.containsKey(api) && (currentService = this.services.remove(api)) instanceof IDisposable) {
            IDisposable disposable = (IDisposable)currentService;
            disposable.dispose();
        }
        if (service == null) {
            if (this.services.isEmpty()) {
                this.services = null;
            }
        } else {
            this.services.put(api, service);
        }
    }
}

