/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;

class FiltersContentProvider
implements IStructuredContentProvider {
    private static List definedFilters;
    private static List defaultFilters;
    private ResourcePatternFilter resourceFilter;

    public FiltersContentProvider(ResourcePatternFilter filter) {
        this.resourceFilter = filter;
    }

    public void dispose() {
    }

    public static List getDefaultFilters() {
        if (defaultFilters == null) {
            FiltersContentProvider.readFilters();
        }
        return defaultFilters;
    }

    public static List getDefinedFilters() {
        if (definedFilters == null) {
            FiltersContentProvider.readFilters();
        }
        return definedFilters;
    }

    public Object[] getElements(Object inputElement) {
        return FiltersContentProvider.getDefinedFilters().toArray();
    }

    public String[] getInitialSelections() {
        return this.resourceFilter.getPatterns();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static void readFilters() {
        definedFilters = new ArrayList();
        defaultFilters = new ArrayList();
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("resourceFilters");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String selected;
                    String pattern = configElements[j].getAttribute("pattern");
                    if (pattern != null) {
                        definedFilters.add(pattern);
                    }
                    if ((selected = configElements[j].getAttribute("selected")) != null && selected.equalsIgnoreCase("true")) {
                        defaultFilters.add(pattern);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

