/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.audio;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.audio.AudioUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileAudioData
implements AudioData {
    public static Log log = LogFactory.getLog(FileAudioData.class);
    private double synchLength;
    private int loop;
    private double startTime;
    private double duration;
    private double loopPadTime;
    private String inputPath;
    private boolean canStopInLoop = true;
    private double logicalTime;
    private boolean synch;

    public FileAudioData(String inputPath) {
        this.inputPath = inputPath;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public double getSyncLength() {
        return this.synchLength;
    }

    @Override
    public void setSynchLength(double logicalLength) {
        this.synchLength = logicalLength;
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        this.loop = loop;
    }

    public double getLoopPadTime() {
        return this.loopPadTime;
    }

    public void setLoopPadTime(double loopPadTime) {
        this.loopPadTime = loopPadTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public boolean isSyncLength() {
        return this.synch;
    }

    @Override
    public void setSynch(boolean fitLogicalLength) {
        this.synch = fitLogicalLength;
    }

    public boolean isCanStopInLoop() {
        return this.canStopInLoop;
    }

    public void setCanStopInLoop(boolean canStopInLoop) {
        this.canStopInLoop = canStopInLoop;
    }

    private double getWriteDuration() {
        double dr = -1.0;
        if (this.getDuration() <= 0.0) {
            dr = new BigDecimal("" + this.getLogicalTime()).subtract(new BigDecimal("" + this.startTime)).doubleValue();
            if (this.isSyncLength()) {
                dr = this.getSyncLength();
            }
            if (dr <= 0.0) {
                log.warn((Object)"duration is  0: maybe video is 0");
                return 0.0;
            }
        } else {
            dr = this.getDuration();
        }
        return dr;
    }

    @Override
    public long writeData(DougaPreference preference, OutputStream outputStream, long maxbytes) throws IOException {
        long writed = 0L;
        if (this.getLoop() > 0 || this.getLoop() == -1) {
            if (maxbytes <= 0L && this.getLoop() == -1) {
                log.warn((Object)("never stop:" + this));
                return 0L;
            }
            double dr = this.getWriteDuration();
            log.info((Object)("inloop:writed=:" + dr + "duration=" + this.duration + " sync=" + this.getSyncLength() + " logical=" + this.getLogicalTime()));
            writed = AudioUtils.loopAudio(preference.getFfmpegPath(), this.getInputPath(), this.getStartTime(), dr, this.getLoop(), this.getLoopPadTime(), this.isCanStopInLoop(), maxbytes, outputStream);
        } else {
            double dr = this.getWriteDuration();
            log.info((Object)("incopy:dr=" + dr + "duration=" + this.duration + " sync=" + this.getSyncLength() + " logical=" + this.getLogicalTime()));
            writed = AudioUtils.copyAudio(preference.getFfmpegPath(), this.getInputPath(), this.getStartTime(), dr, outputStream);
        }
        return writed;
    }

    @Override
    public double getTotalTime() {
        double d;
        if (this.loop == -1) {
            return -1.0;
        }
        int lo = 1;
        if (this.loop > 1) {
            lo = this.loop;
        }
        if ((d = this.duration) == 0.0) {
            d = this.logicalTime;
        }
        return d * (double)lo + (double)(lo - 1) * this.loopPadTime;
    }

    public double getLogicalTime() {
        return this.logicalTime;
    }

    public void setLogicalTime(double logitalLength) {
        this.logicalTime = logitalLength;
    }

    public String toString() {
        return "start=" + this.startTime + " duration=" + this.duration + " loop=" + this.loop + " canStopInLoop=" + this.canStopInLoop + " inputPath=" + this.inputPath + " synctime=" + this.synchLength + " logicaltime=" + this.logicalTime;
    }
}

