/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.ui;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DirectoryList {
    private Table table;
    private FilenameFilter filenameFilter;
    private File baseDirectory;
    private Image fileImage;
    private Image folderImage;

    public String[] getColumnTexts() {
        String[] names = new String[this.table.getColumnCount()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.table.getColumn(i).getText();
            ++i;
        }
        return names;
    }

    public void updateDirectory() {
        String[] list = null;
        list = this.filenameFilter != null ? this.baseDirectory.list(this.filenameFilter) : this.baseDirectory.list();
        String[] columns = this.getColumnTexts();
        int i = 0;
        while (i < list.length) {
            if (!this.isExist(columns, list[i])) {
                this.addFile(new File(this.baseDirectory, list[i]));
            }
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            if (!this.isExist(list, columns[i])) {
                this.removeFile(columns[i]);
            }
            ++i;
        }
    }

    private void removeFile(String name) {
        String[] names = new String[this.table.getColumnCount()];
        int i = 0;
        while (i < names.length) {
            if (name.equals(this.table.getColumn(i).getText())) {
                this.table.remove(i);
            }
            ++i;
        }
    }

    boolean isExist(String[] base, String name) {
        int i = 0;
        while (i < base.length) {
            if (base[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addFile(File file) {
        Image img = this.chooseImage(file);
        TableItem item = new TableItem(this.table, 0);
        item.setText(file.getName());
        item.setImage(img);
    }

    public Image chooseImage(File file) {
        if (file.isDirectory()) {
            return this.folderImage;
        }
        return this.fileImage;
    }
}

