/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.pool.composite.CompositeKeyedObjectPool;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.Manager;

abstract class AbstractManager
implements Manager,
Serializable {
    private static final long serialVersionUID = -1729636795986138892L;
    private static final Timer DEFER_TIMER;
    private static final long DEFER_DELAY = 20L;
    protected CompositeObjectPool objectPool;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractManager() {
    }

    public void setCompositeObjectPool(CompositeObjectPool objectPool) {
        if (this.objectPool != null) {
            throw new IllegalStateException("Manager cannot be reattached.");
        }
        if (objectPool == null) {
            throw new IllegalArgumentException("objectPool must not be null.");
        }
        this.objectPool = objectPool;
    }

    public abstract Object nextFromPool() throws Exception;

    public void returnToPool(Object obj) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.objectPool.getPool())) {
            throw new AssertionError();
        }
        this.objectPool.getLender().repay(obj);
    }

    protected void deferDestroyObject(Object obj) {
        CompositeKeyedObjectPool ckop = this.objectPool.getOwningCompositeKeyedObjectPool();
        if (ckop != null) {
            Object key = ckop.getKeys().get();
            DEFER_TIMER.schedule((TimerTask)new DeferredKeyedDestroyTask(key, obj), 20L);
        } else {
            DEFER_TIMER.schedule((TimerTask)new DeferredDestroyTask(obj), 20L);
        }
    }

    static {
        $assertionsDisabled = !AbstractManager.class.desiredAssertionStatus();
        DEFER_TIMER = CompositeObjectPool.COMPOSITE_TIMER;
    }

    private class DeferredKeyedDestroyTask
    extends TimerTask {
        private final Object key;
        private final Object obj;

        DeferredKeyedDestroyTask(Object key, Object obj) {
            this.key = key;
            this.obj = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadLocal keys = null;
            try {
                keys = AbstractManager.this.objectPool.getOwningCompositeKeyedObjectPool().getKeys();
                keys.set(this.key);
                AbstractManager.this.objectPool.getFactory().destroyObject(this.obj);
            }
            catch (Exception exception) {
            }
            finally {
                if (keys != null) {
                    keys.set(null);
                }
            }
        }
    }

    private class DeferredDestroyTask
    extends TimerTask {
        private final Object obj;

        DeferredDestroyTask(Object obj) {
            this.obj = obj;
        }

        public void run() {
            try {
                AbstractManager.this.objectPool.getFactory().destroyObject(this.obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

