/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.composite.CompositeKeyedObjectPool;
import org.apache.commons.pool.composite.CompositeObjectPoolFactory;
import org.apache.commons.pool.composite.Lender;
import org.apache.commons.pool.composite.Manager;
import org.apache.commons.pool.composite.Tracker;

final class CompositeObjectPool
implements ObjectPool,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5874499972956918952L;
    static final Timer COMPOSITE_TIMER = new Timer(true);
    private final PoolableObjectFactory factory;
    private final transient List pool;
    private final Lender lender;
    private final Manager manager;
    private final Tracker tracker;
    private final boolean validateOnReturn;
    private volatile boolean open = true;
    private final CompositeObjectPoolFactory.FactoryConfig factoryConfig;
    private CompositeKeyedObjectPool owningCompositeKeyedObjectPool = null;

    CompositeObjectPool(PoolableObjectFactory factory, Manager manager, Lender lender, Tracker tracker, boolean validateOnReturn) {
        this(factory, manager, lender, tracker, validateOnReturn, null);
    }

    CompositeObjectPool(PoolableObjectFactory factory, Manager manager, Lender lender, Tracker tracker, boolean validateOnReturn, CompositeObjectPoolFactory.FactoryConfig factoryConfig) {
        this(factory, new LinkedList(), manager, lender, tracker, validateOnReturn, factoryConfig);
    }

    CompositeObjectPool(PoolableObjectFactory factory, List pool, Manager manager, Lender lender, Tracker tracker, boolean validateOnReturn, CompositeObjectPoolFactory.FactoryConfig factoryConfig) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null.");
        }
        if (pool == null) {
            throw new IllegalArgumentException("pool cannot be null.");
        }
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null.");
        }
        if (lender == null) {
            throw new IllegalArgumentException("lender cannot be null.");
        }
        if (tracker == null) {
            throw new IllegalArgumentException("tracker cannot be null.");
        }
        this.factory = factory;
        this.pool = pool;
        this.manager = manager;
        this.lender = lender;
        this.tracker = tracker;
        this.validateOnReturn = validateOnReturn;
        this.factoryConfig = factoryConfig;
        this.updateCompositeObjectPools();
    }

    private void updateCompositeObjectPools() {
        this.lender.setCompositeObjectPool(this);
        this.manager.setCompositeObjectPool(this);
    }

    Lender getLender() {
        return this.lender;
    }

    PoolableObjectFactory getFactory() {
        return this.factory;
    }

    List getPool() {
        return this.pool;
    }

    void setOwningCompositeKeyedObjectPool(CompositeKeyedObjectPool ckop) {
        if (this.owningCompositeKeyedObjectPool != null) {
            throw new IllegalStateException("CompositeObjectPools cannot change ownership.");
        }
        this.owningCompositeKeyedObjectPool = ckop;
    }

    CompositeKeyedObjectPool getOwningCompositeKeyedObjectPool() {
        return this.owningCompositeKeyedObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject() throws Exception {
        this.assertOpen();
        Object obj = this.factory.makeObject();
        this.factory.passivateObject(obj);
        List list = this.pool;
        synchronized (list) {
            if (this.isOpen()) {
                this.manager.returnToPool(obj);
            } else {
                this.factory.destroyObject(obj);
            }
        }
    }

    public Object borrowObject() throws Exception {
        this.assertOpen();
        return this.internalBorrowObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalBorrowObject() throws Exception {
        Object obj;
        List list = this.pool;
        synchronized (list) {
            obj = this.manager.nextFromPool();
            this.tracker.borrowed(obj);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) {
        if (this.validateOnReturn && !this.factory.validateObject(obj)) {
            this.invalidateObject(obj);
            return;
        }
        try {
            this.factory.passivateObject(obj);
        }
        catch (Exception e) {
            this.invalidateObject(obj);
            return;
        }
        List list = this.pool;
        synchronized (list) {
            if (this.isOpen()) {
                this.tracker.returned(obj);
                this.manager.returnToPool(obj);
            } else {
                this.invalidateObject(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object obj) {
        List list = this.pool;
        synchronized (list) {
            if (this.pool.contains(obj)) {
                throw new IllegalStateException("An object currently in the pool cannot be invalidated.");
            }
            this.tracker.returned(obj);
            try {
                this.factory.destroyObject(obj);
            }
            catch (Exception exception) {
            }
            finally {
                this.pool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception, UnsupportedOperationException {
        List list = this.pool;
        synchronized (list) {
            while (this.pool.size() > 0) {
                Object obj = this.internalBorrowObject();
                this.invalidateObject(obj);
            }
            if (this.pool instanceof ArrayList) {
                ((ArrayList)this.pool).trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.open = false;
        Thread.yield();
        List list = this.pool;
        synchronized (list) {
            try {
                this.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pool.notifyAll();
        }
    }

    public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
        if (this.factory != factory) {
            throw new UnsupportedOperationException("Replacing the factory not supported. Create a new pool instance instead.");
        }
    }

    public int getNumActive() {
        return this.tracker.getBorrowed();
    }

    public int getNumIdle() {
        return this.lender.size();
    }

    boolean isOpen() {
        return this.open;
    }

    private void assertOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("pool has been closed.");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CompositeObjectPool{");
        if (this.factoryConfig != null) {
            sb.append(this.factoryConfig);
        } else {
            sb.append("factory=").append(this.factory);
            sb.append(", lender=").append(this.lender);
            sb.append(", manager=").append(this.manager);
            sb.append(", tracker=").append(this.tracker);
            sb.append(", validateOnReturn=").append(this.validateOnReturn);
        }
        sb.append(", open=").append(this.open);
        try {
            int numActive = this.getNumActive();
            sb.append(", activeObjects=").append(numActive);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int numIdle = this.getNumIdle();
            sb.append(", idleObjects=").append(numIdle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append('}');
        return sb.toString();
    }
}

