/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.logger;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.alinous.AlinousConfig;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.basic.ILogProvidor;
import org.alinous.logger.AlinousFileLogger;

public class AlinousLogger
implements ILogProvidor {
    private AlinousConfig config;
    private AlinousFileLogger log;

    public AlinousLogger(AlinousConfig config, String alinousHome) {
        this.config = config;
        this.log = new AlinousFileLogger();
        this.log.init(alinousHome);
    }

    public synchronized void reportError(Throwable ex) {
        StringBuffer buff = new StringBuffer();
        Long nowLong = System.currentTimeMillis();
        Timestamp now = new Timestamp(nowLong);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        buff.append("[");
        buff.append(fmt.format(now));
        buff.append("]\n");
        String stackTraceString = AlinousUtils.getStackTraceString(ex);
        buff.append(stackTraceString);
        buff.append("\n");
        this.log.reportError(buff.toString());
    }

    public synchronized void reportError(String str) {
        StringBuffer buff = new StringBuffer();
        Long nowLong = System.currentTimeMillis();
        Timestamp now = new Timestamp(nowLong);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        buff.append("[");
        buff.append(fmt.format(now));
        buff.append("]\n");
        buff.append(str);
        buff.append("\n");
        this.log.reportError(buff.toString());
    }

    public AlinousConfig getConfig() {
        return this.config;
    }

    public void setConfig(AlinousConfig config) {
        this.config = config;
    }

    public synchronized void reportInfo(String str) {
        StringBuffer buff = new StringBuffer();
        Long nowLong = System.currentTimeMillis();
        Timestamp now = new Timestamp(nowLong);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        buff.append("[");
        buff.append(fmt.format(now));
        buff.append("]\n");
        buff.append(str);
        buff.append("\n");
        this.log.reportInfo(buff.toString());
    }
}

