/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.validate;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.alinous.objects.Attribute;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.validate.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlinousAttributeValidator {
    private XMLTagBase tag;
    private Hashtable<String, Attribute> alinousAttributes;

    public AlinousAttributeValidator(XMLTagBase tag, Hashtable<String, Attribute> alinousAttributes) {
        this.tag = tag;
        this.alinousAttributes = alinousAttributes;
    }

    public void validate(List<ValidationError> errors) {
        for (String attr : this.alinousAttributes.keySet()) {
            if (attr.equals("alns:form")) {
                this.validateAlnsForm(errors);
                continue;
            }
            if (attr.equals("alns:inner")) {
                this.validateAlnsInner(errors);
                continue;
            }
            if (attr.equals("alns:iterate")) {
                this.validateAlnsIterate(errors);
                continue;
            }
            if (attr.equals("alns:msg")) {
                this.validateAlnsMsg(errors);
                continue;
            }
            if (attr.equals("alns:regexp")) {
                this.validateAlnsRegex(errors);
                continue;
            }
            if (attr.equals("alns:tagid")) {
                this.validateAlnsTagid(errors);
                continue;
            }
            if (attr.equals("alns:validate") || !attr.equals("alns:variable")) continue;
            this.validateAlnsVariable(errors);
        }
    }

    private void validateAlnsVariable(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:iterate"});
        this.handleErrorFromList(list, errors);
    }

    private void validateAlnsTagid(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:inner"});
        this.handleErrorFromList(list, errors);
    }

    private void validateAlnsRegex(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:validate"});
        this.handleErrorFromList(list, errors);
    }

    private void validateAlnsMsg(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:validate", "alns:form"});
        this.handleErrorFromList(list, errors);
    }

    private void validateAlnsIterate(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:variable"});
        this.handleErrorFromList(list, errors);
    }

    private void validateAlnsInner(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:tagid"});
        this.handleErrorFromList(list, errors);
    }

    private void validateAlnsForm(List<ValidationError> errors) {
        List<String> list = this.checkExistsAll(new String[]{"alns:msg", "alns:validate"});
        this.handleErrorFromList(list, errors);
    }

    private void handleErrorFromList(List<String> list, List<ValidationError> errors) {
        if (list.size() > 0) {
            StringBuffer buff = new StringBuffer();
            for (String str : list) {
                buff.append(str);
                buff.append(" ");
            }
            buff.append("is necessary.");
            ValidationError err = new ValidationError(this.tag.getLine(), buff.toString());
            errors.add(err);
        }
    }

    private List<String> checkExistsAll(String[] attrs) {
        ArrayList<String> notExistList = new ArrayList<String>();
        for (int i = 0; i < attrs.length; ++i) {
            String attrStr = attrs[i];
            Attribute attr = this.alinousAttributes.get(attrStr);
            if (attr != null) continue;
            notExistList.add(attrStr);
        }
        return notExistList;
    }
}

