/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.runtime;

import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.NumericConst;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElement;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

public class ArrayPathElement
implements IPathElement,
Cloneable {
    private IStatement number;
    private IPathElement child;
    private IPathElement parent;
    private boolean isArrayContainer;

    public ArrayPathElement(String number) {
        this.number = new NumericConst(number);
    }

    public ArrayPathElement(int number) {
        this.number = new NumericConst(number);
    }

    public ArrayPathElement(IStatement number) {
        this.number = number;
    }

    public String getPathString(PostContext context, VariableRepository valRepo) throws ExecutionException {
        StringBuffer buffer = new StringBuffer();
        ScriptDomVariable domNumber = (ScriptDomVariable)this.number.executeStatement(context, valRepo);
        int iNumber = Integer.parseInt(domNumber.getValue());
        buffer.append("[" + iNumber + "]");
        if (this.child != null && this.child instanceof PathElement) {
            buffer.append(".");
            buffer.append(this.child.getPathString(context, valRepo));
        } else if (this.child != null && this.child instanceof ArrayPathElement) {
            buffer.append(this.child.getPathString(context, valRepo));
        }
        return buffer.toString();
    }

    public IStatement getNumber() {
        return this.number;
    }

    public void setNumber(IStatement number) {
        this.number = number;
    }

    public IPathElement getChild() {
        return this.child;
    }

    public void setChild(IPathElement child) {
        this.child = child;
        if (child instanceof ArrayPathElement) {
            this.isArrayContainer = true;
        }
    }

    public IPathElement getParent() {
        return this.parent;
    }

    public void setParent(IPathElement parent) {
        this.parent = parent;
    }

    public IScriptVariable input(IScriptVariable container, PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (!(container instanceof ScriptArray)) {
            throw new ExecutionException("Failed to input variable");
        }
        ScriptArray scriptArray = (ScriptArray)container;
        ScriptDomVariable numVal = (ScriptDomVariable)this.number.executeStatement(null, valRepo);
        IScriptVariable cur = scriptArray.get(Integer.parseInt(numVal.getValue()));
        if (!(cur instanceof ScriptDomVariable) && !this.isArrayContainer) {
            cur = null;
        }
        if (!(cur instanceof ScriptArray) && this.isArrayContainer) {
            cur = null;
        }
        if (cur == null) {
            if (!this.isArrayContainer) {
                cur = new ScriptDomVariable("anonymous");
            } else if (this.isArrayContainer) {
                cur = new ScriptArray("ScriptArray");
            }
            numVal = (ScriptDomVariable)this.number.executeStatement(null, valRepo);
            scriptArray.putAt(cur, Integer.parseInt(numVal.getValue()));
        }
        return cur;
    }

    public boolean isLeaf() {
        return this.child == null;
    }

    public int getType() {
        return 2;
    }

    public IPathElement getLast() {
        IPathElement cur = this;
        while (cur.getChild() != null) {
            cur = cur.getChild();
        }
        return cur;
    }

    public IPathElement removeLast() {
        IPathElement copy = this.deepCopy();
        IPathElement last = copy.getLast();
        IPathElement cur = copy;
        while (cur.getChild() != last) {
            cur = cur.getChild();
        }
        cur.setChild(null);
        return copy;
    }

    protected IPathElement deepCopy() {
        ArrayPathElement retElement = new ArrayPathElement(this.number);
        IPathElement curSrc = this;
        IPathElement curDst = retElement;
        while (curSrc.getChild() != null) {
            curSrc = curSrc.getChild();
            IPathElement newElement = null;
            try {
                newElement = (IPathElement)curSrc.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            curDst.setChild(newElement);
            curDst = newElement;
        }
        return retElement;
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayPathElement newElement = new ArrayPathElement(this.number);
        newElement.isArrayContainer = this.isArrayContainer;
        return newElement;
    }
}

