/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import org.alinous.AlinousCore;
import org.alinous.AlinousDebug;
import org.alinous.AlinousUtils;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.pages.IDesign;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.parser.script.AlinousScriptParser;
import org.alinous.parser.script.ParseException;
import org.alinous.script.AlinousScript;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

public class TestDriver {
    public static void main(String[] args) {
        try {
            TestDriver.replaceTest();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void replaceTest() {
        String str = "aaa'SS";
        str = AlinousUtils.sqlEscape(str);
        System.out.println(str);
    }

    public static void dbTest() throws Throwable {
        String alinousHome = System.getenv("ALINOUS_HOME");
        AlinousCore core = AlinousCore.getInstance(alinousHome);
        AccessExecutionUnit exec = core.createAccessExecutionUnit("9b319785a6f062e6546b6dc2bab9f8a3");
        InnerModulePath modulePath = new InnerModulePath("/formTest.html:testIn2");
        String lastPath = exec.getInnserStatusCache().getLastPath(modulePath);
        System.out.println(lastPath);
    }

    public static void innerPathTest() throws AlinousException {
        InnerModulePath path = new InnerModulePath("/TestForm.html");
        path = path.deepClone();
        System.out.println(path.getStringPath());
    }

    public static void pathTest() {
        String path = "/form1/test.alns";
        String out = AlinousUtils.getDirectory(path);
        System.out.println(out);
    }

    public static void attrParseAndMakeTest() throws Throwable {
        String path = "test.dom.core";
        VariableRepository container = new VariableRepository();
        container.putValue(path, "testvalue1", "STRING", null);
        AlinousDebug.dumpValues(container);
        IScriptVariable v = container.getAndMakeVariableFromPath(path, null);
        ScriptDomVariable dv = (ScriptDomVariable)v;
        System.out.println(dv.getValue());
    }

    public static void domPathTest() throws Throwable {
        String path = "test.dom.ar[2].te";
        IPathElement el = PathElementFactory.buildPathElement(path);
        String str = el.getPathString(null, null);
        System.out.println(str);
    }

    public static void unitTest() throws Throwable {
        String moduleName = "/test";
        AlinousCore.debug = false;
        AlinousCore core = AlinousCore.getInstance("testdir" + File.separator);
        AccessExecutionUnit exec = core.createAccessExecutionUnit("testSessionId");
        PostContext context = new PostContext(core, exec);
        IDesign design = null;
        core.registerAlinousObject(moduleName);
        design = exec.gotoPage(moduleName, context);
        StringWriter writer = new StringWriter();
        design.renderContents(context, writer, 0);
        String s = writer.toString();
        System.out.println(s);
    }

    public static void exceptionTest() throws Throwable {
        AlinousCore core = AlinousCore.getInstance(null);
        System.out.println(core.toString());
    }

    public static void script2HtmlTest() throws Throwable {
        String alinousHome = System.getenv("ALINOUS_HOME");
        AlinousCore core = AlinousCore.getInstance(alinousHome);
        AccessExecutionUnit unit = core.createAccessExecutionUnit("testSessionId");
        PostContext context = new PostContext(core, unit);
        IDesign design = null;
        try {
            design = unit.gotoPage("test", context);
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
        StringWriter writer = new StringWriter();
        try {
            design.renderContents(context, writer, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s = writer.toString();
        System.out.println(s);
    }

    public static void scriptParserTest() throws AlinousException, ExecutionException {
        FileInputStream stream;
        String alinousHome = System.getenv("ALINOUS_HOME");
        System.out.println(String.valueOf(alinousHome) + File.separator + "test.alns");
        File file = new File(String.valueOf(alinousHome) + File.separator + "test.alns");
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        AlinousScript script = null;
        AlinousScriptParser parser = new AlinousScriptParser(stream);
        parser.setFilePath("test.alns");
        try {
            script = parser.parse();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        PostContext context = new PostContext(null, null);
        VariableRepository valRepo = new VariableRepository();
        script.execute(context, valRepo);
    }

    public static void scanerTest() throws Throwable {
        String alinousHome = System.getenv("ALINOUS_HOME");
        AlinousCore core = AlinousCore.getInstance(alinousHome);
        AccessExecutionUnit unit = core.createAccessExecutionUnit("testSessionId");
        PostContext context = new PostContext(core, unit);
        IDesign design = null;
        try {
            design = unit.gotoPage("form\\test", context);
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
        StringWriter writer = new StringWriter();
        try {
            design.renderContents(context, writer, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s = writer.toString();
        System.out.println(s);
    }

    public static void registerObjTest() throws Throwable {
        AlinousCore core = AlinousCore.getInstance("testdir" + File.separator);
        core.registerAlinousObject("test.html", "test.alns");
        AccessExecutionUnit unit = core.createAccessExecutionUnit("testSessionId");
        PostContext context = new PostContext(core, unit);
        IDesign design = unit.gotoPage("test", context);
        StringWriter writer = new StringWriter();
        try {
            design.renderContents(context, writer, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(writer.getBuffer().toString());
    }
}

