/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.net.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import org.alinous.expections.MailException;
import org.alinous.net.mail.AbstractSmptCommand;
import org.alinous.net.mail.SmtpProtocol;

public class MailBodyCommand
extends AbstractSmptCommand {
    private String fromAddress;

    public MailBodyCommand(SmtpProtocol proto) {
        super(proto);
    }

    public void receiveCommand(Socket con) throws IOException, MailException {
        String res = this.receive(con);
        if (!res.startsWith("250")) {
            throw new MailException(res);
        }
    }

    public void sendCommand(Socket con) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FROM: " + this.fromAddress + "\r\n");
        this.appendTo(buffer);
        this.appendCc(buffer);
        this.appendBody(buffer);
        this.sendCommand(buffer.toString(), con);
    }

    private void appendBody(StringBuffer buffer) throws UnsupportedEncodingException {
        String body = this.proto.getBody();
        String subject = this.proto.getSubject();
        String contentType = "content-Type: text/plain;";
        if (this.proto.getLangEncoding() != null) {
            body = new String(body.getBytes(this.proto.getLangEncoding()));
            subject = new String(subject.getBytes(this.proto.getLangEncoding()));
            contentType = contentType + " charset=" + this.proto.getLangEncoding();
        }
        body.replaceAll("\r\n\\.", "\r\n..");
        buffer.append("MIME-Version: 1.0\r\n");
        buffer.append(contentType + "\r\n");
        buffer.append("Content-Transfer-Encoding: 7bit\r\n");
        buffer.append("X-Mailer: Alinous-Core Mailer Engine\r\n");
        buffer.append("SUBJECT: " + subject + "\r\n");
        buffer.append("\r\n");
        buffer.append(body);
        buffer.append("\r\n.\r\n");
    }

    private void appendTo(StringBuffer buffer) {
        if (this.proto.getToAddress().isEmpty()) {
            return;
        }
        buffer.append("TO: ");
        boolean first = true;
        for (String addr : this.proto.getToAddress()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append(addr);
        }
        buffer.append("\r\n");
    }

    private void appendCc(StringBuffer buffer) {
        if (this.proto.getCcAddress().isEmpty()) {
            return;
        }
        buffer.append("CC: ");
        boolean first = true;
        for (String addr : this.proto.getCcAddress()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append(addr);
        }
        buffer.append("\r\n");
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }
}

