/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.net.mail;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.alinous.expections.MailException;
import org.alinous.net.mail.AuthLoginCommand;
import org.alinous.net.mail.AuthLoginInputPassCommand;
import org.alinous.net.mail.AuthLoginInputUserCommand;
import org.alinous.net.mail.DataCommand;
import org.alinous.net.mail.EhloCommand;
import org.alinous.net.mail.HelloCommand;
import org.alinous.net.mail.ISmtpCommand;
import org.alinous.net.mail.MailBodyCommand;
import org.alinous.net.mail.MailComand;
import org.alinous.net.mail.NullCommand;
import org.alinous.net.mail.QuitCommand;
import org.alinous.net.mail.RcptCommand;
import org.alinous.net.mail.ResetCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmtpProtocol {
    public static final String AUTH_LOGIN = "AUTH_LOGIN";
    public static final String ISO2022JP = "ISO2022JP";
    private String smtpServer;
    private int smtpPort = 25;
    private String fromAddress;
    private List<String> toAddress = new ArrayList<String>();
    private List<String> ccAddress = new ArrayList<String>();
    private String subject;
    private String body;
    private String langEncoding;
    private String userName;
    private String password;
    private Socket con;

    public void connect() throws UnknownHostException, IOException {
        this.con = new Socket(this.smtpServer, this.smtpPort);
    }

    public void disconnect() {
        try {
            this.con.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMail(String receiver) throws MailException, IOException {
        this.recv();
        this.helloCommand();
        this.mailCommand(this.fromAddress);
        this.rcptCommand(receiver);
        this.dataCommand(this.fromAddress);
        try {
            this.quitCommand();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendMailWithAuth(String receiver, String user, String pass, String authWay) throws MailException, IOException {
        this.userName = user;
        this.password = pass;
        this.recv();
        this.helloCommand();
        if (authWay != null && authWay.toUpperCase().equals(AUTH_LOGIN)) {
            this.doAuthLogin();
        }
        this.mailCommand(this.fromAddress);
        this.rcptCommand(receiver);
        this.dataCommand(this.fromAddress);
        try {
            this.quitCommand();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }

    public void sendMultiple(String receiver, String user, String pass, String authWay) throws MailException, IOException {
        this.userName = user;
        this.password = pass;
        this.sendResetCommand();
        this.helloCommand();
        this.mailCommand(this.fromAddress);
        this.rcptCommand(receiver);
        this.dataCommand(this.fromAddress);
    }

    public void doAuthLogin() throws IOException, MailException {
        AuthLoginCommand login = new AuthLoginCommand(this);
        login.sendCommand(this.con);
        login.receiveCommand(this.con);
        AuthLoginInputUserCommand userCom = new AuthLoginInputUserCommand(this);
        userCom.sendCommand(this.con);
        userCom.receiveCommand(this.con);
        AuthLoginInputPassCommand passCom = new AuthLoginInputPassCommand(this);
        passCom.sendCommand(this.con);
        passCom.receiveCommand(this.con);
    }

    public void recv() throws MailException, IOException {
        NullCommand cmd = new NullCommand(this);
        this.recvCommand(cmd);
    }

    public void helloCommand() throws IOException, MailException {
        HelloCommand cmd = new HelloCommand(this);
        this.sendCommand(cmd);
        this.recvCommand(cmd);
    }

    public void ehloCommand() throws IOException, MailException {
        EhloCommand cmd = new EhloCommand(this);
        this.sendCommand(cmd);
        this.recvCommand(cmd);
    }

    public void mailCommand(String fromAddr) throws IOException, MailException {
        MailComand cmd = new MailComand(this);
        cmd.setFromAddress(fromAddr);
        this.sendCommand(cmd);
        this.recvCommand(cmd);
    }

    public void rcptCommand(String receiver) throws IOException, MailException {
        RcptCommand cmd = new RcptCommand(this);
        cmd.setReceiver(receiver);
        this.sendCommand(cmd);
        this.recvCommand(cmd);
    }

    public void dataCommand(String fromAddress) throws IOException {
        DataCommand cmd = new DataCommand(this);
        cmd.sendCommand(this.con);
        cmd.receive(this.con);
        MailBodyCommand mailCmd = new MailBodyCommand(this);
        mailCmd.setFromAddress(fromAddress);
        mailCmd.sendCommand(this.con);
        mailCmd.receive(this.con);
    }

    public void quitCommand() throws IOException, MailException {
        QuitCommand cmd = new QuitCommand(this);
        this.sendCommand(cmd);
    }

    public void sendResetCommand() throws IOException, MailException {
        ResetCommand cmd = new ResetCommand(this);
        this.sendCommand(cmd);
        this.recvCommand(cmd);
    }

    private void sendCommand(ISmtpCommand cmd) throws IOException {
        cmd.sendCommand(this.con);
    }

    private void recvCommand(ISmtpCommand cmd) throws IOException, MailException {
        cmd.receiveCommand(this.con);
    }

    public void addToAddress(String addr) {
        this.toAddress.add(addr);
    }

    public void addCcAddress(String addr) {
        this.ccAddress.add(addr);
    }

    public List<String> getCcAddress() {
        return this.ccAddress;
    }

    public List<String> getToAddress() {
        return this.toAddress;
    }

    public void reset() {
        this.toAddress.clear();
        this.ccAddress.clear();
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String mailAddress) {
        this.fromAddress = mailAddress;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getLangEncoding() {
        return this.langEncoding;
    }

    public void setLangEncoding(String langEncoding) {
        this.langEncoding = langEncoding;
    }
}

