/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.html;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.objects.Attribute;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.IHtmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTagObject
extends XMLTagBase
implements IHtmlObject {
    public static final String HIDDEN_FORM_ACTION = "alns:formAction";
    public static final String HIDDEN_FORM_TARGET_TAGID = "alns:formTargetTagId";
    public static final String HIDDEN_FORM_LAST_ACTION = "alns:formLastAction";
    public static final String HIDDEN_FORM_LAST_TARGET_TAGID = "alns:formLastTargetTagId";
    public static final String HIDDEN_FORM_LAST_FORM_ID = "alns:formLastFormId";
    public static final String HIDDEN_FORM_BACK = "alns:back";
    private List<XMLTagBase.FormHiddenValue> childsHiddens = new ArrayList<XMLTagBase.FormHiddenValue>();

    @Override
    public IAlinousObject fork() throws AlinousException {
        FormTagObject newObj = new FormTagObject();
        this.copyAttribute(this, newObj);
        this.forkInnerObjects(newObj);
        return newObj;
    }

    @Override
    public void renderContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (!this.handleIf(context)) {
            return;
        }
        if (context.isInner()) {
            this.renderAsInnerObject(context, wr, n);
            return;
        }
        wr.append("<FORM");
        this.renderAttributes(wr, 0, true, true);
        wr.append(">");
        this.renderInnerContents(context, wr, n + 1);
        AlinousTopObject topObj = this.getTopObject();
        ArrayList<XMLTagBase.FormHiddenValue> hiddens = new ArrayList<XMLTagBase.FormHiddenValue>();
        InnerModulePath modulePath = topObj.getModulePath();
        XMLTagBase.FormHiddenValue hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_TARGET_TAGID, modulePath.getStringPath());
        hiddens.add(hidden);
        String lastAction = topObj.getPath();
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_LAST_ACTION, lastAction);
        hiddens.add(hidden);
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_LAST_TARGET_TAGID, modulePath.getStringPath());
        hiddens.add(hidden);
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_LAST_FORM_ID, this.getFormId());
        hiddens.add(hidden);
        Attribute attrAction = (Attribute)this.attributes.get("action");
        if (attrAction == null) {
            throw new ExecutionException("Action is necessary.");
        }
        String strAction = attrAction.getValue().getValue();
        String absPath = topObj.toAbsolutePath(strAction);
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_ACTION, absPath);
        hiddens.add(hidden);
        this.renderHiddens(context, wr, n, hiddens);
        this.renderHiddens(context, wr, n, this.childsHiddens);
        wr.append("</FORM>");
    }

    private void renderAsInnerObject(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        AlinousTopObject topObj = this.getTopObject();
        ArrayList<XMLTagBase.FormHiddenValue> hiddens = new ArrayList<XMLTagBase.FormHiddenValue>();
        wr.append("<FORM");
        this.renderAsInnerAttributes(wr, n, topObj, hiddens);
        wr.append(">\n");
        this.renderInnerContents(context, wr, n + 1);
        InnerModulePath modulePath = topObj.getModulePath();
        XMLTagBase.FormHiddenValue hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_TARGET_TAGID, modulePath.getStringPath());
        hiddens.add(hidden);
        String lastAction = topObj.getPath();
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_LAST_ACTION, lastAction);
        hiddens.add(hidden);
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_LAST_TARGET_TAGID, modulePath.getStringPath());
        hiddens.add(hidden);
        hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_LAST_FORM_ID, this.getFormId());
        hiddens.add(hidden);
        this.renderHiddens(context, wr, n, hiddens);
        this.renderHiddens(context, wr, n, this.childsHiddens);
        wr.append("</FORM>\n");
    }

    public String getFormId() {
        Attribute attr = this.getAttribute("id");
        if (attr != null && attr.getValue() != null) {
            return attr.getValue().getValue();
        }
        attr = this.getAttribute("name");
        if (attr != null && attr.getValue() != null) {
            return attr.getValue().getValue();
        }
        return "";
    }

    private void renderAsInnerAttributes(Writer wr, int n, AlinousTopObject topObj, List<XMLTagBase.FormHiddenValue> hiddens) throws IOException {
        Enumeration enm = this.attributes.keys();
        while (enm.hasMoreElements()) {
            Object key = enm.nextElement();
            Attribute atr = this.getAttribute((String)key);
            wr.write(" ");
            if (atr.getKey().toLowerCase().equals("action")) {
                AlinousTopObject toptopObj = topObj.getTopTopObject();
                this.renderOneAttribute(wr, "action", this.context.getFilePath(toptopObj.getPath()));
                String absPath = topObj.toAbsolutePath(atr.getValue().getValue());
                XMLTagBase.FormHiddenValue hidden = new XMLTagBase.FormHiddenValue(HIDDEN_FORM_ACTION, absPath);
                hiddens.add(hidden);
                continue;
            }
            atr.renderContents(wr, n + 1, this.context, this.valRepo, true);
        }
    }

    private void renderOneAttribute(Writer wr, String key, String value) throws IOException {
        wr.write(key);
        wr.write("=");
        wr.write("\"");
        wr.write(value);
        wr.write("\"");
    }

    @Override
    public String getTagName() {
        return "FORM";
    }

    @Override
    protected boolean isNameNeeded() {
        return true;
    }

    public void addChildHidden(XMLTagBase.FormHiddenValue hidden) {
        this.childsHiddens.add(hidden);
    }
}

