/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.StatementJDomFactory;
import org.alinous.script.basic.type.VariableDescriptor;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class SubstituteSentence
implements IScriptSentence {
    private VariableDescriptor operand;
    private IStatement statement;
    private int line;
    private int linePosition;
    private String filePath;

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        IScriptVariable val = this.statement.executeStatement(context, valRepo);
        String prefix = this.operand.getPrefix();
        if (prefix.equals("$")) {
            this.substituteVariable(val, context, valRepo);
        } else {
            this.substituteArray(val, context, valRepo);
        }
        return true;
    }

    private void substituteVariable(IScriptVariable val, PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (!(val instanceof ScriptDomVariable)) {
            throw new ExecutionException("Cannot input Variable into Array");
        }
        IPathElement path = this.operand.getPath();
        try {
            valRepo.putValue(path, (IScriptVariable)val.clone(), context);
        }
        catch (CloneNotSupportedException e) {
            throw new ExecutionException(e, "Clone() failed");
        }
    }

    private void substituteArray(IScriptVariable val, PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (!(val instanceof ScriptArray)) {
            throw new ExecutionException("Cannot input Array into Variable");
        }
        IPathElement path = this.operand.getPath();
        try {
            valRepo.putValue(path, (IScriptVariable)val.clone(), context);
        }
        catch (CloneNotSupportedException e) {
            throw new ExecutionException(e, "Clone() failed");
        }
    }

    public VariableDescriptor getOperand() {
        return this.operand;
    }

    public void setOperand(VariableDescriptor operand) {
        this.operand = operand;
    }

    public IStatement getStatement() {
        return this.statement;
    }

    public void setStatement(IStatement statement) {
        this.statement = statement;
        this.statement.setCallerSentence(this);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        this.statement.exportIntoJDomElement(element);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element el = element.getChild("STATEMENT");
        this.statement = StatementJDomFactory.createStatementFromDom(el);
        if (this.statement != null) {
            this.statement.importFromJDomElement(el);
        }
    }

    public StepInCandidates getStepInCandidates() {
        StepInCandidates candidates = new StepInCandidates();
        this.statement.canStepInStatements(candidates);
        return candidates;
    }

    public IScriptVariable getReturnedVariable() {
        return null;
    }
}

