/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql;

import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.IClause;
import org.alinous.script.sql.ISQLScriptObject;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.other.JoinCondition;

public class JoinClause
implements IClause {
    public static final int DEFAULT = 0;
    public static final int INNER_JOIN = 1;
    public static final int LEFT_JOIN = 2;
    public static final int RIGHT_JOIN = 3;
    public static final int NATURAL_JOIN = 4;
    public static final int CROSS_JOIN = 5;
    private int joinType;
    private JoinCondition condition;
    private ISQLScriptObject left;
    private ISQLScriptObject right;

    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
        this.condition.acceptVariables(providor, adjustWhere, adjustSet);
    }

    public String extract() throws ExecutionException {
        StringBuffer buffer = new StringBuffer();
        if (this.left instanceof JoinClause) {
            buffer.append("(");
            buffer.append(this.left.extract());
            buffer.append(")");
        } else {
            buffer.append(this.left.extract());
        }
        switch (this.joinType) {
            case 0: {
                buffer.append(", ");
                break;
            }
            case 1: {
                buffer.append(" INNER JOIN ");
                break;
            }
            case 2: {
                buffer.append(" LEFT JOIN ");
                break;
            }
            case 3: {
                buffer.append(" RIGHT JOIN ");
                break;
            }
            case 4: {
                buffer.append(" NATURAL JOIN ");
                break;
            }
            case 5: {
                buffer.append(" CROSS JOIN ");
                break;
            }
            default: {
                buffer.append(", ");
            }
        }
        if (this.right instanceof JoinClause) {
            buffer.append("(");
            buffer.append(this.right.extract());
            buffer.append(")");
        } else {
            buffer.append(this.left.extract());
        }
        if (this.condition != null) {
            buffer.append(" ");
            buffer.append(this.condition.extract());
        }
        return buffer.toString();
    }

    public JoinCondition getCondition() {
        return this.condition;
    }

    public void setCondition(JoinCondition condition) {
        this.condition = condition;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public ISQLScriptObject getLeft() {
        return this.left;
    }

    public void setLeft(ISQLScriptObject left) {
        this.left = left;
    }

    public ISQLScriptObject getRight() {
        return this.right;
    }

    public void setRight(ISQLScriptObject right) {
        this.right = right;
    }

    public boolean isReady() throws ExecutionException {
        return true;
    }
}

