/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.pool.composite.AbstractManager;
import org.apache.commons.pool.composite.CompositeKeyedObjectPool;
import org.apache.commons.pool.composite.CompositeObjectPool;

final class GrowManager
extends AbstractManager
implements Serializable {
    private static final long serialVersionUID = 1225746308358794900L;
    private static final Timer PREFILL_TIMER;
    private final Object avgLock = new Object();
    private long activateAvg = 0L;
    private long makeAvg = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    GrowManager() {
    }

    public Object nextFromPool() throws Exception {
        if (!$assertionsDisabled && !Thread.holdsLock(this.objectPool.getPool())) {
            throw new AssertionError();
        }
        Object obj = null;
        long startActivateTime = System.currentTimeMillis();
        while (this.objectPool.getLender().size() > 0 && obj == null) {
            obj = this.objectPool.getLender().borrow();
            if (obj == null) continue;
            obj = this.activateOrDestroy(obj);
            try {
                if (obj == null || this.objectPool.getFactory().validateObject(obj)) continue;
                this.deferDestroyObject(obj);
                obj = null;
            }
            catch (Exception e) {
                this.deferDestroyObject(obj);
                obj = null;
            }
        }
        if (obj != null) {
            this.updateActivateTimings(startActivateTime, System.currentTimeMillis());
        } else {
            long startMakeTime = System.currentTimeMillis();
            obj = this.objectPool.getFactory().makeObject();
            this.updateMakeTimings(startMakeTime, System.currentTimeMillis());
        }
        this.schedulePrefill();
        return obj;
    }

    private Object activateOrDestroy(Object obj) {
        try {
            this.objectPool.getFactory().activateObject(obj);
        }
        catch (Exception e) {
            this.deferDestroyObject(obj);
            return null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActivateTimings(long start, long end) {
        long elapsed = end - start;
        if (elapsed > 0L) {
            Object object = this.avgLock;
            synchronized (object) {
                this.activateAvg = (this.activateAvg * 9L + elapsed) / 10L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMakeTimings(long start, long end) {
        long elapsed = end - start;
        if (elapsed > 0L) {
            Object object = this.avgLock;
            synchronized (object) {
                this.makeAvg = (this.makeAvg * 9L + elapsed) / 10L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMakeObjectExpensive() {
        Object object = this.avgLock;
        synchronized (object) {
            return this.activateAvg > 0L && this.activateAvg * 3L < this.makeAvg;
        }
    }

    private void schedulePrefill() {
        if (this.objectPool.getLender().size() == 0 && this.isMakeObjectExpensive()) {
            CompositeKeyedObjectPool ckop = this.objectPool.getOwningCompositeKeyedObjectPool();
            if (ckop != null) {
                Object key = ckop.getKeys().get();
                PREFILL_TIMER.schedule((TimerTask)new KeyedPrefillTask(key), 0L);
            } else {
                PREFILL_TIMER.schedule((TimerTask)new PrefillTask(), 0L);
            }
        }
    }

    public String toString() {
        return "GrowManager{makeObjectExpensive=" + this.isMakeObjectExpensive() + "}";
    }

    static {
        $assertionsDisabled = !GrowManager.class.desiredAssertionStatus();
        PREFILL_TIMER = CompositeObjectPool.COMPOSITE_TIMER;
    }

    private class KeyedPrefillTask
    extends TimerTask {
        private final Object key;

        KeyedPrefillTask(Object key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadLocal keys = null;
            try {
                if (GrowManager.this.objectPool.getNumIdle() == 0) {
                    keys = GrowManager.this.objectPool.getOwningCompositeKeyedObjectPool().getKeys();
                    keys.set(this.key);
                    GrowManager.this.objectPool.addObject();
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (keys != null) {
                    keys.set(null);
                }
            }
        }
    }

    private class PrefillTask
    extends TimerTask {
        private PrefillTask() {
        }

        public void run() {
            try {
                if (GrowManager.this.objectPool.getNumIdle() == 0) {
                    GrowManager.this.objectPool.addObject();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

