/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import org.apache.commons.pool.composite.Tracker;

final class SimpleTracker
implements Tracker,
Serializable {
    private static final long serialVersionUID = -7300626285071421255L;
    private volatile transient int active = 0;

    SimpleTracker() {
    }

    public void borrowed(Object obj) {
        ++this.active;
    }

    public void returned(Object obj) throws IllegalStateException {
        if (--this.active < 0) {
            ++this.active;
            throw new IllegalStateException("More objects returned than were borrowed. Most recent object: " + obj);
        }
    }

    public int getBorrowed() {
        return this.active;
    }

    public String toString() {
        return "SimpleTracker{active=" + this.active + '}';
    }
}

