/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.Lender;

abstract class AbstractLender
implements Lender,
Serializable {
    private static final long serialVersionUID = -1338771389484034430L;
    private CompositeObjectPool objectPool;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractLender() {
    }

    public void setCompositeObjectPool(CompositeObjectPool objectPool) throws IllegalArgumentException, IllegalStateException {
        if (objectPool == null) {
            throw new IllegalArgumentException("objectPool must not be null.");
        }
        if (this.objectPool != null) {
            throw new IllegalStateException("Manager cannot be reattached.");
        }
        this.objectPool = objectPool;
    }

    public abstract Object borrow();

    public void repay(Object obj) {
        List pool = this.getObjectPool().getPool();
        if (!$assertionsDisabled && !Thread.holdsLock(pool)) {
            throw new AssertionError();
        }
        pool.add(obj);
        pool.notifyAll();
    }

    public ListIterator listIterator() {
        return this.getObjectPool().getPool().listIterator();
    }

    public int size() {
        return this.getObjectPool().getPool().size();
    }

    protected CompositeObjectPool getObjectPool() {
        return this.objectPool;
    }

    static {
        $assertionsDisabled = !AbstractLender.class.desiredAssertionStatus();
    }
}

