/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.composite.AbstractManager;
import org.apache.commons.pool.composite.ActiveLimitManager;
import org.apache.commons.pool.composite.BorrowPolicy;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.DebugTracker;
import org.apache.commons.pool.composite.ExhaustionPolicy;
import org.apache.commons.pool.composite.FailLimitManager;
import org.apache.commons.pool.composite.FailManager;
import org.apache.commons.pool.composite.FifoLender;
import org.apache.commons.pool.composite.GrowManager;
import org.apache.commons.pool.composite.IdleEvictorLender;
import org.apache.commons.pool.composite.IdleLimitManager;
import org.apache.commons.pool.composite.InvalidEvictorLender;
import org.apache.commons.pool.composite.KeyedPoolableObjectFactoryAdapter;
import org.apache.commons.pool.composite.Lender;
import org.apache.commons.pool.composite.LifoLender;
import org.apache.commons.pool.composite.LimitPolicy;
import org.apache.commons.pool.composite.Manager;
import org.apache.commons.pool.composite.NullLender;
import org.apache.commons.pool.composite.ReferenceTracker;
import org.apache.commons.pool.composite.SimpleTracker;
import org.apache.commons.pool.composite.SoftLender;
import org.apache.commons.pool.composite.Tracker;
import org.apache.commons.pool.composite.TrackingPolicy;
import org.apache.commons.pool.composite.WaitLimitManager;

public final class CompositeObjectPoolFactory
implements ObjectPoolFactory,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2675590130354850408L;
    private final transient Object lock = new Object();
    private transient FactoryConfig config = null;
    private PoolableObjectFactory factory;
    private BorrowPolicy borrowPolicy = BorrowPolicy.FIFO;
    private ExhaustionPolicy exhaustionPolicy = ExhaustionPolicy.GROW;
    private int maxIdle = -1;
    private int maxActive = -1;
    private LimitPolicy limitPolicy = LimitPolicy.FAIL;
    private int maxWaitMillis = -1;
    private TrackingPolicy trackingPolicy = TrackingPolicy.SIMPLE;
    private boolean validateOnReturn = false;
    private long evictIdleMillis = -1L;
    private long evictInvalidFrequencyMillis = -1L;

    public CompositeObjectPoolFactory(PoolableObjectFactory factory) {
        this.setFactory(factory);
    }

    public ObjectPool createPool() throws IllegalStateException {
        return CompositeObjectPoolFactory.createPool(this.getConfig());
    }

    static ObjectPool createPool(FactoryConfig config) throws IllegalStateException {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null.");
        }
        return new CompositeObjectPool(config.factory, CompositeObjectPoolFactory.getList(config), CompositeObjectPoolFactory.getManager(config), CompositeObjectPoolFactory.getLender(config), CompositeObjectPoolFactory.getTracker(config), config.validateOnReturn, config);
    }

    private static List getList(FactoryConfig config) {
        AbstractList list = BorrowPolicy.NULL.equals(config.borrowPolicy) || config.maxIdle == 0 ? Collections.EMPTY_LIST : (BorrowPolicy.LIFO.equals(config.borrowPolicy) || BorrowPolicy.SOFT_LIFO.equals(config.borrowPolicy) ? (config.maxIdle >= 0 ? new ArrayList(config.maxIdle) : new ArrayList()) : (0 <= config.maxIdle && config.maxIdle <= 10 ? new ArrayList(config.maxIdle) : new LinkedList()));
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Lender getLender(FactoryConfig config) {
        void var2_10;
        void var2_12;
        void var2_8;
        BorrowPolicy borrowPolicy = config.borrowPolicy;
        if (config.maxIdle != 0) {
            if (BorrowPolicy.FIFO.equals(borrowPolicy)) {
                FifoLender fifoLender = new FifoLender();
            } else if (BorrowPolicy.LIFO.equals(borrowPolicy)) {
                LifoLender lifoLender = new LifoLender();
            } else if (BorrowPolicy.SOFT_FIFO.equals(borrowPolicy)) {
                SoftLender softLender = new SoftLender(new FifoLender());
            } else if (BorrowPolicy.SOFT_LIFO.equals(borrowPolicy)) {
                SoftLender softLender = new SoftLender(new LifoLender());
            } else {
                if (!BorrowPolicy.NULL.equals(borrowPolicy)) throw new IllegalStateException("No clue what this borrow type is: " + borrowPolicy);
                NullLender nullLender = new NullLender();
            }
        } else {
            NullLender nullLender = new NullLender();
        }
        if (var2_8 instanceof NullLender) return var2_12;
        if (config.evictInvalidFrequencyMillis > 0L && config.evictIdleMillis < config.evictInvalidFrequencyMillis) {
            InvalidEvictorLender invalidEvictorLender = new InvalidEvictorLender((Lender)var2_8);
            invalidEvictorLender.setValidationFrequencyMillis(config.evictInvalidFrequencyMillis);
        }
        if (config.evictIdleMillis <= 0L) return var2_12;
        IdleEvictorLender idleEvictorLender = new IdleEvictorLender((Lender)var2_10);
        idleEvictorLender.setIdleTimeoutMillis(config.evictIdleMillis);
        return var2_12;
    }

    private static Manager getManager(FactoryConfig config) {
        AbstractManager manager;
        ExhaustionPolicy exhaustionPolicy = config.exhaustionPolicy;
        if (ExhaustionPolicy.GROW.equals(exhaustionPolicy)) {
            manager = new GrowManager();
        } else if (ExhaustionPolicy.FAIL.equals(exhaustionPolicy)) {
            if (BorrowPolicy.NULL.equals(config.borrowPolicy)) {
                throw new IllegalStateException("Using the NULL borrow type with the FAIL exhaustion behavior is pointless.");
            }
            if (config.maxIdle == 0) {
                throw new IllegalStateException("Using the FAIL exhaustion behavior with a max of zero idle objects is pointless.");
            }
            manager = new FailManager();
        } else {
            throw new IllegalStateException("No clue what this exhaustion behavior is: " + exhaustionPolicy);
        }
        int maxActive = config.maxActive;
        if (maxActive > 0) {
            LimitPolicy limitPolicy = config.limitPolicy;
            if (LimitPolicy.FAIL.equals(limitPolicy)) {
                manager = new FailLimitManager(manager);
            } else if (LimitPolicy.WAIT.equals(limitPolicy)) {
                manager = new WaitLimitManager(manager);
                ((WaitLimitManager)manager).setMaxWaitMillis(config.maxWaitMillis);
            } else {
                throw new IllegalStateException("No clue what this wait behavior is: " + limitPolicy);
            }
            ((ActiveLimitManager)manager).setMaxActive(maxActive);
        }
        if (config.maxIdle > 0) {
            manager = new IdleLimitManager(manager);
            ((IdleLimitManager)manager).setMaxIdle(config.maxIdle);
        }
        return manager;
    }

    private static Tracker getTracker(FactoryConfig config) {
        Tracker tracker;
        TrackingPolicy trackingPolicy = config.trackingPolicy;
        if (TrackingPolicy.SIMPLE.equals(trackingPolicy)) {
            tracker = new SimpleTracker();
        } else if (TrackingPolicy.REFERENCE.equals(trackingPolicy)) {
            tracker = new ReferenceTracker();
        } else if (TrackingPolicy.DEBUG.equals(trackingPolicy)) {
            tracker = new DebugTracker();
        } else {
            throw new IllegalStateException("No clue what this tracking type is: " + trackingPolicy);
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryConfig getConfig() {
        Object object = this.lock;
        synchronized (object) {
            if (this.config == null) {
                this.config = new FactoryConfig(this);
            }
            return this.config;
        }
    }

    public PoolableObjectFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactory(PoolableObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("object factory must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.factory = factory;
        }
    }

    public BorrowPolicy getBorrowPolicy() {
        return this.borrowPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorrowPolicy(BorrowPolicy borrowPolicy) throws IllegalArgumentException {
        if (borrowPolicy == null) {
            throw new IllegalArgumentException("borrow type must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.borrowPolicy = borrowPolicy;
        }
    }

    public ExhaustionPolicy getExhaustionPolicy() {
        return this.exhaustionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExhaustionPolicy(ExhaustionPolicy exhaustionPolicy) throws IllegalArgumentException {
        if (exhaustionPolicy == null) {
            throw new IllegalArgumentException("exhaustion behavior must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.exhaustionPolicy = exhaustionPolicy;
        }
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxIdle(int maxIdle) {
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.maxIdle = maxIdle;
        }
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int maxActive) {
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.maxActive = maxActive;
        }
    }

    public LimitPolicy getLimitPolicy() {
        return this.limitPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimitPolicy(LimitPolicy limitPolicy) throws IllegalArgumentException {
        if (limitPolicy == null) {
            throw new IllegalArgumentException("limit behavior must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.limitPolicy = limitPolicy;
        }
    }

    public int getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWaitMillis(int maxWaitMillis) {
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.maxWaitMillis = maxWaitMillis;
        }
    }

    public TrackingPolicy getTrackingPolicy() {
        return this.trackingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackingPolicy(TrackingPolicy trackingPolicy) throws IllegalArgumentException {
        if (trackingPolicy == null) {
            throw new IllegalArgumentException("tracker type must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.trackingPolicy = trackingPolicy;
        }
    }

    public boolean isValidateOnReturn() {
        return this.validateOnReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidateOnReturn(boolean validateOnReturn) {
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.validateOnReturn = validateOnReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEvictIdleMillis() {
        Object object = this.lock;
        synchronized (object) {
            return this.evictIdleMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvictIdleMillis(long evictIdleMillis) {
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.evictIdleMillis = evictIdleMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEvictInvalidFrequencyMillis() {
        Object object = this.lock;
        synchronized (object) {
            return this.evictInvalidFrequencyMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvictInvalidFrequencyMillis(long evictInvalidFrequencyMillis) {
        Object object = this.lock;
        synchronized (object) {
            this.config = null;
            this.evictInvalidFrequencyMillis = evictInvalidFrequencyMillis;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CompositeObjectPoolFactory copf = (CompositeObjectPoolFactory)super.clone();
        if (copf.factory instanceof KeyedPoolableObjectFactoryAdapter) {
            KeyedPoolableObjectFactoryAdapter kpofa = (KeyedPoolableObjectFactoryAdapter)copf.factory;
            copf.factory = new KeyedPoolableObjectFactoryAdapter(kpofa.getDelegate());
        }
        return copf;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CompositeObjectPoolFactory{");
        sb.append(this.getConfig());
        sb.append('}');
        return sb.toString();
    }

    static final class FactoryConfig
    implements Serializable {
        private static final long serialVersionUID = 8055395905602482612L;
        private final PoolableObjectFactory factory;
        private final BorrowPolicy borrowPolicy;
        private final ExhaustionPolicy exhaustionPolicy;
        private final int maxIdle;
        private final int maxActive;
        private final LimitPolicy limitPolicy;
        private final int maxWaitMillis;
        private final TrackingPolicy trackingPolicy;
        private final boolean validateOnReturn;
        private final long evictIdleMillis;
        private final long evictInvalidFrequencyMillis;

        FactoryConfig(CompositeObjectPoolFactory copf) {
            this(copf.getFactory(), copf.getBorrowPolicy(), copf.getExhaustionPolicy(), copf.getMaxIdle(), copf.getMaxActive(), copf.getLimitPolicy(), copf.getMaxWaitMillis(), copf.getTrackingPolicy(), copf.isValidateOnReturn(), copf.getEvictIdleMillis(), copf.getEvictInvalidFrequencyMillis());
        }

        FactoryConfig(PoolableObjectFactory factory, BorrowPolicy borrowPolicy, ExhaustionPolicy exhaustionPolicy, int maxIdle, int maxActive, LimitPolicy limitPolicy, int maxWaitMillis, TrackingPolicy trackingPolicy, boolean validateOnReturn, long evictIdleMillis, long evictInvalidFrequencyMillis) {
            this.factory = factory;
            this.borrowPolicy = borrowPolicy;
            this.exhaustionPolicy = exhaustionPolicy;
            this.maxIdle = maxIdle;
            this.maxActive = maxActive;
            this.limitPolicy = limitPolicy;
            this.maxWaitMillis = maxWaitMillis;
            this.trackingPolicy = trackingPolicy;
            this.validateOnReturn = validateOnReturn;
            this.evictIdleMillis = evictIdleMillis;
            this.evictInvalidFrequencyMillis = evictInvalidFrequencyMillis;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("factory=").append(this.factory);
            sb.append(", borrowPolicy=").append(this.borrowPolicy);
            sb.append(", exhaustionPolicy=").append(this.exhaustionPolicy);
            sb.append(", maxIdle=").append(this.maxIdle);
            sb.append(", maxActive=").append(this.maxActive);
            if (this.maxActive > 0) {
                sb.append(", limitPolicy=").append(this.limitPolicy);
                if (LimitPolicy.WAIT.equals(this.limitPolicy)) {
                    sb.append(", maxWaitMillis=").append(this.maxWaitMillis);
                }
            }
            sb.append(", trackingPolicy=").append(this.trackingPolicy);
            sb.append(", validateOnReturn=").append(this.validateOnReturn);
            if (this.evictIdleMillis > 0L) {
                sb.append(", evictIdleMillis=").append(this.evictIdleMillis);
            }
            if (this.evictInvalidFrequencyMillis > 0L) {
                sb.append(", evictInvalidFrequencyMillis=").append(this.evictInvalidFrequencyMillis);
            }
            return sb.toString();
        }
    }
}

