/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.commons.pool.composite.ActiveLimitManager;
import org.apache.commons.pool.composite.Manager;

final class FailLimitManager
extends ActiveLimitManager
implements Serializable {
    private static final long serialVersionUID = 4055528475643314990L;

    FailLimitManager(Manager delegate) throws IllegalArgumentException {
        super(delegate);
    }

    public Object nextFromPool() throws NoSuchElementException, Exception {
        if (this.objectPool.getNumActive() < this.getMaxActive()) {
            return super.nextFromPool();
        }
        throw new NoSuchElementException("No more than " + this.getMaxActive() + " objects allowed from this pool. Currently " + this.objectPool.getNumActive() + " have been borrowed.");
    }

    public String toString() {
        return "FailLimitManager{maxActive=" + this.getMaxActive() + ", delegate=" + super.toString() + "}";
    }
}

