/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.TimerTask;
import org.apache.commons.pool.composite.EvictorLender;
import org.apache.commons.pool.composite.Lender;

final class IdleEvictorLender
extends EvictorLender
implements Serializable {
    private static final long serialVersionUID = 2422278988668384937L;
    private long idleTimeoutMillis = 3600000L;

    IdleEvictorLender(Lender delegate) throws IllegalArgumentException {
        super(delegate);
    }

    protected EvictorLender.EvictorReference createReference(Object obj) {
        return new IdleEvictorReference(obj);
    }

    public long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public void setIdleTimeoutMillis(long idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
    }

    public String toString() {
        return "IdleEvictor{idleTimeoutMillis=" + this.idleTimeoutMillis + ", delegate=" + super.toString() + '}';
    }

    private class IdleEvictorReference
    implements EvictorLender.EvictorReference {
        private Object referant;
        private final TimerTask task;

        IdleEvictorReference(Object referant) {
            this.referant = referant;
            this.task = new IdleEvictorTask();
            IdleEvictorLender.this.getTimer().schedule(this.task, IdleEvictorLender.this.idleTimeoutMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get() {
            IdleEvictorReference idleEvictorReference = this;
            synchronized (idleEvictorReference) {
                return this.referant;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            IdleEvictorReference idleEvictorReference = this;
            synchronized (idleEvictorReference) {
                this.task.cancel();
                if (this.referant instanceof EvictorLender.EvictorReference) {
                    ((EvictorLender.EvictorReference)this.referant).clear();
                }
                this.referant = null;
            }
        }

        private class IdleEvictorTask
        extends TimerTask {
            private IdleEvictorTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IdleEvictorReference idleEvictorReference = IdleEvictorReference.this;
                synchronized (idleEvictorReference) {
                    IdleEvictorReference.this.clear();
                }
            }
        }
    }
}

