/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.composite.Tracker;

class ReferenceTracker
implements Tracker,
Serializable {
    private static final long serialVersionUID = 3271870427019790961L;
    protected final transient ReferenceQueue rq = new ReferenceQueue();
    protected final transient Map map = Collections.synchronizedMap(new HashMap());
    private transient int lost = 0;

    ReferenceTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void borrowed(Object obj) {
        IdentityReference ref;
        if (obj == null) {
            throw new IllegalArgumentException("Cannot track null borrowed from pool.");
        }
        this.workQueue();
        ReferenceQueue referenceQueue = this.rq;
        synchronized (referenceQueue) {
            ref = this.wrapBorrowed(obj);
        }
        this.map.put(ref.getKey(), ref);
    }

    protected IdentityReference wrapBorrowed(Object obj) {
        return new IdentityWeakReference(obj, this.rq);
    }

    public void returned(Object obj) throws IllegalStateException {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot track null returned to the pool.");
        }
        this.workQueue();
        IdentityKey key = new IdentityKey(obj);
        IdentityReference ref = (IdentityReference)this.map.remove(key);
        if (ref == null) {
            throw new IllegalStateException("Cannot return an object that wasn't borrowed from this pool or has already been returned to this pool. " + obj);
        }
        ref.clear();
    }

    public int getBorrowed() {
        this.workQueue();
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workQueue() {
        ReferenceQueue referenceQueue = this.rq;
        synchronized (referenceQueue) {
            Reference ref = this.rq.poll();
            while (ref != null) {
                IdentityReference identRef = (IdentityReference)((Object)ref);
                this.referenceToBeRemoved(identRef);
                this.map.remove(identRef.getKey());
                ++this.lost;
                ref = this.rq.poll();
            }
        }
    }

    protected void referenceToBeRemoved(IdentityReference ref) {
    }

    protected int getLost() {
        return this.lost;
    }

    public String toString() {
        return "ReferenceTracker{active=" + this.map.size() + ", lost=" + this.getLost() + '}';
    }

    private static final class IdentityWeakReference
    extends WeakReference
    implements IdentityReference {
        private final int ident;

        IdentityWeakReference(Object referent, ReferenceQueue q) {
            super(referent, q);
            this.ident = System.identityHashCode(referent);
        }

        public IdentityKey getKey() {
            return new IdentityKey(this.ident);
        }
    }

    protected static interface IdentityReference {
        public IdentityKey getKey();

        public void clear();
    }

    protected static final class IdentityKey {
        private final int ident;

        IdentityKey(Object obj) {
            this(System.identityHashCode(obj));
        }

        IdentityKey(int ident) {
            this.ident = ident;
        }

        public int hashCode() {
            return this.ident;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IdentityKey that = (IdentityKey)obj;
            return this.ident == that.ident;
        }
    }
}

