/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import java.io.File;
import java.io.StringReader;
import org.alinous.AlinousCore;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.exec.pages.PostContext;
import org.alinous.parser.script.AlinousScriptParser;
import org.alinous.parser.script.ParseException;
import org.alinous.script.ISQLSentence;
import org.alinous.script.IScriptSentence;
import org.alinous.script.runtime.VariableRepository;

public class SQLTest {
    public static String sql;

    public static void sqltest01() throws Throwable {
        String sql = "select email , (select col1 from test1 limit 1) into res from sample_table as a;";
        IScriptSentence sentence = SQLTest.parse(sql);
        SQLTest.expand((ISQLSentence)sentence);
    }

    public static void sqltest02() throws Throwable {
        String sql = "select * from test1 LIMIT $NUM OFFSET $OFF";
        IScriptSentence sentence = SQLTest.parse(sql);
        SQLTest.expand((ISQLSentence)sentence);
    }

    public static void sqltest03() throws Throwable {
        String sql = "update test1 set col1 = $test2 ADJUST_SET=FALSE";
        IScriptSentence sentence = SQLTest.parse(sql);
        SQLTest.expand((ISQLSentence)sentence);
    }

    public static void sqltest04() throws Throwable {
        String sql = "delete from test1 where id = $test";
        IScriptSentence sentence = SQLTest.parse(sql);
        SQLTest.expand((ISQLSentence)sentence);
    }

    public static void sqltest05() throws Throwable {
        String sql = "insert into test1 (col1, col2) values('VAL2', (SELECT col2 from test1 WHERE col1 = 'VAL'))";
        IScriptSentence sentence = SQLTest.parse(sql);
        SQLTest.expand((ISQLSentence)sentence);
    }

    public static void sqltest06() throws Throwable {
        String sql = "SELECT * FROM TAB Y, TE A";
        SQLTest.parse(sql);
    }

    public static void sqltest07() throws Throwable {
        String sql = "SELECT TEST1.NAM,TEST3.CHILD,TEST1.CHILD FROM ((TEST1 INNER JOIN TEST3 ON TEST1.CODE = TEST3.CODE) LEFT JOIN TEST2 ON (TEST1.CODE = TEST2.CODE) AND (TEST3.SEQN = TEST2.SEQN))";
        SQLTest.parse(sql);
        sql = "SELECT A.colA, Count(col1) FROM TAB Y, TE A";
        SQLTest.parse(sql);
        sql = "SELECT * FROM TAB Y, TE A";
        SQLTest.parse(sql);
        sql = "SELECT count(A.B) FROM TAB Y, TE A";
        SQLTest.parse(sql);
        sql = "SELECT A.col1, count(*, col1, $value), A.col2 FROM TAB Y, TE A";
        SQLTest.parse(sql);
        sql = "SELECT * FROM TAB Y, TE A WHERE TAB.a = now()";
        SQLTest.parse(sql);
        sql = "SELECT * FROM TAB Y, TE A WHERE TAB.a = now() and A.x = test(A.y, $aaa)";
        SQLTest.parse(sql);
        sql = "SELECT * FROM TAB Y, TE A WHERE ((TAB.a = now() or Y.col1=A.col2) and A.x = test(A.y, $aaa))";
        SQLTest.parse(sql);
        sql = "INSERT INTO TABLE1 VALUES(now(), test(A.y, $aaa))";
        SQLTest.parse(sql);
        sql = "UPDATE TABLE1 as T SET T.col1=now(), T.colB=(test(A.y, $aaa))";
        SQLTest.parse(sql);
        sql = "UPDATE TABLE1 T SET T.col1=now(), T.colB=test(A.y, $aaa), colCo=count(*)";
        SQLTest.parse(sql);
        sql = "UPDATE TABLE1 T SET T.col1=now(), T.colB=(SELECT col2 from test1 WHERE col1 = 'VAL')";
        SQLTest.parse(sql);
    }

    private static void expand(ISQLSentence sentence) throws Throwable {
        VariableRepository valRepo = new VariableRepository();
        valRepo.putValue("test", "testvalue1", "STRING", null);
        valRepo.putValue("NUM", "10", "NUMBER", null);
        valRepo.putValue("OFF", "11", "NUMBER", null);
        AlinousCore core = SQLTest.getCore();
        AccessExecutionUnit unit = core.createAccessExecutionUnit("testSessionId");
        sentence.setConfig(core.getConfig());
        sentence.setDefaultDataSource("pgsrc");
        PostContext context = new PostContext(core, unit);
        System.out.println(sentence.execute(context, valRepo));
        unit.dispose();
    }

    private static AlinousCore getCore() throws Throwable {
        AlinousCore core = AlinousCore.getInstance("testdir" + File.separator);
        return core;
    }

    private static IScriptSentence parse(String sql) throws ParseException {
        StringReader reader = new StringReader(sql);
        AlinousScriptParser parser = new AlinousScriptParser(reader);
        IScriptSentence sentence = parser.sentence();
        return sentence;
    }
}

