/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.alinous.AlinousCore;
import org.alinous.debug.command.server.IServerCommand;
import org.alinous.expections.AlinousException;

public class AlinousDebugEventNotifier {
    private int port = -1;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void notifyToClient(IServerCommand command) throws AlinousException {
        try {
            this.sendCommand(command);
        }
        catch (IOException e) {
            throw new AlinousException(e, "Could not send command to debug client.");
        }
    }

    private void sendCommand(IServerCommand command) throws IOException {
        if (!AlinousCore.debug) {
            return;
        }
        Socket con = null;
        con = new Socket("localhost", this.port);
        OutputStream stream = null;
        Writer writer = null;
        try {
            stream = con.getOutputStream();
            writer = new PrintWriter(stream, true);
            command.writeCommand(writer);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            stream.close();
            writer.close();
            try {
                con.close();
            }
            catch (IOException e) {}
        }
    }
}

