/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.alinous.debug.DebugThread;
import org.alinous.expections.AlinousException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlinousServerDebugHttpResponse {
    public static final String TAG_ROOT = "ALINOUS_DEBUG";
    public static final String TAG_HOT_THREAD = "HOT_THREAD";
    public static final String ATTR_THREAD_ID = "threadId";
    private int result;
    private List<DebugThread> threadList = new ArrayList<DebugThread>();
    private boolean shutdown = false;
    private long hotThread;

    public AlinousServerDebugHttpResponse(int result) {
        this.result = result;
        this.hotThread = -1L;
    }

    public int getResult() {
        return this.result;
    }

    public List<DebugThread> getThreadList() {
        return this.threadList;
    }

    public void addThread(DebugThread thread) {
        this.threadList.add(thread);
    }

    public String exportAsXml() throws IOException {
        Element root = new Element(TAG_ROOT);
        Element hotThreadElement = new Element(TAG_HOT_THREAD);
        hotThreadElement.setAttribute(ATTR_THREAD_ID, Long.toString(this.hotThread));
        root.addContent((Content)hotThreadElement);
        for (DebugThread thread : this.threadList) {
            thread.exportIntoJDomElement(root);
        }
        Document doc = new Document(root);
        StringWriter writer = new StringWriter();
        new XMLOutputter().output(doc, (Writer)writer);
        String xmlStr = writer.toString();
        return xmlStr;
    }

    public void importFromXmlString(InputStream inStream) throws JDOMException, IOException, AlinousException {
        String strHotThreadId;
        Document doc = null;
        doc = new SAXBuilder().build(inStream);
        Element root = doc.getRootElement();
        Element hotThreadElement = root.getChild(TAG_HOT_THREAD);
        if (hotThreadElement != null && (strHotThreadId = hotThreadElement.getAttributeValue(ATTR_THREAD_ID)) != null) {
            this.hotThread = Long.parseLong(strHotThreadId);
        }
        this.threadList.clear();
        for (Element threadElement : root.getChildren("THREAD")) {
            DebugThread thread = new DebugThread(0L);
            thread.importFromJDomElement(threadElement);
            this.threadList.add(thread);
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public long getHotThread() {
        return this.hotThread;
    }

    public void setHotThread(long hotThread) {
        this.hotThread = hotThread;
    }

    public boolean containsThread(long threadId) {
        for (DebugThread th : this.threadList) {
            if (th.getThreadId() != threadId) continue;
            return true;
        }
        return false;
    }
}

