/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.breakstatus;

import org.alinous.debug.AlinousDebugEvent;
import org.alinous.debug.DebugStackFrame;
import org.alinous.debug.breakstatus.AbstractDebuggerOperation;
import org.alinous.exec.IExecutable;
import org.alinous.expections.AlinousException;

public class StepOverOperation
extends AbstractDebuggerOperation {
    private long currentStackId;

    public StepOverOperation(long currentStackId) {
        this.currentStackId = currentStackId;
    }

    public void handleEvent(AlinousDebugEvent event) {
        switch (event.getEventType()) {
            case 4: {
                return;
            }
        }
        this.thread.setNextExec(event.getSentence());
        long hitBreakPointId = this.hitBreakpoint(event);
        if (hitBreakPointId > 0L) {
            try {
                IExecutable exec = event.getSentence();
                this.debugManager.setHotThread(hitBreakPointId);
                this.thread.suspend(1, exec.getLine());
            }
            catch (InterruptedException e) {
                AlinousException ex = new AlinousException(e, "Could not suspend thread");
                this.debugManager.getAlinousCore().reportError(ex);
            }
            return;
        }
        DebugStackFrame current = null;
        DebugStackFrame[] frames = this.thread.getStackFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getStackId() != this.currentStackId) continue;
            current = frames[i];
            break;
        }
        if (current == null) {
            this.suspendByStepOver(event);
            return;
        }
        if (current.isPeek()) {
            this.suspendByStepOver(event);
            return;
        }
    }

    private void suspendByStepOver(AlinousDebugEvent event) {
        try {
            IExecutable exec = event.getSentence();
            this.debugManager.setHotThread(event.getThread().getThreadId());
            this.thread.suspend(3, exec.getLine());
        }
        catch (InterruptedException e) {
            AlinousException ex = new AlinousException(e, "Could not suspend thread");
            this.debugManager.getAlinousCore().reportError(ex);
        }
    }
}

