/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.command.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.debug.AlinousServerDebugHttpResponse;
import org.alinous.debug.ServerBreakpoint;
import org.alinous.debug.command.client.IClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupAllBreakPointsRequest
implements IClientRequest {
    private List<ServerBreakpoint> breakpoints = new ArrayList<ServerBreakpoint>();

    public void addBreakpoint(ServerBreakpoint breakpoint) {
        this.breakpoints.add(breakpoint);
    }

    @Override
    public AlinousServerDebugHttpResponse executeRequest(AlinousDebugManager debugManager) {
        AlinousServerDebugHttpResponse res = new AlinousServerDebugHttpResponse(0);
        debugManager.clearBreakpoints();
        for (ServerBreakpoint point : this.breakpoints) {
            debugManager.addBreakPoint(point);
        }
        return res;
    }

    @Override
    public String getCommand() {
        return "CMD_SETUP_ALL_BREAKPOINTS";
    }

    @Override
    public Map<String, String> getParamMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        int i = 0;
        for (ServerBreakpoint point : this.breakpoints) {
            String number = Integer.toString(i);
            ++i;
            m.put(number, point.toString());
        }
        return m;
    }

    @Override
    public void importParams(Map<String, String> params) {
        for (String key : params.keySet()) {
            String source = params.get(key);
            if (source.split("=").length != 2) continue;
            ServerBreakpoint point = new ServerBreakpoint(source);
            this.breakpoints.add(point);
        }
    }
}

