/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.exec.InnerModulePath;
import org.alinous.expections.AlinousException;
import org.alinous.repository.AlinousSystemRepository;

public class BackingStatusCache {
    private AlinousSystemRepository systemRepository;
    private String sessionId;

    public BackingStatusCache(AlinousSystemRepository systemRepository, String sessionId) {
        this.systemRepository = systemRepository;
        this.sessionId = sessionId;
    }

    public String getLastPath(InnerModulePath modulePath, String filePath) throws AlinousException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", modulePath.getStringPath());
        queryParams.put("FILE_PATH", filePath);
        List<Record> list = null;
        try {
            list = this.systemRepository.selectRecord("ALINOUS_BACKING_STATUS", queryParams);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to retrieve InnerStatusCache.");
        }
        if (list.size() > 0) {
            return list.get(0).getFieldValue("LAST_FILE_PATH");
        }
        return null;
    }

    public void storeLastPath(InnerModulePath modulePath, String filePath, String lastFilePath) throws AlinousException {
        DataSrcConnection con = null;
        try {
            con = this.systemRepository.getConnection();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed in connect on handling Backing cache");
        }
        try {
            con.begin();
            this.clear(con, modulePath, filePath);
        }
        catch (AlinousException e) {
            this.systemRepository.closeConnection(con);
            throw e;
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed in clear Backing cache");
        }
        Record rec = new Record();
        rec.addFieldValue("SESSION_ID", this.sessionId);
        rec.addFieldValue("MODULE_PATH", modulePath.getStringPath());
        rec.addFieldValue("FILE_PATH", filePath);
        rec.addFieldValue("LAST_FILE_PATH", lastFilePath);
        rec.addFieldValue("CREATE_TIME", AlinousUtils.getNowString());
        ArrayList<Record> recordsList = new ArrayList<Record>();
        recordsList.add(rec);
        try {
            this.systemRepository.insertRecord(con, "ALINOUS_BACKING_STATUS", recordsList);
            con.commit();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to insert FromValueCache");
        }
        finally {
            this.systemRepository.closeConnection(con);
        }
    }

    private void clear(DataSrcConnection con, InnerModulePath modulePath, String filePath) throws AlinousException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", modulePath.getStringPath());
        queryParams.put("FILE_PATH", filePath);
        try {
            this.systemRepository.deleteRecord(con, "ALINOUS_BACKING_STATUS", queryParams);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to delete FromValueCache");
        }
    }
}

