/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.exec.InnerModulePath;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.repository.AlinousSystemRepository;

public class InnerStatusCache {
    private AlinousSystemRepository systemRepository;
    private String sessionId;

    public InnerStatusCache(AlinousSystemRepository sysRepo, String sessionId) {
        this.systemRepository = sysRepo;
        this.sessionId = sessionId;
    }

    public String getLastPath(InnerModulePath modulePath) throws AlinousException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", modulePath.getStringPath());
        List<Record> list = null;
        try {
            list = this.systemRepository.selectRecord("ALINOUS_INNER_STATUS", queryParams);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to retrieve InnerStatusCache.");
        }
        if (list.size() > 0) {
            return list.get(0).getFieldValue("FILE_PATH");
        }
        return null;
    }

    public void storeLastPath(InnerModulePath modulePath, String filePath) throws AlinousException {
        DataSrcConnection con = null;
        try {
            con = this.systemRepository.getConnection();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed in connect on InnserStatusCache");
        }
        try {
            con.begin();
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to begin TRX on InnserStatusCache");
        }
        try {
            this.clear(con, modulePath);
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to delete InnserStatusCache");
        }
        catch (AlinousException e) {
            this.systemRepository.closeConnection(con);
            throw e;
        }
        Record rec = new Record();
        rec.addFieldValue("SESSION_ID", this.sessionId);
        rec.addFieldValue("MODULE_PATH", modulePath.getStringPath());
        rec.addFieldValue("FILE_PATH", filePath);
        rec.addFieldValue("CREATE_TIME", AlinousUtils.getNowString());
        ArrayList<Record> recordsList = new ArrayList<Record>();
        recordsList.add(rec);
        try {
            this.systemRepository.insertRecord(con, "ALINOUS_INNER_STATUS", recordsList);
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to delete InnserStatusCache");
        }
        try {
            con.commit();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to delete InnserStatusCache");
        }
        finally {
            this.systemRepository.closeConnection(con);
        }
    }

    public void clear(DataSrcConnection con, InnerModulePath modulePath) throws ExecutionException, DataSourceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", modulePath.getStringPath());
        this.systemRepository.deleteRecord(con, "ALINOUS_INNER_STATUS", queryParams);
    }
}

