/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.exec.ExecResultRecord;
import org.alinous.exec.VariableRepositoryStoreSupport;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.repository.AlinousSystemRepository;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionController
extends VariableRepositoryStoreSupport {
    public static final String SESSION = "SESSION";
    private String sessionId;
    private AlinousSystemRepository systemRepository;

    public SessionController(AlinousSystemRepository systemRepository, String sessionId) {
        this.systemRepository = systemRepository;
        this.sessionId = sessionId;
    }

    public void storeSession(PostContext context, VariableRepository repo) throws AlinousException {
        ScriptDomVariable sessionVariable = this.getSessionVariable(repo, context);
        HashMap<IPathElement, ExecResultRecord> variableMap = new HashMap<IPathElement, ExecResultRecord>();
        if (sessionVariable != null) {
            this.dump(sessionVariable, variableMap, context, repo);
        }
        try {
            this.doStore(variableMap);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to delete records.");
        }
    }

    private void doStore(Map<IPathElement, ExecResultRecord> variableMap) throws DataSourceException, AlinousException {
        DataSrcConnection con = null;
        try {
            con = this.systemRepository.getConnection();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed in connect on SessionController");
        }
        try {
            con.begin();
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to begin TRX on SessionController");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        try {
            this.systemRepository.deleteRecord(con, "ALINOUS_SESSION_TABLE", queryParams);
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to delete SessionCache");
        }
        catch (AlinousException e) {
            this.systemRepository.closeConnection(con);
            throw e;
        }
        ArrayList<Record> recordsList = new ArrayList<Record>();
        for (IPathElement pathElement : variableMap.keySet()) {
            ExecResultRecord val = variableMap.get(pathElement);
            Record rec = new Record();
            rec.addFieldValue("SESSION_ID", this.sessionId);
            rec.addFieldValue("VARIABLE_NAME", val.getName());
            rec.addFieldValue("TYPE", val.getType());
            rec.addFieldValue("VALUE_TYPE", val.getValueType());
            rec.addFieldValue("VALUE", val.getValue());
            rec.addFieldValue("CREATE_TIME", AlinousUtils.getNowString());
            recordsList.add(rec);
        }
        if (!recordsList.isEmpty()) {
            try {
                this.systemRepository.insertRecord(con, "ALINOUS_SESSION_TABLE", recordsList);
            }
            catch (DataSourceException e) {
                this.systemRepository.closeConnection(con);
                throw new AlinousException(e, "Failed to insert record");
            }
        }
        try {
            con.commit();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to commit Session");
        }
        finally {
            this.systemRepository.closeConnection(con);
        }
    }

    private ScriptDomVariable getSessionVariable(VariableRepository repo, PostContext context) throws ExecutionException {
        IPathElement variablePath = PathElementFactory.buildPathElement(SESSION);
        IScriptVariable sessionValue = repo.getVariable(variablePath, context);
        if (!(sessionValue instanceof ScriptDomVariable)) {
            return null;
        }
        return (ScriptDomVariable)sessionValue;
    }

    public void updateSession(VariableRepository repo, PostContext context) throws AlinousException {
        repo.release(SESSION, context);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        List<Record> recordsList = null;
        try {
            recordsList = this.systemRepository.selectRecord("ALINOUS_SESSION_TABLE", queryParams);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to read ExecutionResultCache");
        }
        repo.putValue(SESSION, this.sessionId, "STRING", null);
        for (Record rec : recordsList) {
            String namePath = rec.getFieldValue("VARIABLE_NAME");
            String type = rec.getFieldValue("TYPE");
            String valueType = rec.getFieldValue("VALUE_TYPE");
            String value = rec.getFieldValue("VALUE");
            if (!type.equals("HASH")) continue;
            repo.putValue(namePath, value, valueType, null);
        }
    }
}

