/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.alinous.AlinousCore;
import org.alinous.jdk.AlinousClassLoader;
import org.alinous.jdk.IFunctionUtils;
import org.alinous.jdk.model.FunctionModel;

public class FunctionConitainer {
    private Object function;
    private Map<String, Method> index = new HashMap<String, Method>();
    private AlinousClassLoader loader;

    public FunctionConitainer(Object func, AlinousClassLoader loader, AlinousCore core) throws ClassNotFoundException {
        this.function = func;
        this.loader = loader;
        for (int i = 0; i < IFunctionUtils.invokeGetFunctions(func).length; ++i) {
            String funcName = IFunctionUtils.invokeGetFunctions(func)[i];
            Method m = this.fingClassMethod(funcName);
            if (m == null) continue;
            this.index.put(funcName, m);
        }
        IFunctionUtils.invokeFunction(this.function, "setAlinousHome", core.getHome());
    }

    private Method fingClassMethod(String name) throws ClassNotFoundException {
        Class<?> clazz = this.loader.loadClass(this.function.getClass().getName());
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public String getPrefix() {
        return IFunctionUtils.invokeGetPrefix(this.function);
    }

    public FunctionModel findMethod(String name) {
        Method m = this.index.get(name);
        if (m == null) {
            return null;
        }
        FunctionModel model = new FunctionModel(m, this.function);
        return model;
    }
}

