/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.alinous.jdk.converter.BeanHandler;
import org.alinous.jdk.converter.BeanProperty;
import org.alinous.jdk.converter.PrimitiveHandler;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Native2Dom {
    private Object nativeObject;

    public Native2Dom(Object nativeObject) {
        this.nativeObject = nativeObject;
    }

    public IScriptVariable convert() throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        IScriptVariable retVal = this.handleObject(this.nativeObject);
        if (retVal == null) {
            retVal = new ScriptDomVariable("Null");
            ((ScriptDomVariable)retVal).setValueType("NULL");
        }
        return retVal;
    }

    private IScriptVariable handleObject(Object obj) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (obj == null) {
            return new ScriptDomVariable("null");
        }
        if (obj instanceof List) {
            return this.handleList((List)obj);
        }
        if (obj.getClass().isArray()) {
            return this.handleArrayObject((Object[])obj);
        }
        if (PrimitiveHandler.isPrimitive(obj)) {
            return this.handlePrimitive(obj);
        }
        return this.handleBean(obj);
    }

    private IScriptVariable handlePrimitive(Object obj) {
        ScriptDomVariable val = new ScriptDomVariable("");
        val.setValue(obj.toString());
        if (obj instanceof Integer) {
            val.setValueType("NUMBER");
        } else if (obj instanceof Boolean) {
            val.setValueType("BOOLEAN");
        } else if (obj instanceof Double || obj instanceof Float) {
            val.setValueType("DOUBLE");
        } else {
            val.setValueType("STRING");
        }
        return val;
    }

    private IScriptVariable handleBean(Object bean) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        BeanHandler handler = new BeanHandler(bean);
        ArrayList<BeanProperty> propList = handler.getSetterProperties();
        ScriptDomVariable val = new ScriptDomVariable("");
        for (BeanProperty prop : propList) {
            Object obj = handler.invokeGetter(prop.getGetterName(), prop.getClazz());
            IScriptVariable pVal = this.handleObject(obj);
            pVal.setName(prop.getName());
            val.put(pVal);
        }
        return val;
    }

    private IScriptVariable handleArrayObject(Object[] objectArray) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ScriptArray ar = new ScriptArray("");
        for (int i = 0; i < objectArray.length; ++i) {
            IScriptVariable val = this.handleObject(objectArray[i]);
            ar.add(val);
        }
        return ar;
    }

    private IScriptVariable handleList(List<?> list) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ScriptArray ar = new ScriptArray("");
        for (Object o : list) {
            IScriptVariable val = this.handleObject(o);
            ar.add(val);
        }
        return ar;
    }
}

