/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk.converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveHandler {
    public static boolean isPrimitive(Object obj) {
        return obj instanceof String | obj instanceof Boolean | obj instanceof Integer | obj instanceof Double | obj instanceof Float | obj instanceof Long | obj instanceof Byte | obj instanceof Character;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.equals(String.class) | clazz.equals(Boolean.class) | clazz.equals(Integer.class) | clazz.equals(Double.class) | clazz.equals(Float.class) | clazz.equals(Long.class) | clazz.equals(Byte.class) | clazz.equals(Character.class);
    }

    public static Object newInstance(Class<?> clazz, String str) {
        if (clazz.equals(String.class)) {
            return str;
        }
        if (clazz.equals(Integer.class)) {
            return new Integer(str);
        }
        if (clazz.equals(Double.class)) {
            return new Double(str);
        }
        if (clazz.equals(Float.class)) {
            return new Float(str);
        }
        if (clazz.equals(Long.class)) {
            return new Long(str);
        }
        if (clazz.equals(Byte.class)) {
            return new Byte(str);
        }
        if (clazz.equals(Character.class)) {
            return new Character(str.charAt(0));
        }
        if (clazz.equals(Boolean.class)) {
            return new Boolean(str);
        }
        return null;
    }

    public static Object fromString(String value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (clazz.equals(String.class)) {
            return value;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (clazz.equals(Double.class)) {
            return Double.parseDouble(value);
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (clazz.equals(Byte.class)) {
            return Byte.parseByte(value);
        }
        return null;
    }
}

