/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.alinous.exec.InnerModulePath;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.objects.html.AlinousTopObject;

public class HrefTargetParser {
    public static final String THIS_TARGET_ID = "this";
    private String href;
    private String tagId;
    private String toptopPage;
    private AlinousTopObject thisPage;
    private String pageSection;
    private String paramSection;
    private Map<String, String> paramsMap = new HashMap<String, String>();

    public HrefTargetParser(String href) {
        this.href = href;
    }

    public void setTargetTagId(String tagId) {
        this.tagId = tagId;
    }

    public void setTopTopPage(String topPage) {
        this.toptopPage = topPage;
    }

    public void setThisPagePath(AlinousTopObject thisPage) {
        this.thisPage = thisPage;
    }

    public String getString() throws AlinousException {
        this.parse();
        String formTargetPath = this.getTargetPath();
        this.paramsMap.put("alns:formAction", this.pageSection);
        this.paramsMap.put("alns:formTargetTagId", formTargetPath);
        StringBuffer buff = new StringBuffer();
        if (!formTargetPath.equals("")) {
            buff.append(this.toptopPage);
        } else {
            buff.append(this.pageSection);
        }
        buff.append("?");
        boolean first = true;
        for (String key : this.paramsMap.keySet()) {
            String val = this.paramsMap.get(key);
            if (key.toUpperCase().equals("alns:formAction".toUpperCase()) && formTargetPath.equals("") || key.toUpperCase().equals("alns:formTargetTagId".toUpperCase()) && formTargetPath.equals("")) continue;
            if (first) {
                first = false;
            } else {
                buff.append("&");
            }
            try {
                key = URLEncoder.encode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            buff.append(key);
            buff.append("=");
            buff.append(val);
        }
        return buff.toString();
    }

    private String getTargetPath() throws AlinousException {
        InnerModulePath modPath = this.thisPage.getModulePath().deepClone();
        if (!this.tagId.equals(THIS_TARGET_ID)) {
            modPath.addPath(this.thisPage.getPath());
            modPath.addTarget(this.tagId);
        }
        return modPath.getStringPath();
    }

    private void parse() throws ExecutionException {
        String[] sections = this.href.split("\\?");
        this.pageSection = sections[0];
        if (this.pageSection.endsWith("/")) {
            this.pageSection = this.pageSection + "index.html";
        }
        if (sections.length <= 1) {
            return;
        }
        this.paramSection = sections[1];
        String[] params = this.paramSection.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] mapStrs = params[i].split("=");
            if (mapStrs.length != 2) continue;
            this.paramsMap.put(mapStrs[0], mapStrs[1]);
        }
    }
}

