/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import org.alinous.AlinousConfig;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.StatementJDomFactory;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.statement.FunctionCall;
import org.jdom.Content;
import org.jdom.Element;

public class FunctionCallSentence
implements IScriptSentence {
    private FunctionCall functionCall;
    private int line;
    private int linePosition;
    private String filePath;
    private AlinousConfig config;

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        this.functionCall.setFilePath(this.filePath);
        this.functionCall.executeStatement(context, valRepo);
        return true;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element fancCallSentenceElement = new Element("EXECUTABLE");
        fancCallSentenceElement.setAttribute("execClass", this.getClass().getName());
        parent.addContent((Content)fancCallSentenceElement);
        this.functionCall.exportIntoJDomElement(fancCallSentenceElement);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element el = element.getChild("className");
        if (el != null) {
            this.functionCall = (FunctionCall)StatementJDomFactory.createStatementFromDom(el);
            this.functionCall.importFromJDomElement(el);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(FunctionCall functionCall) {
        functionCall.setCallerSentence(this);
        this.functionCall = functionCall;
    }

    public AlinousConfig getConfig() {
        return this.config;
    }

    public void setConfig(AlinousConfig config) {
        this.config = config;
    }

    public StepInCandidates getStepInCandidates() {
        StepInCandidates candidates = new StepInCandidates();
        this.functionCall.canStepInStatements(candidates);
        return candidates;
    }

    public IScriptVariable getReturnedVariable() {
        return null;
    }
}

