/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.runtime.ArrayPathElement;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.JDomScriptObjectFactory;
import org.alinous.script.runtime.PathElement;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableRepository
implements IScriptVariable {
    public static final String TAG_VALUE_REPOSITORY = "VALUE_REPOSITORY";
    private ConcurrentHashMap<String, IScriptVariable> variables = new ConcurrentHashMap();

    public void putValue(IScriptVariable value) {
        value.setParentArrayIndex(-1);
        value.setParent(this);
        this.variables.put(value.getName(), value);
    }

    public void putValue(String variablePath, String value, String valueType, PostContext context) throws ExecutionException {
        IPathElement element = PathElementFactory.buildPathElement(variablePath);
        IScriptVariable variable = this;
        while (!element.isLeaf()) {
            variable = element.input(variable, context, this);
            element = element.getChild();
        }
        if (variable instanceof ScriptDomVariable) {
            String pathFlagment = ((PathElement)element).getPath();
            IScriptVariable currentV = variable.get(pathFlagment);
            if (currentV instanceof ScriptDomVariable) {
                ScriptDomVariable newVariable = (ScriptDomVariable)currentV;
                newVariable.setValue(value);
                newVariable.setValueType(valueType);
            } else {
                ScriptDomVariable newVariable = new ScriptDomVariable(pathFlagment);
                newVariable.setValue(value);
                newVariable.setValueType(valueType);
                ((ScriptDomVariable)variable).put(newVariable);
            }
        } else if (variable instanceof VariableRepository) {
            String pathFlagment = ((PathElement)element).getPath();
            IScriptVariable currentV = variable.get(pathFlagment);
            if (currentV instanceof ScriptDomVariable) {
                ScriptDomVariable newVariable = (ScriptDomVariable)currentV;
                newVariable.setValue(value);
                newVariable.setValueType(valueType);
            } else {
                ScriptDomVariable newVariable = new ScriptDomVariable(pathFlagment);
                newVariable.setValue(value);
                newVariable.setValueType(valueType);
                this.putValue(newVariable);
            }
        } else {
            ScriptDomVariable newVariable = new ScriptDomVariable("");
            newVariable.setValue(value);
            newVariable.setValueType(valueType);
            ScriptArray arrayParent = (ScriptArray)variable;
            ArrayPathElement arrayPathElenent = (ArrayPathElement)element;
            ScriptDomVariable indexDomValue = (ScriptDomVariable)arrayPathElenent.getNumber().executeStatement(context, this);
            arrayParent.putAt(newVariable, Integer.parseInt(indexDomValue.getValue()));
        }
    }

    public void putValue(IPathElement path, IScriptVariable value, PostContext context) throws ExecutionException {
        IPathElement lastPathElement = path.getLast();
        IPathElement containerPathElement = path.removeLast();
        if (lastPathElement instanceof PathElement) {
            String valueName = ((PathElement)lastPathElement).getPath();
            value.setName(valueName);
        }
        IScriptVariable container = null;
        container = containerPathElement == null || containerPathElement instanceof VariableRepository ? this : this.getAndMakeVariableFromPath(containerPathElement, context);
        if (container instanceof VariableRepository) {
            container.putValue(value);
        } else if (container instanceof ScriptDomVariable) {
            ((ScriptDomVariable)container).put(value);
        } else if (container instanceof ScriptArray) {
            IStatement stmt = ((ArrayPathElement)lastPathElement).getNumber();
            ScriptDomVariable valNum = (ScriptDomVariable)stmt.executeStatement(context, this);
            int pos = Integer.parseInt(valNum.getValue());
            ((ScriptArray)container).putAt(value, pos);
        }
    }

    public void release(String path, PostContext context) throws ExecutionException {
        IPathElement element = PathElementFactory.buildPathElement(path);
        this.release(element, context);
    }

    public void release(IPathElement path, PostContext context) throws ExecutionException {
        IScriptVariable val = this.getVariable(path, context);
        if (val == null) {
            return;
        }
        IScriptVariable parentVal = val.getParent();
        if (parentVal instanceof ScriptDomVariable) {
            ((ScriptDomVariable)parentVal).releaseProperty(val.getName());
        } else {
            if (parentVal instanceof ScriptArray) {
                throw new ExecutionException("Cannot release object in the array.");
            }
            if (parentVal instanceof VariableRepository) {
                ((VariableRepository)parentVal).variables.remove(val.getName());
            }
        }
    }

    public IScriptVariable getValue(String key) {
        return this.variables.get(key);
    }

    @Override
    public IScriptVariable get(String key) {
        return this.getValue(key);
    }

    public Iterator<String> getKeyIterator() {
        return this.variables.keySet().iterator();
    }

    @Override
    public void exportIntoJDomElement(Element parent) {
        Element repositoryElement = new Element(TAG_VALUE_REPOSITORY);
        for (String prop : this.variables.keySet()) {
            IScriptVariable val = this.variables.get(prop);
            val.exportIntoJDomElement(repositoryElement);
        }
        parent.addContent((Content)repositoryElement);
    }

    @Override
    public void importFromJDomElement(Element repositoryElement) {
        List list = repositoryElement.getChildren();
        for (Element element : list) {
            IScriptVariable val = JDomScriptObjectFactory.createScriptVariable(element);
            val.importFromJDomElement(element);
            this.variables.put(val.getName(), val);
            val.setParent(this);
            val.setParentArrayIndex(-1);
        }
    }

    @Override
    public String getName() {
        return "REPOSITORY";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getType() {
        return "REPOSITORY";
    }

    public IScriptVariable getAndMakeVariableFromPath(String variablePath, PostContext context) throws ExecutionException {
        IScriptVariable variable = this;
        for (IPathElement element = PathElementFactory.buildPathElement(variablePath); element != null; element = element.getChild()) {
            variable = element.input(variable, context, this);
        }
        return variable;
    }

    public IScriptVariable getAndMakeVariableFromPath(IPathElement variablePath, PostContext context) throws ExecutionException {
        IScriptVariable variable = this;
        for (IPathElement element = variablePath; element != null; element = element.getChild()) {
            variable = element.input(variable, context, this);
        }
        return variable;
    }

    public IScriptVariable getVariable(IPathElement variablePath, PostContext context) throws ExecutionException {
        IScriptVariable variable = this;
        for (IPathElement element = variablePath; element != null && variable != null; element = element.getChild()) {
            if (element instanceof PathElement) {
                PathElement pathEl = (PathElement)element;
                if ((variable = variable.get(pathEl.getPath())) != null) continue;
                return null;
            }
            if (!(element instanceof ArrayPathElement)) continue;
            if (!(variable instanceof ScriptArray)) {
                return null;
            }
            ScriptArray array = (ScriptArray)variable;
            ArrayPathElement arrayEl = (ArrayPathElement)element;
            ScriptDomVariable numVal = (ScriptDomVariable)arrayEl.getNumber().executeStatement(context, this);
            if ((variable = array.get(Integer.parseInt(numVal.getValue()))) != null) continue;
            return null;
        }
        return variable;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VariableRepository repo = new VariableRepository();
        for (String key : this.variables.keySet()) {
            IScriptVariable innerVariable = this.variables.get(key);
            repo.variables.put(key, (IScriptVariable)innerVariable.clone());
        }
        return repo;
    }

    @Override
    public IScriptVariable getParent() {
        return null;
    }

    @Override
    public void setParent(IScriptVariable parent) {
    }

    @Override
    public IPathElement getPath() {
        return null;
    }

    @Override
    public int getParentArrayIndex() {
        return 0;
    }

    @Override
    public void setParentArrayIndex(int parentArrayIndex) {
    }

    @Override
    public void canStepInStatements(StepInCandidates candidates) {
    }

    @Override
    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        return null;
    }

    @Override
    public void setCallerSentence(IScriptSentence callerSentence) {
    }
}

