/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql.condition;

import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.condition.ISQLExpression;
import org.alinous.script.sql.statement.ISQLStatement;

public class TwoClauseExpression
implements ISQLExpression {
    private ISQLStatement left;
    private ISQLStatement right;
    private String ope;
    private VariableRepository valueProvidor;
    private AdjustWhere adjustWhere;

    public ISQLStatement getLeft() {
        return this.left;
    }

    public void setLeft(ISQLStatement left) {
        this.left = left;
    }

    public ISQLStatement getRight() {
        return this.right;
    }

    public void setRight(ISQLStatement right) {
        this.right = right;
    }

    public String getOpe() {
        return this.ope;
    }

    public void setOpe(String ope) {
        this.ope = ope;
    }

    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
        this.valueProvidor = providor;
        this.adjustWhere = adjustWhere;
        this.left.acceptVariables(this.valueProvidor, adjustWhere, adjustSet);
        this.right.acceptVariables(this.valueProvidor, adjustWhere, adjustSet);
    }

    public String extract() throws ExecutionException {
        String leftStr = this.left.extract();
        String rightStr = this.right.extract();
        if (rightStr != null && rightStr.toLowerCase().equals("null") && this.ope.equals("=")) {
            return leftStr + " IS NULL";
        }
        if (rightStr != null && rightStr.toLowerCase().equals("null") && this.ope.equals("<>")) {
            return leftStr + " IS NOT NULL";
        }
        return leftStr + " " + this.ope + " " + rightStr;
    }

    public boolean isReady() throws ExecutionException {
        if (this.ope.equals("=") && this.adjustWhere != null && !this.adjustWhere.adjust()) {
            return true;
        }
        return this.left.isReady() && this.right.isReady();
    }
}

