/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.statement;

import java.util.Iterator;
import java.util.Stack;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.jdk.model.FunctionModel;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.functions.FuncDeclarations;
import org.alinous.script.functions.FunctionDeclaration;
import org.alinous.script.functions.FunctionRegistory;
import org.alinous.script.functions.IFunction;
import org.alinous.script.functions.system.JavaConnectorFunction;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.statement.FuncArguments;
import org.jdom.Content;
import org.jdom.Element;

public class FunctionCall
implements IStatement {
    private String packageName;
    private String funcName;
    private FuncArguments args;
    private int line;
    private int linePosition;
    private String filePath;
    private IScriptSentence callerSentence;

    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        FuncDeclarations funcDec;
        IFunction func;
        String qualifiedName = this.packageName + "." + this.funcName;
        if (this.packageName == null) {
            qualifiedName = this.funcName;
        }
        if ((func = (funcDec = context.getUnit().getExecModule().getScript().getFuncDeclarations()).findFunctionDeclare(qualifiedName)) != null) {
            return this.executeSourceFunc((FunctionDeclaration)func, context, valRepo);
        }
        func = FunctionRegistory.getInstance().findDeclaration(qualifiedName);
        if (func != null) {
            return this.executeSystemFunc(func, context, valRepo);
        }
        FunctionModel funcModel = context.getCore().getJavaConnector().findFunction(qualifiedName);
        if (funcModel == null) {
            throw new ExecutionException("Function does not declared.");
        }
        return this.executeJavaConnectorFunction(qualifiedName, funcModel, context, valRepo);
    }

    private IScriptVariable executeJavaConnectorFunction(String name, FunctionModel funcModel, PostContext context, VariableRepository valRepo) throws ExecutionException {
        JavaConnectorFunction func = new JavaConnectorFunction(name, funcModel);
        this.handleRuntimeArguments(func);
        func.setCallerSentence(this.callerSentence);
        func.execute(context, valRepo);
        return func.getResult();
    }

    private IScriptVariable executeSystemFunc(IFunction func, PostContext context, VariableRepository valRepo) throws ExecutionException {
        this.handleRuntimeArguments(func);
        func.setCallerSentence(this.callerSentence);
        func.execute(context, valRepo);
        return func.getResult();
    }

    private IScriptVariable executeSourceFunc(FunctionDeclaration func, PostContext context, VariableRepository valRepo) throws ExecutionException {
        func.setConfig(context.getCore().getConfig());
        func.setDataSourceManager(context.getCore().getDataSourceManager());
        this.handleRuntimeArguments(func);
        func.setCallerSentence(this.callerSentence);
        func.execute(context, valRepo);
        return func.getResult();
    }

    private void handleRuntimeArguments(IFunction func) {
        if (this.args == null) {
            return;
        }
        Stack<IStatement> stmtStack = new Stack<IStatement>();
        Iterator<IStatement> it = this.args.iterator();
        while (it.hasNext()) {
            IStatement stmt = it.next();
            stmtStack.push(stmt);
        }
        func.inputArguments(stmtStack);
    }

    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public FuncArguments getArgs() {
        return this.args;
    }

    public void setArgs(FuncArguments args) {
        this.args = args;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        if (this.args != null) {
            this.args.exportIntoJDomElement(element);
        }
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element ch = element.getChild("ARGUMENTS");
        if (ch != null) {
            this.args = new FuncArguments();
            this.args.importFromJDomElement(ch);
        }
    }

    public void canStepInStatements(StepInCandidates candidates) {
        IFunction func;
        String qualifiedName = this.packageName + "." + this.funcName;
        if (this.packageName == null) {
            qualifiedName = this.funcName;
        }
        if ((func = FunctionRegistory.getInstance().findDeclaration(qualifiedName)) == null) {
            candidates.addCandidate(this);
        }
        if (this.args != null) {
            this.args.canStepInStatements(candidates);
        }
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
    }
}

