/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.statement;

import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.StatementJDomFactory;
import org.alinous.script.basic.type.VariableDescriptor;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class PlusPlusStatement
implements IStatement {
    private IStatement stmt;
    private String preOpe;
    private String postOpe;
    private IScriptSentence callerSentence;
    private int line;
    private int linePosition;

    public IStatement getStmt() {
        return this.stmt;
    }

    public void setStmt(IStatement stmt) {
        stmt.setCallerSentence(this.callerSentence);
        this.stmt = stmt;
    }

    public String getPostOpe() {
        return this.postOpe;
    }

    public void setPostOpe(String postOpe) {
        this.postOpe = postOpe;
    }

    public String getPreOpe() {
        return this.preOpe;
    }

    public void setPreOpe(String preOpe) {
        this.preOpe = preOpe;
    }

    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (!(this.stmt instanceof VariableDescriptor)) {
            throw new ExecutionException("Cannot use ++ operator to the statement but variable");
        }
        VariableDescriptor valDesc = (VariableDescriptor)this.stmt;
        IScriptVariable val = this.stmt.executeStatement(context, valRepo);
        if (!(val instanceof ScriptDomVariable)) {
            throw new ExecutionException("Cannot use ++ operator to Array");
        }
        ScriptDomVariable domVal = (ScriptDomVariable)val;
        if (domVal.getValueType() != "NUMBER") {
            throw new ExecutionException("Cannot use ++ operator to String");
        }
        String strValue = domVal.getValue();
        int intValue = Integer.parseInt(strValue);
        if (this.preOpe != null) {
            if (this.preOpe.equals("++")) {
                domVal.setValue(Integer.toString(intValue + 1));
            } else {
                domVal.setValue(Integer.toString(intValue - 1));
            }
            valRepo.putValue(domVal);
        } else if (this.postOpe.equals("++")) {
            context.addPluePlus(domVal, valDesc.getPath());
        } else {
            context.addMinusMinus(domVal, valDesc.getPath());
        }
        return domVal;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        this.stmt.exportIntoJDomElement(element);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element el = element.getChild("STATEMENT");
        this.stmt = StatementJDomFactory.createStatementFromDom(el);
        this.stmt.importFromJDomElement(el);
    }

    public void canStepInStatements(StepInCandidates candidates) {
        this.stmt.canStepInStatements(candidates);
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        if (this.stmt != null) {
            this.stmt.setCallerSentence(callerSentence);
        }
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }
}

