// AbbreviationsDlg.cpp
// (c) 2004-2006 exeal

#include "StdAfx.h"
#include "resource.h"
#include "Alpha.h"
#include "AbbreviationsDlg.h"
#include "Ascension\EditView.h"
#include "../Manah/CommonControls.hpp"

using Alpha::AlphaApp;
using Alpha::AbbreviationsDlg;
using namespace Ascension;
using namespace Manah::Windows::Controls;
using namespace std;


/// @see Dialog::onCommand
bool AbbreviationsDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	if(id == IDC_BTN_ADD) {	// [ǉ]
		NewAbbreviationDlg dlg(abbreviationsList_);
		if(IDOK == dlg.doModal(*this)) {
			const int item = abbreviationsList_.insertItem(0, dlg.getAbbreviation().c_str());
			if(item != -1)
				abbreviationsList_.setItem(item, 1, LVIF_TEXT, dlg.getExpandedString().c_str(), 0, 0, 0, 0);
			update();
		}
	} else if(id == IDC_BTN_DELETE) {	// [폜]
		abbreviationsList_.deleteItem(abbreviationsList_.getSelectionMark());
		update();
	} else if(id == IDC_BTN_CLEAR) {	// [ׂč폜]
		abbreviationsList_.deleteAllItems();
		update();
	}

	return Dialog::onCommand(id, notifyCode, control);
}

/// @see Dialog::onInitDialog
bool AbbreviationsDlg::onInitDialog(HWND focusWindow, LPARAM initParam) {
	set<string_t> abbrs;
	
	Dialog::onInitDialog(focusWindow, initParam);

	abbreviationsList_.setExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	abbreviationsList_.insertColumn(0, AlphaApp::getInstance().loadString(MSG_ABBREVIATION).c_str(), LVCFMT_LEFT, 80);
	abbreviationsList_.insertColumn(1, AlphaApp::getInstance().loadString(MSG_EXPANDED_ABBREVIATION).c_str(), LVCFMT_LEFT, 260);
	EditView::getAbbreviations().getList(abbrs);
	for(set<string_t>::const_iterator it = abbrs.begin(); it != abbrs.end(); ++it) {
		const int item = abbreviationsList_.insertItem(0, it->c_str());
		abbreviationsList_.setItem(item, 1, LVIF_TEXT, EditView::getAbbreviations().expand(*it).c_str(), 0, 0, 0, 0);
	}
	update();

	return true;
}

/// @see Dialog::onOK
void AbbreviationsDlg::onOK() {
	EditView::getAbbreviations().removeAll();
	for(int i = 0; i < abbreviationsList_.getItemCount(); ++i)
		EditView::getAbbreviations().insert(abbreviationsList_.getItemText(i, 0), abbreviationsList_.getItemText(i, 1));
	Dialog::onOK();
}

/// {^̗L/Ȃ
void AbbreviationsDlg::update() {
	if(abbreviationsList_.getItemCount() == 0) {
		::EnableWindow(getDlgItem(IDC_BTN_DELETE), false);
		::EnableWindow(getDlgItem(IDC_BTN_CLEAR), false);
		::SetFocus(getDlgItem(IDC_BTN_ADD));	// 폜ñ{^ɂȂ̂
	} else {
		abbreviationsList_.setItemState(0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
		::EnableWindow(getDlgItem(IDC_BTN_DELETE), true);
		::EnableWindow(getDlgItem(IDC_BTN_CLEAR), true);
	}
}


// NewAbbreviationDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/// @see Dialog::onCommand
bool AbbreviationsDlg::NewAbbreviationDlg::onCommand(WORD id, WORD notifyCode, HWND control) {
	if(notifyCode == EN_CHANGE) {
		::EnableWindow(getDlgItem(IDOK),
			abbreviationTextbox_.getWindowTextLength() != 0
			&& expansionTextbox_.getWindowTextLength() != 0);
		return true;
	}
	return Dialog::onCommand(id, notifyCode, control);
}

/// @see Dialog::onOK
void AbbreviationsDlg::NewAbbreviationDlg::onOK() {
	if(abbreviationTextbox_.getWindowTextLength() == 0 || expansionTextbox_.getWindowTextLength() == 0)
		return;

	LVFINDINFOW fi;
	int found;
	const wstring abbr = abbreviationTextbox_.getWindowText();
	const wstring expd = expansionTextbox_.getWindowText();

	fi.flags = LVFI_STRING;
	fi.psz = abbr.c_str();
	found = listControl_.findItem(fi, -1);
	if(found != -1) {
		const wstring item = listControl_.getItemText(found, 0);
		if(item != abbr)
			found = -1;
	}
	if(found != -1) {
		messageBox(AlphaApp::getInstance().loadString(MSG_CONFLICTED_ABBREVIATION).c_str(), IDS_APPNAME, MB_ICONEXCLAMATION);
		return;
	}

	Dialog::onOK();
}

/* [EOF] */