// AbbreviationsDlg.h
// (c) 2004-2006 exeal

#ifndef ABBREVIATIONS_DLG_H_
#define ABBREVIATIONS_DLG_H_
#include "../Manah/Dialog.hpp"


namespace Alpha {

/// [Zk̊Ǘ] _CAO
class AbbreviationsDlg : public Manah::Windows::Controls::FixedIDDialog<IDD_DLG_ABBREVIATIONS> {
	// \bh
private:
	void	update();

	// bZ[Wnh
protected:
	bool	onCommand(WORD id, WORD notifyCode, HWND control);	// WM_COMMAND
	bool	onInitDialog(HWND focusWindow, LPARAM initParam);	// WM_INITDIALOG
	void	onOK();												// IDOK

	Manah::Windows::Controls::ListCtrl abbreviationsList_;
	BEGIN_CONTROL_BINDING()
		BIND_CONTROL(IDC_LIST_ABBREVIATIONS, abbreviationsList_)
	END_CONTROL_BINDING()

	// NX
private:
	class NewAbbreviationDlg : public Manah::Windows::Controls::FixedIDDialog<IDD_DLG_NEWABBREV> {
	public:
		// RXgN^
		NewAbbreviationDlg(Manah::Windows::Controls::ListCtrl& listControl) : listControl_(listControl) {}
		// \bh
		const std::wstring getAbbreviation() const throw() {return abbreviation_;}
		const std::wstring getExpandedString() const throw() {return expanded_;}

		// bZ[Wnh
	protected:
		bool	onCommand(WORD id, WORD notifyCode, HWND control);
		void	onOK();

		// f[^o
	private:
		std::wstring abbreviation_;
		std::wstring expanded_;
		Manah::Windows::Controls::ListCtrl& listControl_;
		Manah::Windows::Controls::Edit abbreviationTextbox_;
		Manah::Windows::Controls::Edit expansionTextbox_;
		BEGIN_CONTROL_BINDING()
			BIND_CONTROL(IDC_EDIT_INPUT, abbreviationTextbox_)
			BIND_CONTROL(IDC_EDIT_OUTPUT, expansionTextbox_)
		END_CONTROL_BINDING()
	};
};

} // namespace Alpha

#endif /* ABBREVIATIONS_DLG_H_ */

/* [EOF] */