// Alpha.cpp : AvP[Vp̃Gg |Cg̒`
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "Ambient.h"
#include "CommandManager.h"
#include "EventHandlerScript.h"
#include "MRUManager.h"
#include "AboutDlg.h"
#include "FindDlg.h"
#include "BookmarkDlg.h"
#include "CodePagesDlg.h"
//#include "DebugDlg.h"
#include "SelectLanguageDlg.h"
#include "../Manah/WaitCursor.hpp"
#include "../Manah/DC.hpp"
#include "../Manah/GDIObject.hpp"
#include <algorithm>
#include <fstream>
#include <commdlg.h>	// ChooseFont
#include <shlwapi.h>	// PathXxxx
#include <comcat.h>		// ICatInformation
#include <dlgs.h>
//#include "Msxml3.tlh"	// MSXML2::IXMLDOMDocument
using namespace Alpha;
using namespace Ascension;
using namespace Ascension::Encodings;
using namespace Ascension::StandardCommands;
using namespace Manah::Windows;
using namespace Manah::Windows::GDI;
using namespace Armaiti;
using namespace std;


// O[o֐
/////////////////////////////////////////////////////////////////////////////

/// Gg|Cg
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE /* hPrevInstance */, LPSTR /* lpCmdLine */, int nCmdShow) {
	OSVERSIONINFOA osvi;

	// Shift L[ȂNƉpꃂ[hɂȂ悤ɂĂ݂
	if(toBoolean(::GetAsyncKeyState(VK_SHIFT) & 0x8000)) {
		::MessageBeep(MB_OK);
		::SetThreadLocale(MAKELCID(MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), SORT_DEFAULT));
		::InitMUILanguage(MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US));
	}

#ifdef _DEBUG
	::_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF | _CRTDBG_CHECK_EVERY_1024_DF);
#endif /* _DEBUG */

	// NT nׂ
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOA);
	::GetVersionExA(&osvi);
	if(!toBoolean(osvi.dwPlatformId & VER_PLATFORM_WIN32_NT)) {
		char prompt[100];
		::LoadStringA(hInstance, MSG_UNSUPPORTED_OS_VERSION, prompt, countof(prompt));
		::MessageBoxA(0, prompt, "Alpha", MB_ICONHAND);	// title is obtained from IDS_APPNAME
		return -1;
	}
	HANDLE mutex = ::CreateMutexW(0, false, IDS_APPFULLVERSION);

	int	exitCode = 0/*EXIT_SUCCESS*/;

	// ȒPȑdN}~ (Ctrl L[ȂNƑdN悤ɂĂ݂)
	if(::GetLastError() != ERROR_ALREADY_EXISTS || toBoolean(::GetAsyncKeyState(VK_CONTROL) & 0x8000)) {
		::OleInitialize(0);	// STA ɓ + T[rX̏
		Controls::initCommonControls(ICC_COOL_CLASSES | ICC_PAGESCROLLER_CLASS | ICC_WIN95_CLASSES);
		AlphaApp* application = new AlphaApp();
		exitCode = application->run(nCmdShow);
		delete application;
		::OleUninitialize();
	} else {	// ̃vZXɃR}hCn
		HWND existWnd = ::FindWindowW(IDS_APPNAME, 0);
		while(!toBoolean(::IsWindow(existWnd))) {
			::Sleep(1000);
			existWnd = ::FindWindowW(IDS_APPNAME, 0);
		}
		const WCHAR* const commandLine = ::GetCommandLineW();
		const size_t commandLineLength = wcslen(commandLine);
		WCHAR* data = new WCHAR[commandLineLength + 1 + MAX_PATH];
		::GetCurrentDirectory(MAX_PATH, data);
		wcscpy(data + MAX_PATH, commandLine);
		AutoZero<COPYDATASTRUCT> cd;
		cd.lpData = data;
		cd.cbData = static_cast<DWORD>(sizeof(WCHAR) * (commandLineLength + 1 + MAX_PATH));
		::SendMessageW(existWnd, WM_COPYDATA, 0, reinterpret_cast<LPARAM>(&cd));
		::Sleep(300);
		::SetForegroundWindow(existWnd);
		delete[] data;
	}
	::CloseHandle(mutex);

	return exitCode;
}

namespace {
	inline void showLastErrorMessage(HWND parent = 0) {
		void* buffer;
		::FormatMessageW(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			0, ::GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), reinterpret_cast<wchar_t*>(&buffer), 0, 0);
		::MessageBoxW(parent, static_cast<wchar_t*>(buffer), IDS_APPNAME, MB_OK);
		::LocalFree(buffer);
	}

	// XbVƃobNXbV̌
	inline void s2b(WCHAR* first, WCHAR* last) {
		std::replace_if(first, last, std::bind2nd(std::equal_to<WCHAR>(), L'/'), L'\\');
	}
	inline void b2s(WCHAR* first, WCHAR* last) {
		std::replace_if(first, last, std::bind2nd(std::equal_to<WCHAR>(), L'\\'), L'/');
	}
	inline void s2b(std::basic_string<WCHAR>& s) {
		std::replace_if(s.begin(), s.end(), std::bind2nd(std::equal_to<WCHAR>(), L'/'), L'\\');
	}
	inline void b2s(std::basic_string<WCHAR>& s) {
		std::replace_if(s.begin(), s.end(), std::bind2nd(std::equal_to<WCHAR>(), L'\\'), L'/');
	}

	/// ChooseFontW ̂߂̃tbNvVW
	UINT_PTR CALLBACK chooseFontHookProc(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
		if(message == WM_COMMAND && LOWORD(wParam) == psh3) {	// [Kp] {^
			LOGFONTW lf;
			::SendMessageW(dialog, WM_CHOOSEFONT_GETLOGFONT, 0, reinterpret_cast<LPARAM>(&lf));
			AlphaApp::getInstance().setFont(lf);
			return true;
		} else if(message == WM_INITDIALOG) {
			::EnableWindow(::GetDlgItem(dialog, stc2), false);	// [X^C] 𖳌
			::EnableWindow(::GetDlgItem(dialog, cmb2), false);
		}
		return 0;
	}
} // namespace `anonymous'


// AlphaApp class implementation
/////////////////////////////////////////////////////////////////////////////

AlphaApp* AlphaApp::instance_ = 0;

/// RXgN^
AlphaApp::AlphaApp()
		: menu_(0), fileOpeMenu_(0), newDocTypeMenu_(new Controls::Menu), appDocTypeMenu_(0),
		editorFont_(0), eventHandlerScript_(0), mruManager_(0), automation_(0),
		twoStroke1stKey_(VK_NULL), twoStroke1stModifiers_(0),
		temporaryMacroDefiningIcon_(0), temporaryMacroPausingIcon_(0), narrowingIcon_(0) {
	assert(AlphaApp::instance_ == 0);
	AlphaApp::instance_ = this;
	commandManager_.reset(new CommandManager(*this));
	scriptMacroManager_.reset(new ScriptMacroManager(*this));
	searchDialog_.reset(new FindDlg(*this));
	bookmarkDialog_.reset(new BookmarkDlg(*this));
	onSettingChange(0, 0);	// statusFont_ ̏
}

/// fXgN^
AlphaApp::~AlphaApp() {
	::DeleteObject(statusFont_);
	::DestroyIcon(temporaryMacroDefiningIcon_);
	::DestroyIcon(temporaryMacroPausingIcon_);
	::DestroyIcon(narrowingIcon_);
	delete fileOpeMenu_;
	delete newDocTypeMenu_;
	delete appDocTypeMenu_;
	delete eventHandlerScript_;
	if(automation_ != 0)
		automation_->Release();
	AlphaApp::instance_ = 0;
}

/**
 *	w肵r[ɃhLg^CvKp
 *	@param buffer	obt@
 *	@param typeName	Kp镶^CvB󕶎w肷Ɗgqɍ̂Kp
 */
void AlphaApp::applyDocumentType(AlphaDoc& buffer, const wstring& typeName /* = L"" */) {
	assertValid();

	Manah::Windows::WaitCursor wc;
	AlphaView& view = buffer.getView(0);

	// CxgnhĂяo
	const wstring docTypeName = typeName.empty() ?
		buffers_->getDocumentTypeManager().getByFileName(buffer.getFileName()).name : typeName;

	if(docTypeName.empty() || docTypeName != buffer.getDocumentType()) {
		AutoZero<DISPPARAMS> params;
		ITextEditor* editor;

		view.getAutomation(editor);
		view.freeze();
		view.getLexer().freeze();
		view.getLexer().reset();
		params.cArgs = 2;
		params.rgvarg = new VARIANTARG[params.cArgs];
		params.rgvarg[1].vt = VT_BSTR;
		params.rgvarg[1].bstrVal = ::SysAllocString(docTypeName.c_str());
		params.rgvarg[0].vt = VT_DISPATCH;
		params.rgvarg[0].pdispVal = editor;
		const HRESULT hr = eventHandlerScript_->invoke(OLESTR("OnApplyDocumentType"), params);
		::SysFreeString(params.rgvarg[1].bstrVal);
		params.rgvarg[0].pdispVal->Release();
		delete[] params.rgvarg;
		view.getLexer().unfreeze();
		buffer.setDocumentType(docTypeName);
		view.unfreeze();
	}
	updateStatusBar(SBP_DOCUMENTTYPE);
}

LRESULT CALLBACK AlphaApp::appWndProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam) {
	return (instance_ != 0) ?
		instance_->dispatchEvent(window, message, wParam, lParam) : ::DefWindowProc(window, message, wParam, lParam);
}

/// [tHg] _CAO\ăGfB^̃tHgύX
void AlphaApp::changeFont() {
	AlphaView& activeView = buffers_->getActiveView();
	LOGFONTW font;
	AutoZeroLS<CHOOSEFONTW> cf;

	getTextEditorFont(font);
	cf.hwndOwner = getMainWindow().getSafeHwnd();
	cf.lpLogFont = &font;
	cf.lpfnHook = chooseFontHookProc;
	cf.Flags = CF_APPLY | CF_ENABLEHOOK | CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS;
	cf.hInstance = getHandle();

	if(toBoolean(::ChooseFontW(&cf))) {
		font.lfItalic = false;
		font.lfWeight = FW_REGULAR;
		setFont(font);
	}
}

/// bZ[W̐U蕪
LRESULT	AlphaApp::dispatchEvent(HWND window, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_ACTIVATE:
		return 0L;
	case WM_COMMAND:
		return onCommand(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
	case WM_CLOSE:
		onClose();
		return 0;
	case WM_COPYDATA:
		onCopyData(reinterpret_cast<HWND>(wParam), *reinterpret_cast<PCOPYDATASTRUCT>(lParam));
		break;
	case WM_CREATE:
		break;
	case WM_DESTROY:
		onDestroy();
		break;
	case WM_DRAWITEM:
		onDrawItem(static_cast<UINT>(wParam), *reinterpret_cast<LPDRAWITEMSTRUCT>(lParam));
		break;
	case WM_DROPFILES:
		onDropFiles(reinterpret_cast<HDROP>(wParam));
		break;
	case WM_ENTERMENULOOP:
		onEnterMenuLoop(toBoolean(wParam));
		break;
	case WM_EXITMENULOOP:
		onExitMenuLoop(toBoolean(wParam));
		break;
	case WM_INITMENUPOPUP:
		onInitMenuPopup(reinterpret_cast<HMENU>(wParam), LOWORD(lParam), toBoolean(HIWORD(lParam)));
		break;
	case WM_MEASUREITEM:
		onMeasureItem(static_cast<UINT>(wParam), *reinterpret_cast<LPMEASUREITEMSTRUCT>(lParam));
		break;
	case WM_MENUCHAR: {
		auto_ptr<Controls::Menu> activePopup(new Controls::Menu(reinterpret_cast<HMENU>(lParam)));
		LRESULT res = onMenuChar(LOWORD(wParam), HIWORD(wParam), *activePopup);
		return res;
	}
	case WM_MENUSELECT:
		onMenuSelect(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HMENU>(lParam));
		break;
	case WM_NOTIFY:
		onNotify(static_cast<UINT>(wParam), *reinterpret_cast<NMHDR*>(lParam));
		break;
	case WM_QUERYENDSESSION:
		return onClose();
	case WM_SETCURSOR:
		if(onSetCursor(reinterpret_cast<HWND>(wParam),
				static_cast<UINT>(LOWORD(lParam)), static_cast<UINT>(HIWORD(lParam))))
			return false;
		break;
	case WM_SETFOCUS:
		// m_iActiveView 悤ƂĂr[w\
//		if(m_buffers.GetCount() != 0 && m_buffers.GetActiveDocumentIndex() != -1
//				&& reinterpret_cast<HWND>(wParam) != m_documents.GetActiveDocument()->GetWindow())
//			::SendMessage(m_documents.GetActiveDocument()->GetWindow(), message, wParam, lParam);
		buffers_->getEditorWindow().setFocus();
		return 0L;
	case WM_SETTINGCHANGE:
		onSettingChange(static_cast<UINT>(wParam), reinterpret_cast<wchar_t*>(lParam));
		break;
	case WM_SIZE:
		onSize(static_cast<UINT>(wParam), LOWORD(lParam), HIWORD(lParam));
		break;
	case WM_TIMER:
		onTimer(static_cast<UINT>(wParam));
		break;
//	case MYWM_CALLOVERTHREAD:
//		reinterpret_cast<ICallable*>(lParam)->call();
//		return true;
//	case MYWM_ENDSCRIPTMACRO: {
//		AlphaView& view = editorWindow_.getActivePane().getVisibleView();
//		view.invalidateRect(0);
//		view.enableWindow(true);	// [ (ScriptMacroManager.cpp  _InputBlocker Q)
////	view.setFocus();
//		editorWindow_.setFocus();
//		}
//		return true;
	case MYWM_EVENTHANDLER:
		eventHandlerScript_->invoke(
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->first,
			*reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->second);
		return true;
	}
	return ::DefWindowProc(window, message, wParam, lParam);
}

/**
 *	I[g[VpC^[tFCXIuWFNgԂ
 *	@param application [out] AvP[V
 */
HRESULT AlphaApp::getAutomation(Alpha::Ambient::Application*& application) const {
	assertValid();

	AlphaApp& self = *const_cast<AlphaApp*>(this);
	if(automation_ == 0) {
		self.automation_ = new Alpha::Ambient::Application(self);
		if(automation_ == 0)
			return E_OUTOFMEMORY;
		self.automation_->AddRef();
	}
	(application = automation_)->AddRef();
	return S_OK;
}

/**
 *	R[hy[W̖OԂBR[hy[WȂ null
 *	@param cp R[hy[W
 */
const wstring* AlphaApp::getCodePageName(CodePage cp) const {
	map<CodePage, wstring>::const_iterator it = codePageNameTable_.find(cp);
	return (it != codePageNameTable_.end()) ? &it->second : 0;
}

/**
 *	R}h̃j[LvVԂ
 *	@param id R}h ID
 */
const wchar_t* AlphaApp::getMenuLabel(CommandID id) const {
	static wchar_t buffer[MAX_PATH + 8];

	// [}N]
	if(id >= CMD_EDIT_PLUGINLIST_START && id < CMD_EDIT_PLUGINLIST_END) {
		if(scriptMacroManager_->getCount() != 0) {
			wcscpy(buffer, scriptMacroManager_->getName(id - CMD_EDIT_PLUGINLIST_START).c_str());
			wcscat(buffer, L"\t");
			wcscat(buffer, keyboardMap_.getKeyString(id, useShortKeyNames_).c_str());
		} else
			wcscpy(buffer, loadString(MSG_FAILED_TO_LOAD).c_str());
		return buffer;
	}
	
	else if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {
		const MRU& file = mruManager_->getFileInfoAt(id - CMD_FILE_MRULIST_START);
		swprintf(buffer, L"&%X  %s", id - CMD_FILE_MRULIST_START, file.fileName.c_str());
		return buffer;
	}
	
	else if(id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END) {
		assert(static_cast<size_t>(id - CMD_VIEW_BUFFERLIST_START) < buffers_->getCount());
		if(id - CMD_VIEW_BUFFERLIST_START < 0x10)
			swprintf(buffer, L"&%X  %s", id - CMD_VIEW_BUFFERLIST_START,
				buffers_->getAt(id - CMD_VIEW_BUFFERLIST_START).getFileName());
		else
			wcscpy(buffer, buffers_->getAt(id - CMD_VIEW_BUFFERLIST_START).getFileName());
		return buffer;
	}

	loadString(id, buffer, countof(buffer));
	wchar_t* const delimiter = wcschr(buffer, L'\n');
	if(delimiter != 0)
		*delimiter = 0;
	wcscat(buffer, L"\t");
	wcscat(buffer, keyboardMap_.getKeyString(id, useShortKeyNames_).c_str());
	return buffer;
}

/**
 *	XNvgt@CɑΉtĂ錾GW CLSID Ԃ
 *	@param fileName	XNvgt@C
 *	@param clsid	[out] GW CLSIDBȂꍇ CLSID_NULL
 */
void AlphaApp::getScriptLanguageByFileName(const wchar_t* fileName, CLSID& clsid) const {
	assert(fileName != 0);
	clsid = CLSID_NULL;

	static map<wstring, CLSID> registeredEngines;
	static const CATID CATID_ActiveScript = {
							0xf0b7a1a1, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	static const CATID CATID_ActiveScriptParse = {
							0xf0b7a1a2, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	const wchar_t* extension = ::PathFindExtensionW(fileName);

	if(*extension == 0)
		return;
	++extension;
	if(registeredEngines.empty()) {
		// R|[lgJeSXNvgGW񋓂AINI gqE
		ComPtr<ICatInformation> catInfo;

		if(SUCCEEDED(catInfo.createInstance(CLSID_StdComponentCategoriesMgr))) {
			ComPtr<IEnumCLSID> clsidEnumerator;

			if(SUCCEEDED(catInfo->EnumClassesOfCategories(
					1, const_cast<CATID*>(&CATID_ActiveScript),
					1, const_cast<CATID*>(&CATID_ActiveScriptParse), &clsidEnumerator))) {
				CLSID clsid;
				OLECHAR* progID;

				for(clsidEnumerator->Reset(); clsidEnumerator->Next(1, &clsid, 0) == S_OK; ) {
					if(SUCCEEDED(::ProgIDFromCLSID(clsid, &progID))) {
						set<wstring> extensions;

						if(wchar_t* firstPeriod = wcschr(progID, L'.'))	// ProgID ꖼɕϊ
							*firstPeriod = 0;
						const_cast<AlphaApp*>(this)->readProfileSet(INI_SECTION_SCRIPTENGINES, progID, extensions);
						for(set<wstring>::const_iterator it = extensions.begin(); it != extensions.end(); ++it)
							registeredEngines.insert(make_pair(*it, clsid));
						::CoTaskMemFree(progID);
					}
				}
			}
		}
	}
	map<wstring, CLSID>::const_iterator	it = registeredEngines.find(extension);
	if(it != registeredEngines.end())
		clsid = it->second;
}

/**
 *	L[gݍ킹R}hɕϊĎs
 *	@param key			zL[
 *	@param modifiers	CL[
 *	@return				R}hɕϊłꍇ true
 */
bool AlphaApp::handleKeyDown(VirtualKey key, KeyModifier modifiers) {
	if(key == VK_MENU && modifiers == 0) {	// [Alt] ̂ -> j[ANeBuɂ
		getMainWindow().sendMessage(WM_INITMENU, reinterpret_cast<WPARAM>(menu_->getSafeHmenu()));
		return true;
	} else if(key == VK_CONTROL || key == VK_MENU || key == VK_SHIFT)	// CL[PƂŉꂽ -> 
		return false;

	if(twoStroke1stKey_ == VK_NULL) {	// 1Xg[N
		Command* command = keyboardMap_.getCommand(KeyCombination(key, modifiers));
		if(command == 0)
			return false;
		else if(command->isBuiltIn() && command->getID() == CMD_SPECIAL_WAITFOR2NDKEYS) {
			twoStroke1stKey_ = key;
			twoStroke1stModifiers_ = modifiers;
			const wstring s = loadString(MSG_WAITING_FOR_2ND_KEYS,
				MARGS % KeyboardMap::getStrokeString(KeyCombination(key, modifiers), useShortKeyNames_));
			setStatusText(s.c_str());
		} else
			command->execute();
	} else {	// 2Xg[N
		Command* command = keyboardMap_.getCommand(
			KeyCombination(twoStroke1stKey_, twoStroke1stModifiers_), KeyCombination(key, modifiers));
		if(command != 0) {
			setStatusText(0);
			command->execute();
		} else {
			const wstring s = loadString(MSG_ILLEGAL_2STROKE_COMBINATION,
				MARGS % KeyboardMap::getStrokeString(
					KeyCombination(twoStroke1stKey_, twoStroke1stModifiers_),
					KeyCombination(key, modifiers), useShortKeyNames_));
			::MessageBeep(MB_OK);
			setStatusText(s.c_str());
		}
		twoStroke1stKey_ = VK_NULL;
	}
	return true;
}

/// @see WinApp::initInstance
bool AlphaApp::initInstance(int showCommand) {
	assertValid();

	// EBhENX̓o^
	AutoZeroCB<WNDCLASSEXW> windowClass;
	windowClass.style			= CS_DBLCLKS/* | CS_DROPSHADOW*/;
	windowClass.lpfnWndProc		= AlphaApp::appWndProc;
	windowClass.cbClsExtra		= 0;
	windowClass.cbWndExtra		= 0;
	windowClass.hInstance		= getHandle();
	windowClass.hIcon			= loadIcon(IDR_ICONS);
	windowClass.hIconSm			= loadIcon(IDR_ICONS);
	windowClass.hCursor			= loadStandardCursor(IDC_ARROW);
	windowClass.hbrBackground	= BrushHandleOrColor(COLOR_3DFACE).brush_;
	windowClass.lpszClassName	= IDS_APPNAME;
	windowClass.lpszMenuName	= MAKEINTRESOURCE(IDR_MENU);
	if(!toBoolean(::RegisterClassEx(&windowClass)))
		return false;

	static Controls::Window applicationWindow;

	// R[hy[W̓ǂݍ
	if(HRSRC resource = findResource(IDR_CODEPAGE_NAME_TABLE, RT_RCDATA)) {
		if(HGLOBAL buffer = loadResource(resource)) {
			if(const wchar_t* p = static_cast<const wchar_t*>(::LockResource(buffer))) {
				const wchar_t* const end = p + sizeofResource(resource) / sizeof(wchar_t);
				if(*p == 0xFEFF)	// UTF-16 BOM
					++p;
				while(true) {
					const wchar_t* const tab = find(p, end, L'\t');
					if(tab == end)
						break;
					const wchar_t* const lf = find(tab + 1, end, L'\n');
					if(lf == end)
						break;
					codePageNameTable_.insert(make_pair(wcstoul(p, 0, 10), wstring(tab + 1, lf)));
					p = lf + 1;
				}
//				::UnlockResource(buffer);
			}
			::FreeResource(buffer);
		}
	}

	// ̏ǂݍ
	try {
		Ascension::LineBreak lineBreak =
			static_cast<Ascension::LineBreak>(readIntegerProfile(L"File", L"defaultBreakType", LB_CRLF));
		if(lineBreak == LB_AUTO)
			lineBreak = LB_CRLF;
		EditDoc::setDefaultCode(readIntegerProfile(L"File", L"defaultCodePage", ::GetACP()), lineBreak);
	} catch(invalid_argument&) {
		// TODO: ݒ肪ԈĂ邱Ƃ[Uɒʒm
	}

	// gbvxEBhE
	if(!applicationWindow.create(IDS_APPNAME, reinterpret_cast<HWND>(getHandle()),
			Controls::DefaultWindowRect(), 0, /*WS_VISIBLE |*/ WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_OVERLAPPEDWINDOW))
		return false;
	setMainWindow(applicationWindow);

	// o[̍쐬
	REBARINFO rbi = {sizeof(REBARINFO), 0, 0};
	rebar_.create(applicationWindow, Controls::DefaultWindowRect(), 0, 0,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | RBS_BANDBORDERS | RBS_VARHEIGHT | CCS_NODIVIDER,
		WS_EX_TOOLWINDOW);
	rebar_.setBarInfo(rbi);

	// obt@Xg
	buffers_.reset(new BufferList(*this));

	// c[o[̍쐬
	setupToolbar();
	buffers_->createBar(rebar_);

	// ʐݒ̓ǂݍ
	loadINISettings();

	// XNvgɂݒ
	wchar_t scriptName[MAX_PATH];
	wchar_t* fileName = 0;
	ComPtr<Alpha::Ambient::Application> application;

	getAutomation(*&application);
	wcscpy(scriptName, getModuleFileName());
	fileName = ::PathFindFileNameW(scriptName);
	wcscpy(fileName, IDS_MACRO_DIRECTORY_NAME IDS_EVENTSCRIPTFILENAME);
	eventHandlerScript_ = new EventHandlerScript(getMainWindow(), *this);
	eventHandlerScript_->loadScript(scriptName);

	// MRU Xg̍쐬
	mruManager_ = new MRUManager(readIntegerProfile(L"File", L"mruLimit", 8), CMD_FILE_MRULIST_START, true);
	wchar_t keyName[30];
	stack<MRU> files;
	for(uint i = 0; ; ++i) {
		MRU file;
		swprintf(keyName, L"strPath(%u)", i);
		file.fileName = readStringProfile(L"MRU", keyName);
		if(file.fileName.empty())
			break;
		swprintf(keyName, L"nCodePage(%u)", i);
		file.codePage = readIntegerProfile(L"MRU", keyName, CPEX_AUTODETECT_USERLANG);
		files.push(file);
	}
	while(!files.empty()) {
		mruManager_->add(files.top().fileName, files.top().codePage);
		files.pop();
	}

	// macros.xml ̃[h
	reloadScriptMacros();

	// ACR̗p
	temporaryMacroDefiningIcon_ = static_cast<HICON>(loadImage(IDR_ICON_TEMPMACRODEFINING, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));
	temporaryMacroPausingIcon_ = static_cast<HICON>(loadImage(IDR_ICON_TEMPMACROPAUSING, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));
	narrowingIcon_ = static_cast<HICON>(loadImage(IDR_ICON_NARROWING, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));

	// Xe[^Xo[̍쐬
	statusBar_.create(applicationWindow, Controls::DefaultWindowRect(), 0, IDC_STATUSBAR,
		WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE | CCS_BOTTOM | CCS_NODIVIDER | SBARS_SIZEGRIP | SBT_TOOLTIPS);
//	statusBar_.setMinHeight(4);

	// ̑̏
	applicationWindow.dragAcceptFiles(true);
	applicationWindow.setTimer(ID_TIMER_QUERYCOMMAND, 200, 0);
	applicationWindow.setWindowPos(0, 0, 0, 760, 560, SWP_NOMOVE | SWP_NOZORDER);
	applicationWindow.centerWindow();

	// OnApplicationInitialized Cxg
	AutoZero<DISPPARAMS> params;
	eventHandlerScript_->invoke(OLESTR("OnApplicationInitialized"), params);

	// ̃r[̍쐬
	buffers_->addNew();

	setupMenus();
	if(!toBoolean(readIntegerProfile(L"View", L"visibleToolbar", true)))
		rebar_.showBand(rebar_.idToIndex(IDC_TOOLBAR), false);
	if(!toBoolean(readIntegerProfile(L"View", L"visibleStatusBar", true)))
		statusBar_.showWindow(SW_HIDE);
	if(!toBoolean(readIntegerProfile(L"View", L"visibleBufferBar", true)))
		rebar_.showBand(rebar_.idToIndex(IDC_BUFFERBAR), false);
	applicationWindow.showWindow(showCommand);

	// R}hC^ꂽt@CJ
	WCHAR cd[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, cd);
	parseCommandLine(cd, ::GetCommandLineW());

	// ...
	setStatusText(0);

	// AEgvbgEBhE̍쐬
//	outputWindow.create(getMainWindow());
//	outputWindow.writeLine(OTT_GENERAL, IDS_APPFULLVERSION);

	// c[_CAO̍쐬
	searchDialog_->doModeless(applicationWindow, false);
	pushModelessDialog(*searchDialog_);
	if(toBoolean(readIntegerProfile(L"View", L"applyMainFontToSomeControls", 1))) {
		searchDialog_->sendDlgItemMessage(IDC_COMBO_FINDWHAT, WM_SETFONT, reinterpret_cast<WPARAM>(editorFont_), true);
		searchDialog_->sendDlgItemMessage(IDC_COMBO_REPLACEWITH, WM_SETFONT, reinterpret_cast<WPARAM>(editorFont_), true);
	}

	applicationWindow.setFocus();
	return true;
}

/// INI t@Cݒǂݍ
void AlphaApp::loadINISettings() {
	assertValid();

	// \Ɋւݒ
	AutoZero<LOGFONTW> lf;
	if(!readStructureProfile(L"View", L"oFont.pLogfont", lf)) {
		lf.lfCharSet = ANSI_CHARSET;
		lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
		lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		lf.lfQuality = DEFAULT_QUALITY;
		lf.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
		wcscpy(lf.lfFaceName, L"Terminal");
	}
	setFont(lf);

	// Migemo DLL pX
	basic_string<WCHAR> migemoPath = readStringProfile(L"Find", L"migemoRuntimePath", L"");
	if(!migemoPath.empty()) {
		s2b(migemoPath);
		EditView::setMigemoPath(migemoPath.c_str(), true);
	}

	// Migemo  pX
	migemoPath = readStringProfile(L"Find", L"migemoDictionaryPath", L"");
	if(!migemoPath.empty()) {
		s2b(migemoPath);
		EditView::setMigemoPath(migemoPath.c_str(), false);
	}

	// ̗
	wchar_t	keyName[30];
	wstring	value;
	list<wstring> findWhats, replacesWiths;
	for(ushort i = 0; i < 16; ++i) {
		swprintf(keyName, L"strFindWhat(%u)", i);
		value = readStringProfile(L"Find", keyName);
		if(value.empty())
			break;
		findWhats.push_back(value);
	}
	for(ushort i = 0; i < 16; ++i) {
		swprintf(keyName, L"strReplaceWith(%u)", i);
		value = readStringProfile(L"Find", keyName);
		if(value.empty())
			break;
		replacesWiths.push_back(value);
	}
	searchDialog_->clearHistory(false);
	searchDialog_->clearHistory(true);
	searchDialog_->setHistory(findWhats, replacesWiths);

	// ̑
	useShortKeyNames_ = toBoolean(readIntegerProfile(L"Edit", L"useShortKeyNames", 0));
	showMessageBoxOnFind_ = toBoolean(readIntegerProfile(L"Find", L"showMessageBox", 1));
	initializeFindTextFromEditor_ = toBoolean(readIntegerProfile(L"Find", L"initializeFromEditor", 1));
}

/**
 *	L[ () 蓖
 *	@param schemeName	gpL[{[h}bvXL[̖OB
 *	󕶎w肷ƃAvP[VɌѕtĂL[蓖ăIuWFNgANZ[^e[uč\z
 */
void AlphaApp::loadKeyBinds(const wstring& schemeName) {
	assertValid();

	if(!schemeName.empty()) {
		wchar_t pathName[MAX_PATH];
		::GetModuleFileNameW(0, pathName, MAX_PATH);
		wcscpy(::PathFindFileNameW(pathName), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
		if(wcslen(pathName) + schemeName.length() + 4 >= MAX_PATH)
			return;
		wcscat(pathName, schemeName.c_str());
		wcscat(pathName, L".akm");
		keyboardMap_.load(pathName);
	}

	// j[̍č\z
	if(menu_ != 0)
		setupMenus();
}

/**
 *	bZ[We[u̕bZ[W{bNXɕ\
 *	@param id	bZ[Wʎq
 *	@param type	_CAÕ^Cv (::MessageBox Ɠ)
 *	@param args	bZ[Ẅ
 *	@return		[U̕ԓ (::MessageBox Ɠ)
 */
int AlphaApp::messageBox(DWORD id, UINT type, MessageArguments& args /* = MessageArguments() */) {
	assertValid();
	return getMainWindow().messageBox(loadString(id, args).c_str(), IDS_APPNAME, type);
}

/**
 *	R}hC͂ĎsBȈ͖
 *	@param currentDirectory	JgfBNg
 *	@param commandLine		R}hC
 *	@see					AlphaApp::onCopyData, WinMain
 */
void AlphaApp::parseCommandLine(const WCHAR* currentDirectory, const WCHAR* commandLine) {
	assertValid();

	// CommandLineToArgvW  argv[0] ɑ΂dp̈ɖ肪悤...
	int argc;
	WCHAR** argv = ::CommandLineToArgvW(commandLine, &argc);
	WCHAR canonical[MAX_PATH];
	for(int i = 1; i < argc; ++i) {
		if(toBoolean(::PathIsRelativeW(argv[i])))
			::PathCombineW(canonical, currentDirectory, argv[i]);
		else
			wcscpy(canonical, argv[i]);
		if(toBoolean(::PathIsDirectoryW(canonical)))
			buffers_->openDialog(canonical);
		else
			buffers_->open(canonical);
	}
	::LocalFree(argv);
}

/// @see Application::preTranslateMessage
bool AlphaApp::preTranslateMessage(const MSG& msg) {
	// R}hɊ蓖ĂĂL[gݍ킹ŕߑ
	if(msg.hwnd == buffers_->getActiveView()) {
		if(msg.message == WM_KEYDOWN || msg.message == WM_SYSKEYDOWN) {	// WM_CHAR sȂ悤ɂ
			KeyModifier modifiers = 0;
			if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))
				modifiers |= KM_CTRL;
			if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))
				modifiers |= KM_SHIFT;
			if(msg.message == WM_SYSKEYDOWN || toBoolean(::GetKeyState(VK_MENU) & 0x8000))
				modifiers |= KM_ALT;
			return handleKeyDown(static_cast<VirtualKey>(msg.wParam), modifiers);
		} else if(msg.message == WM_SYSCHAR) {
			// L[gݍ킹L[{[hXL[ɓo^Ă邩ׂB
			// o^ĂΊ̏ (j[̃ANeBx[V) WQ
			const VirtualKey key = LOBYTE(::VkKeyScanExW(static_cast<WCHAR>(msg.wParam), ::GetKeyboardLayout(0)));
			KeyModifier modifiers = KM_ALT;
			if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))	modifiers |= KM_CTRL;
			if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))		modifiers |= KM_SHIFT;

			if(twoStroke1stKey_ == VK_NULL)
				return keyboardMap_.getCommand(KeyCombination(key, modifiers)) != 0;
			else
				return keyboardMap_.getCommand(
					KeyCombination(twoStroke1stKey_, twoStroke1stModifiers_), KeyCombination(key, modifiers)) != 0;
		}
	}
	return false;
}

/**
 *	INI 當񃊃Xgǂݍ
 *	@param section		ZNV
 *	@param key			L[
 *	@param items		[out] Xg
 *	@param defaultValue	[in] ݒ肪ȂƂɎgp镶
 */
void AlphaApp::readProfileList(const wchar_t* section,
		const wchar_t* key, std::list<std::wstring>& items, const wchar_t* defaultValue /* = 0 */) {
	const std::wstring s = readStringProfile(section, key, defaultValue);

	items.clear();
	if(s.empty())
		return;
	std::wistringstream ss(s);
	std::wstring buffer;
	while(ss >> buffer)
		items.push_back(buffer);
}


/**
 *	INI 當̏Wǂݍ
 *	@param section		ZNV
 *	@param key			L[
 *	@param items		[out] W
 *	@param defaultValue	[in] ݒ肪ȂƂɎgp镶
 */
void AlphaApp::readProfileSet(const wchar_t* section,
		const wchar_t* key, std::set<std::wstring>& items, const wchar_t* defaultValue /* = 0 */) {
	const std::wstring s = readStringProfile(section, key, defaultValue);

	items.clear();
	if(s.empty())
		return;
	std::wistringstream	ss(s);
	std::wstring buffer;
	while(ss >> buffer)
		items.insert(buffer);
}

/// }N () [h
void AlphaApp::reloadScriptMacros() {
	wchar_t macroPath[MAX_PATH];

	wcscpy(macroPath, getModuleFileName());
	wcscpy(::PathFindFileNameW(macroPath), IDS_MACRO_DIRECTORY_NAME L"macros.xml");
	try {
		scriptMacroManager_->load(macroPath);
	} catch(ScriptMacroManager::XMLParseFailureException& /* e */) {
		// }l[W_CAOo...
	}
}

/**
 *	@brief ݈ʒuȍ~̌SĒu
 *
 *	̃\bh͒u_CAO\ł@\
 */
void AlphaApp::replaceAll() {
	AlphaView& activeView = buffers_->getActiveView();
	FindAllCommand command(activeView, FindAllCommand::REPLACE,
						toBoolean(searchDialog_->isDlgButtonChecked(IDC_RADIO_SELECTION)));

	searchDialog_->updateOptions();
	activeView.getTextSearcher().setSearchText(searchDialog_->getFindText());
	activeView.getTextSearcher().setReplaceText(searchDialog_->getReplaceText());
	if(const ulong replacedCount = command.execute()) {
		if(showMessageBoxOnFind_)
			messageBox(MSG_REPLACE_SUCCEEDED, MB_ICONINFORMATION, MARGS % replacedCount);
		// ɒǉ
		searchDialog_->addToHistory(searchDialog_->getFindText(), false);
		searchDialog_->addToHistory(searchDialog_->getReplaceText(), true);
	} else if(showMessageBoxOnFind_)
		showRegexSearchError(command.getLastResult());

	if(searchDialog_->isWindow()) {
		if(searchDialog_->isDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [ׂĒu_CAO]
			getMainWindow().sendMessage(WM_COMMAND, CMD_SEARCH_FIND);
		else
			::SetFocus(searchDialog_->getDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/**
 *	@brief ݂̑I͈͂łΒus
 *
 *	uA͑I͈͂Ŗꍇ͎̌IԂɂB
 *	̃\bh͒u_CAO\ł@\
 */
void AlphaApp::replaceAndSearchNext() {
	AlphaView& activeView = buffers_->getActiveView();

	searchDialog_->updateOptions();
	activeView.getTextSearcher().setSearchText(searchDialog_->getFindText());
	activeView.getTextSearcher().setReplaceText(searchDialog_->getReplaceText());

	FindNextCommand command(activeView, true, !searchDialog_->isDlgButtonChecked(IDC_CHK_SHIFT));

	if(command.execute() == 0)	// u
		searchDialog_->addToHistory(searchDialog_->getReplaceText(), true);
	else if(showMessageBoxOnFind_)
		showRegexSearchError(command.getLastResult());

	if(searchDialog_->isWindowVisible()) {
//		if(searchDialog_.isDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
//			getMainWindow().sendMessage(WM_COMMAND, CMD_SEARCH_FIND);
//		else
			::SetFocus(searchDialog_->getDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/// INI t@Cɐݒۑ
void AlphaApp::saveINISettings() {
	wchar_t keyName[30];
	unsigned short i;

	// o[̉̕ۑ
	AutoZero<REBARBANDINFOW> rbbi;
	rbbi.fMask = RBBIM_STYLE;
	rebar_.getBandInfo(rebar_.idToIndex(IDC_TOOLBAR), rbbi);
	writeIntegerProfile(L"View", L"visibleToolbar", toBoolean(rbbi.fStyle & RBBS_HIDDEN) ? 0 : 1);
	rebar_.getBandInfo(rebar_.idToIndex(IDC_BUFFERBAR), rbbi);
	writeIntegerProfile(L"View", L"visibleBufferBar", toBoolean(rbbi.fStyle & RBBS_HIDDEN) ? 0 : 1);
	writeIntegerProfile(L"View", L"visibleStatusBar", statusBar_.isWindowVisible() ? 1 : 0);

	// MRU Xg̕ۑ
	for(i = 0; ; ++i) {
		swprintf(keyName, L"strPath(%u)", i);
		if(i == mruManager_->getCount()) {
			writeStringProfile(L"MRU", keyName, L"");	// Xg̏I[\
			break;
		} else {
			const MRU& file = mruManager_->getFileInfoAt(i);
			writeStringProfile(L"MRU", keyName, file.fileName.c_str());
			swprintf(keyName, L"nCodePage(%u)", i);
			writeIntegerProfile(L"MRU", keyName, file.codePage);
		}
	}

	// 񗚗̕ۑ
	list<wstring> findWhats, replaceWiths;
	list<wstring>::const_iterator it;
	searchDialog_->getHistory(findWhats, replaceWiths);
	for(i = 0, it = findWhats.begin(); it != findWhats.end(); ++i, ++it) {
		swprintf(keyName, L"strFindWhat(%u)", i);
		writeStringProfile(L"Find", keyName, it->c_str());
	}
	swprintf(keyName, L"strFindWhat(%u)", i);
	writeStringProfile(L"Find", keyName, L"");
	for(i = 0, it = replaceWiths.begin(); it != replaceWiths.end(); ++i, ++it) {
		swprintf(keyName, L"strReplaceWith(%u)", i);
		writeStringProfile(L"Find", keyName, it->c_str());
	}
	swprintf(keyName, L"strReplaceWith(%u)", i);
	writeStringProfile(L"Find", keyName, L"");
}

/// [ׂă}[N]
void AlphaApp::searchAndBookmarkAll() {
	AlphaView& activeView = buffers_->getActiveView();
	FindAllCommand command(activeView, FindAllCommand::BOOKMARK,
						toBoolean(searchDialog_->isDlgButtonChecked(IDC_RADIO_SELECTION)));

	searchDialog_->updateOptions();
	activeView.getTextSearcher().setSearchText(searchDialog_->getFindText());
	if(const ulong c = command.execute())
		searchDialog_->addToHistory(searchDialog_->getFindText(), false);
	else if(showMessageBoxOnFind_ && command.getLastResult().isFatalError())
		showRegexSearchError(command.getLastResult());
}

/**
 *	@brief ݂̌ɏ]ĎA͑O̕
 *
 *	̃\bh̓qbgIԂɂB
 *	܂A_CAO\ł@\
 *	@param forward			O
 *	@param messageOnFailure	sƂɃvvg\
 *	@return					sƂ false
 */
bool AlphaApp::searchNext(bool forward, bool messageOnFailure) {
	AlphaView& activeView = buffers_->getActiveView();
	FindNextCommand command(activeView, false, forward);

	searchDialog_->updateOptions();
	activeView.getTextSearcher().setSearchText(searchDialog_->getFindText());

	const bool matched = command.execute() == 0;
	if(matched) {
		if(searchDialog_->isWindow())
			searchDialog_->checkDlg2StateButton(IDC_CHK_SHIFT, !forward);
		searchDialog_->addToHistory(searchDialog_->getFindText(), false);
	} else if(messageOnFailure && showMessageBoxOnFind_)
		showRegexSearchError(command.getLastResult());
	if(searchDialog_->isWindowVisible()) {
		if(searchDialog_->isDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
			getMainWindow().sendMessage(WM_COMMAND, CMD_SEARCH_FIND);
		else
			::SetFocus(searchDialog_->getDlgItem(IDC_COMBO_FINDWHAT));
	}
	return matched;
}

/// SẴGfB^ƈꕔ̃Rg[ɐVtHgݒ
void AlphaApp::setFont(const LOGFONTW& font) {
	LOGFONTW lf = font;

	lf.lfWeight = FW_NORMAL;
	::DeleteObject(editorFont_);
	editorFont_ = ::CreateFontIndirectW(&lf);

	// SẴr[̃tHgXV
	AlphaView* view = 0;
	for(size_t i = 0; i < buffers_->getCount(); ++i)
		buffers_->getAt(i).getView(0).getLayoutSetter().setFont(lf);

	// ꕔ̃Rg[ɂݒ
	if(toBoolean(readIntegerProfile(L"View", L"applyMainFontToSomeControls", 1))) {
		if(bookmarkDialog_.get() != 0 && bookmarkDialog_->isWindow())
			bookmarkDialog_->sendDlgItemMessage(IDC_LIST_BOOKMARKS, WM_SETFONT, reinterpret_cast<WPARAM>(editorFont_), true);
		if(searchDialog_.get() != 0 && searchDialog_->isWindow()) {
			searchDialog_->sendDlgItemMessage(IDC_COMBO_FINDWHAT, WM_SETFONT, reinterpret_cast<WPARAM>(editorFont_), true);
			searchDialog_->sendDlgItemMessage(IDC_COMBO_REPLACEWITH, WM_SETFONT, reinterpret_cast<WPARAM>(editorFont_), true);
		}
	}

	// INI t@Cɕۑ
	writeStructureProfile(L"View", L"oFont.pLogfont", lf);

	//  <-> ϕŕ\LςKv
	updateStatusBar(SBP_POSITION);
}

/// j[̏
void AlphaApp::setupMenus() {
	assertValid();

	if(menu_ != 0) {
		while(true) {
			const UINT c = menu_->getItemCount();
			if(c == 0 || c == -1)
				break;
			menu_->removeMenuItem<Controls::Menu::BY_POSITION>(0);
		}
		delete menu_;
	}
	menu_ = new Controls::Menu(getMainWindow().getMenu());
	menu_->deleteMenuItem<Controls::Menu::BY_POSITION>(0);	// _~[ (Ӗ̂͏̂)

	const Controls::Menu::SeparatorItem sep(MFT_OWNERDRAW);

	// j[o[
	*menu_ << Controls::Menu::StringItem(CMD_FILE_TOP, loadString(CMD_FILE_TOP).c_str())
		<< Controls::Menu::StringItem(CMD_EDIT_TOP, loadString(CMD_EDIT_TOP).c_str())
		<< Controls::Menu::StringItem(CMD_SEARCH_TOP, loadString(CMD_SEARCH_TOP).c_str())
		<< Controls::Menu::StringItem(CMD_VIEW_TOP, loadString(CMD_VIEW_TOP).c_str())
		<< Controls::Menu::StringItem(CMD_MACRO_TOP, loadString(CMD_MACRO_TOP).c_str())
		<< Controls::Menu::StringItem(CMD_TOOL_TOP, loadString(CMD_TOOL_TOP).c_str())
		<< Controls::Menu::StringItem(CMD_HELP_TOP, loadString(CMD_HELP_TOP).c_str());

	// [t@C]
	Controls::Menu* fileMenu = new Controls::Menu();
	*fileMenu << Controls::Menu::OwnerDrawnItem(CMD_FILE_NEW)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_NEWWITHFORMAT) << sep
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_OPEN) << Controls::Menu::OwnerDrawnItem(CMD_FILE_REOPEN)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_REOPENWITHCODEPAGE) << Controls::Menu::OwnerDrawnItem(CMD_FILE_MRU) << sep
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_CLOSE) << Controls::Menu::OwnerDrawnItem(CMD_FILE_CLOSEALL)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_CLOSEOTHERS) << sep
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_SAVE) << Controls::Menu::OwnerDrawnItem(CMD_FILE_SAVEAS)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_SAVEALL) << sep /*<< Controls::Menu::OwnerDrawnItem(CMD_FILE_PROPERTY)*/
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_OPERATE) << sep << Controls::Menu::OwnerDrawnItem(CMD_FILE_SENDMAIL)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_FILE_EXIT);
	fileMenu->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_FILE_MRU, mruManager_->getPopupMenu(), false);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_FILE_TOP, *fileMenu, true);

	// [t@C]-[t@C]
	delete fileOpeMenu_;
	fileOpeMenu_ = new Controls::Menu();
	*fileOpeMenu_ << Controls::Menu::OwnerDrawnItem(CMD_FILE_RENAME)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_COPY) << Controls::Menu::OwnerDrawnItem(CMD_FILE_MOVE)
		<< Controls::Menu::OwnerDrawnItem(CMD_FILE_DELETE);
	fileMenu->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_FILE_OPERATE, *fileOpeMenu_, false);

	// [ҏW]
	Controls::Menu* editMenu = new Controls::Menu();
	*editMenu << Controls::Menu::OwnerDrawnItem(CMD_EDIT_UNDO)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_REDO) << Controls::Menu::SeparatorItem(MFT_OWNERDRAW)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_CUT) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_COPY)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_PASTE) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_PASTEFROMCLIPBOARDRING)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_DELETE) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_SELECTALL)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_EDIT_ADVANCED)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_OPENCANDIDATEWINDOW) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_SHOWABBREVIATIONDLG);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_EDIT_TOP, *editMenu, true);

	// [ҏW]-[xȑ]
	Controls::Menu* advEditMenu = new Controls::Menu();
	*advEditMenu << Controls::Menu::OwnerDrawnItem(CMD_EDIT_CHARTOCODEPOINT)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_CODEPOINTTOCHAR) << sep
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_NARROWTOSELECTION) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_WIDEN)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTGRAVE)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTACUTE) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTCIRCUMFLEX)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTTILDE) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTMACRON)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTBREVE) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTDIAERESIS)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTCARON) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTCEDILLA)
		<< Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTSUPER) << Controls::Menu::OwnerDrawnItem(CMD_EDIT_MAKENEXTSUB);
	editMenu->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_EDIT_ADVANCED, *advEditMenu, true);

	// []
	Controls::Menu* findMenu = new Controls::Menu();
	*findMenu << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_FIND)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_FINDNEXT) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_FINDPREV)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_INCREMENTALSEARCH) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_INCREMENTALSEARCHR)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_INCREMENTALSEARCHRF) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_INCREMENTALSEARCHRR)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_INCREMENTALSEARCHMF) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_INCREMENTALSEARCHMR)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_REVOKEMARK) << sep << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_GOTOLINE)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_TOGGLEBOOKMARK)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_NEXTBOOKMARK) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_PREVBOOKMARK)
		<< Controls::Menu::OwnerDrawnItem(CMD_SEARCH_CLEARBOOKMARKS) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_MANAGEBOOKMARKS)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_GOTOMATCHBRACKET) << Controls::Menu::OwnerDrawnItem(CMD_SEARCH_EXTENDTOMATCHBRACKET);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_SEARCH_TOP, *findMenu, true);

	// [\]
	Controls::Menu* viewMenu = new Controls::Menu();
	*viewMenu << Controls::Menu::OwnerDrawnItem(CMD_VIEW_TOOLBAR)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_STATUSBAR) << Controls::Menu::OwnerDrawnItem(CMD_VIEW_BUFFERBAR)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_VIEW_BUFFERS) << Controls::Menu::OwnerDrawnItem(CMD_VIEW_NEXTBUFFER)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_PREVBUFFER) << Controls::Menu::SeparatorItem(MFT_OWNERDRAW)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_SPLITNS) << Controls::Menu::OwnerDrawnItem(CMD_VIEW_SPLITWE)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_UNSPLITOTHERS) << Controls::Menu::OwnerDrawnItem(CMD_VIEW_UNSPLITACTIVE)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_NEXTPANE) << Controls::Menu::OwnerDrawnItem(CMD_VIEW_PREVPANE)
		<< sep << Controls::Menu::OwnerDrawnItem(CMD_VIEW_WRAPNO)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_WRAPBYSPECIFIEDWIDTH)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_WRAPBYWINDOWWIDTH)
		<< Controls::Menu::SeparatorItem(MFT_OWNERDRAW) << Controls::Menu::OwnerDrawnItem(CMD_VIEW_TOPMOSTALWAYS)
		<< Controls::Menu::OwnerDrawnItem(CMD_VIEW_REFRESH);
	viewMenu->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_VIEW_BUFFERS, buffers_->getListMenu(), false);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_VIEW_TOP, *viewMenu, true);

	// [}N]
	Controls::Menu* macroMenu = new Controls::Menu();
	*macroMenu << Controls::Menu::OwnerDrawnItem(CMD_MACRO_EXECUTE)
		<< Controls::Menu::OwnerDrawnItem(CMD_MACRO_DEFINE) << Controls::Menu::OwnerDrawnItem(CMD_MACRO_APPEND)
		<< Controls::Menu::OwnerDrawnItem(CMD_MACRO_PAUSERESTART) << Controls::Menu::OwnerDrawnItem(CMD_MACRO_INSERTQUERY)
		<< Controls::Menu::OwnerDrawnItem(CMD_MACRO_ABORT) << Controls::Menu::OwnerDrawnItem(CMD_MACRO_SAVEAS)
		<< Controls::Menu::OwnerDrawnItem(CMD_MACRO_LOAD) << sep << Controls::Menu::OwnerDrawnItem(CMD_MACRO_SCRIPTS);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_MACRO_TOP, *macroMenu, true);

	// [}N]-[XNvg] (b)
	Controls::Menu* scriptMenu = new Controls::Menu();
//	*scriptMenu << Controls::Menu::OwnerDrawnItem(CMD_EDIT_RELOADPLUGIN) << sep;
	const size_t c = scriptMacroManager_->getCount();
	if(c != 0) {
//		*scriptControls::Menu << Controls::Menu::OwnerDrawnItem(CMD_MACRO_INTERRUPT) << sep;
		for(size_t i = 0; i < c; ++i)
			*scriptMenu << Controls::Menu::OwnerDrawnItem(CMD_EDIT_PLUGINLIST_START + static_cast<UINT>(i));
	} else
		*scriptMenu << Controls::Menu::OwnerDrawnItem(CMD_EDIT_PLUGINLIST_START, MFS_GRAYED | MFS_DISABLED);
	macroMenu->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_MACRO_SCRIPTS, *scriptMenu, true);

	// [c[]
	Controls::Menu* toolMenu = new Controls::Menu();
	*toolMenu << Controls::Menu::OwnerDrawnItem(CMD_TOOL_EXECUTE)
		<< Controls::Menu::OwnerDrawnItem(CMD_TOOL_EXECUTECOMMAND) << sep
		<< Controls::Menu::OwnerDrawnItem(CMD_TOOL_APPDOCTYPES) << Controls::Menu::OwnerDrawnItem(CMD_TOOL_DOCTYPEOPTION)
		<< Controls::Menu::OwnerDrawnItem(CMD_TOOL_COMMONOPTION) << Controls::Menu::OwnerDrawnItem(CMD_TOOL_FONT);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_TOOL_TOP, *toolMenu, true);
	delete appDocTypeMenu_;
	appDocTypeMenu_ = new Controls::Menu();	// [Kp^Cv]
	toolMenu->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_TOOL_APPDOCTYPES, *appDocTypeMenu_, false);

	// [wv]
	Controls::Menu* helpMenu = new Controls::Menu();
	*helpMenu << Controls::Menu::OwnerDrawnItem(CMD_HELP_ABOUT);
	menu_->setChildPopup<Controls::Menu::BY_COMMAND>(CMD_HELP_TOP, *helpMenu, true);

	getMainWindow().drawMenuBar();
}

/// c[o[̏ (1񂵂ĂяoĂ͂ȂȂ)
void AlphaApp::setupToolbar() {
	assertValid();

	// Wc[o[
	CommandID* commands = 0;	// c[o[ɏ悹{^ɑΉR}h
	size_t buttonCount;			// {^
	list<wstring> buttonIDs;

	// ݒǂݍ
	readProfileList(L"ToolbarButtons", L"standard", buttonIDs, L"");

	if(!buttonIDs.empty()) {	// Ggꍇ
		list<wstring>::const_iterator it;
		size_t i = 0;

		buttonCount = buttonIDs.size();
		commands = new CommandID[buttonCount];
		for(i = 0, it = buttonIDs.begin(); it != buttonIDs.end(); ++i, ++it)
			commands[i] = static_cast<CommandID>(wcstoul(it->c_str(), 0, 10));
	} else {	// ftHg̐ݒg
		buttonCount = 16;
		commands = new CommandID[buttonCount];
		commands[0] = CMD_FILE_NEW;			commands[1] = CMD_FILE_OPEN;
		commands[2] = CMD_FILE_SAVE;		commands[3] = CMD_FILE_SAVEAS;
		commands[4] = CMD_FILE_SAVEALL;		commands[5] = 0;
		commands[6] = CMD_EDIT_CUT;			commands[7] = CMD_EDIT_COPY;
		commands[8] = CMD_EDIT_PASTE;		commands[9] = 0;
		commands[10] = CMD_EDIT_UNDO;		commands[11] = CMD_EDIT_REDO;
		commands[12] = 0;					commands[13] = CMD_SEARCH_FIND;
		commands[14] = CMD_SEARCH_FINDNEXT;	commands[15] = CMD_SEARCH_FINDPREV;
	}

	// C[WXg쐬
	WCHAR iconDir[MAX_PATH];
	wcscpy(iconDir, getModuleFileName());
	::PathFindFileNameW(iconDir)[0] = 0;
	wcscat(iconDir, IDS_ICON_DIRECTORY_NAME);
	commandManager_->createImageList(iconDir);

	// {^
	TBBUTTON* buttons = new TBBUTTON[buttonCount];
	bool hasDropArrow;
	for(size_t i = 0; i < buttonCount; ++i) {
		hasDropArrow = commands[i] == CMD_FILE_NEW || commands[i] == CMD_FILE_OPEN;
		ZeroMemory(buttons + i, sizeof(TBBUTTON));
		buttons[i].fsState = TBSTATE_ENABLED;
		if(commands[i] == 0)
			buttons[i].fsStyle = BTNS_SEP;
		else {
			size_t icon = commandManager_->getIconIndex(commands[i]);

			if(hasDropArrow)	buttons[i].fsStyle = BTNS_BUTTON | BTNS_DROPDOWN;
			else if(icon == -1)	buttons[i].fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON;
			else				buttons[i].fsStyle = BTNS_BUTTON;
			if(icon != -1 /*&& !bHasDropArrow*/)
				buttons[i].iBitmap = static_cast<int>(icon);
			else {
				const wstring caption = commandManager_->getCaption(commands[i]);
				wchar_t* p = new wchar_t[caption.length() + 1];
				wcscpy(p, caption.c_str());
				buttons[i].iString = reinterpret_cast<INT_PTR>(p);
				buttons[i].iBitmap = hasDropArrow ? static_cast<int>(icon) : I_IMAGENONE;
			}
		}
		buttons[i].idCommand = commands[i];
	}

	if(!toolbar_.isWindow()) {
		toolbar_.create(rebar_, Controls::DefaultWindowRect(), L"", IDC_TOOLBAR,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE
			| CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE | CCS_TOP
			| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT, WS_EX_TOOLWINDOW);
		HWND toolTips = toolbar_.getToolTips();
		toolbar_.setButtonStructSize();
		toolbar_.setExtendedStyle(TBSTYLE_EX_DRAWDDARROWS /*| TBSTYLE_EX_HIDECLIPPEDBUTTONS*/);
		::SetWindowLongPtrW(toolTips, GWL_STYLE, ::GetWindowLongPtrW(toolTips, GWL_STYLE) | TTS_NOPREFIX);
	} else {
		toolbar_.setImageList(0);
		toolbar_.setDisabledImageList(0);
		while(toolbar_.getButtonCount() != 0)
			toolbar_.deleteButton(0);
	}
	toolbar_.addButtons(static_cast<int>(buttonCount), buttons);
	toolbar_.setImageList(commandManager_->getImageList(CommandManager::ICONSTATE_NORMAL));
	toolbar_.setDisabledImageList(commandManager_->getImageList(CommandManager::ICONSTATE_DISABLED));
	toolbar_.setHotImageList(commandManager_->getImageList(CommandManager::ICONSTATE_HOT));
//	toolbar_.setPadding(6, 6);

	for(size_t i = 0; i < buttonCount; ++i) {
		delete[] reinterpret_cast<wchar_t*>(buttons[i].iString);
		if(buttons[i].fsStyle != BTNS_SEP
				&& buttons[i].iBitmap != I_IMAGENONE) {	// ACRt{^̕ŌŒ肷
			AutoZeroCB<TBBUTTONINFOW> tbi;
			tbi.dwMask = TBIF_SIZE;
			tbi.cx = (buttons[i].idCommand != CMD_FILE_NEW && buttons[i].idCommand != CMD_FILE_OPEN) ? 22 : 38;
			toolbar_.setButtonInfo(buttons[i].idCommand, tbi);
		}
	}
	delete[] commands;
	delete[] buttons;

	// o[ɏ悹
	AutoZeroCB<REBARBANDINFOW> rbbi;
	const wstring caption = loadString(MSG_BUFFERBAR_CAPTION);
	rbbi.fMask = RBBIM_CHILD | RBBIM_CHILDSIZE | RBBIM_ID | RBBIM_STYLE;
	rbbi.fStyle = RBBS_GRIPPERALWAYS | RBBS_USECHEVRON;
	rbbi.wID = IDC_TOOLBAR;
	rbbi.hwndChild = toolbar_.getSafeHwnd();
	rbbi.cxMinChild = 0;
	rbbi.cyMinChild = 22;
	rebar_.insertBand(0, rbbi);

	// c[o[̃VFu镝̐ݒ
	RECT rect;
	toolbar_.getItemRect(toolbar_.getButtonCount() - 1, rect);
	rbbi.fMask = RBBIM_IDEALSIZE;
	rbbi.cxIdeal = rect.right;
	rebar_.setBandInfo(rebar_.idToIndex(IDC_TOOLBAR), rbbi);
}

/// K\G[_CAO\
void AlphaApp::showRegexSearchError(const SearchError& e) {
	if(e.getCode() == SearchError::RUNTIME_ERROR_FOR_COMPLEXITY)	// ̃G[
		messageBox(MSG_REGEX_SEARCH_ERROR, MB_ICONEXCLAMATION);
	else if(e.getCode() == SearchError::MIGEMO_ERROR)	// Migemo ̃G[ (Ǝv)
		messageBox(MSG_MIGEMO_SEARCH_ERROR, MB_ICONEXCLAMATION);
	else if(e.isFatalError())	// p^[̃RpCG[
		messageBox(MSG_REGEXP_PATTERN_SYNTAX_ERROR, MB_ICONEXCLAMATION,
			MARGS % loadString(MSG_BAD_REGEX_PATTERN_START + e.getCode()
				- SearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT) % e.getPosition());
	else	// }b`Ȃ
		messageBox(MSG_TEXT_NOT_FOUND, MB_ICONINFORMATION);
}

/// [ƒu] _CAO\ăp^[ҏWeLXg{bNXɃtH[JX^
void AlphaApp::showSearchDialog() {
	if(!searchDialog_->isWindowVisible()) {
		if(initializeFindTextFromEditor_) {	// ANeBuȃGfB^猟p^[o
			AlphaView& activeView = buffers_->getActiveView();
			if(activeView.getSelection().isEmpty()) {
				string_t s;
				activeView.getNearestWordFromCaret(0, 0, &s);
				searchDialog_->setDlgItemText(IDC_COMBO_FINDWHAT, s.c_str());
			} else if(activeView.getSelection().getAnchorPoint().getLineNumber()
					!= activeView.getSelection().getActivePoint().getLineNumber())
				searchDialog_->setDlgItemText(IDC_COMBO_FINDWHAT, L"");
			else
				searchDialog_->setDlgItemText(IDC_COMBO_FINDWHAT, activeView.getSelection().getText().c_str());
		}
		searchDialog_->showWindow(SW_SHOW);
	} else
		searchDialog_->setActiveWindow();
	::SetFocus(searchDialog_->getDlgItem(IDC_COMBO_FINDWHAT));
}

/**
 *	Xe[^Xo[̍XV
 *	@param panes XVyC
 */
void AlphaApp::updateStatusBar(StatusBarPane panes) {
	assertValid();

	if(!statusBar_.isWindowVisible())
		return;

	const int ICON_WIDTH = 16;
	AlphaDoc& activeBuffer = buffers_->getActive();
	const AlphaView& activeView = buffers_->getActiveView();

	// p[c̕XVKv
	if(toBoolean(panes & (SBP_DOCUMENTTYPE | SBP_ENCODING))) {
		ClientDC dc = statusBar_.getDC();
		HFONT oldFont = static_cast<HFONT>(dc.selectObject(statusFont_));
		int parts[9];
		int borders[3];
		RECT rect;

		statusBar_.setSimple(false);
		statusBar_.getWindowRect(rect);
		statusBar_.getBorders(borders);
		const int padding = (borders[0] + borders[2]) * 2 + 5;

		// E[
		parts[8] = rect.right - rect.left;
		// TCYObv
		parts[7] = parts[8] - (getMainWindow().isZoomed() ? 0 : (rect.bottom - rect.top - borders[1] * 2));
		// i[CO
		parts[6] = parts[7] - ICON_WIDTH - padding;
		// ㏑/}[h
		const wstring overtypeMode = loadString(MSG_OVERTYPE_MODE);
		const wstring insertMode = loadString(MSG_INSERT_MODE);
		parts[5] = parts[6] - max(
			dc.getTextExtent(overtypeMode.data(), static_cast<int>(overtypeMode.length())).cx,
			dc.getTextExtent(insertMode.data(), static_cast<int>(insertMode.length())).cx) - padding;
		// fobO[h
		parts[4] = parts[5] - ICON_WIDTH - padding;
		// L[{[h}N
		parts[3] = parts[4] - ICON_WIDTH - padding;
		// GR[fBO
		const wstring* encoding = getCodePageName(activeBuffer.getCodePage());
		parts[2] = parts[3] - dc.getTextExtent(encoding->data(), static_cast<int>(encoding->length())).cx - padding;
		// ^Cv
		parts[1] = parts[2] - dc.getTextExtent(activeBuffer.getDocumentType().data(),
			static_cast<int>(activeBuffer.getDocumentType().length())).cx - padding;
		// Lbgʒu
		const wstring caretPosition = activeView.getCurrentPositionString();
		parts[0] = parts[1] - dc.getTextExtent(caretPosition.data(), static_cast<int>(caretPosition.length())).cx - padding;

		statusBar_.setParts(countof(parts), parts);
		statusBar_.setText(8 | SBT_NOBORDERS, L"");
		dc.selectObject(oldFont);
	} else if(toBoolean(panes & SBP_POSITION)) {
		ClientDC dc = statusBar_.getDC();
		int parts[9];
		int borders[3];
		const wstring caretPosition = activeView.getCurrentPositionString();
		HFONT oldFont = static_cast<HFONT>(dc.selectObject(statusFont_));

		statusBar_.getBorders(borders);
		statusBar_.getParts(countof(parts), parts);
		const int oldWidth = parts[0];
		parts[0] = parts[1] - dc.getTextExtent(caretPosition.data(),
			static_cast<int>(caretPosition.length())).cx - (borders[0] + borders[2]) * 2 - 6;
		if(parts[0] != oldWidth)
			statusBar_.setParts(countof(parts), parts);
		dc.selectObject(oldFont);
	}

#define UPDATE_PANE(index, pane, text)	if(toBoolean(panes & pane))	statusBar_.setText(index, text)
#define UPDATE_PANE_WITH_ICON(index, pane, text, icon)	\
	if(toBoolean(panes & pane)) {						\
		statusBar_.setText(index, text);				\
		statusBar_.setTipText(index, text);				\
		statusBar_.setIcon(index, icon);				\
	}

	UPDATE_PANE_WITH_ICON(7, SBP_NARROWING,
		activeBuffer.isNarrowed() ? loadString(MSG_NARROWING).c_str() : L"",
		activeBuffer.isNarrowed() ? narrowingIcon_ : 0);
	UPDATE_PANE(6, SBP_OVERTYPEMODE, loadString(activeView.isOvertypeMode() ? MSG_OVERTYPE_MODE : MSG_INSERT_MODE).c_str());
//	UPDATE_PANE(5, SBP_DEBUGMODE, /*(activeDebugger_ != 0 && activeDebugger_->isDebugging()) ? loadString(MSG_DEBUGGING) :*/ L"");
	if(toBoolean(panes & SBP_TEMPORARYMACRO)) {
		if(commandManager_->getTemporaryMacro().getState() == TemporaryMacro::DEFINING) {
			UPDATE_PANE_WITH_ICON(4, SBP_TEMPORARYMACRO,
				loadString(MSG_TEMPORARY_MACRO_DEFINING).c_str(), temporaryMacroDefiningIcon_);
		} else if(commandManager_->getTemporaryMacro().getState() == TemporaryMacro::PAUSING) {
			UPDATE_PANE_WITH_ICON(4, SBP_TEMPORARYMACRO,
				loadString(MSG_TEMPORARY_MACRO_PAUSING).c_str(), temporaryMacroPausingIcon_);
		} else
			UPDATE_PANE_WITH_ICON(4, SBP_TEMPORARYMACRO, L"", 0);
	}
	UPDATE_PANE(3, SBP_ENCODING, getCodePageName(activeBuffer.getCodePage())->c_str());
	UPDATE_PANE(2, SBP_DOCUMENTTYPE, activeBuffer.getDocumentType().c_str());
	UPDATE_PANE(1, SBP_POSITION, activeView.getCurrentPositionString());

#undef UPDATE_PANE
#undef UPDATE_PANE_WITH_ICON
}

/// ANeBuȃobt@ɊÂă^Cgo[̍XV
void AlphaApp::updateTitleBar() {
	assertValid();

	static const AlphaDoc* lastDocument;
	static wstring titleCache;

	if(!getMainWindow().isWindow())
		return;

	const AlphaDoc& activeBuffer = buffers_->getActive();
	wstring title = BufferList::getDisplayName(activeBuffer);

	if(&activeBuffer == lastDocument && title == titleCache)
		return;
	titleCache = title;
	lastDocument = &activeBuffer;

	// ^Cgo[
	title += L" - " IDS_APPFULLVERSION;
	getMainWindow().setWindowText(title.c_str());
}

/// @see IncrementalSearcher::IEventListener::onISearchAborted
void AlphaApp::onISearchAborted() {
}

/// @see IncrementalSearcher::IEventListener::onISearchCompleted
void AlphaApp::onISearchCompleted() {
	setStatusText(0);
	if(toBoolean(readIntegerProfile(L"View", L"applyMainFontToSomeControls", 1)))
		statusBar_.setFont(0);
}

/// @see IncrementalSearcher::IEventListener::onISearchPatternChanged
void AlphaApp::onISearchPatternChanged(const SearchResult& result) {
	const IncrementalSearcher& isearch = buffers_->getActiveView().getIncrementalSearcher();
	UINT msg;
	const bool forward = isearch.getSearchDirection();

	if(isearch.getSearchText().empty()) {
		msg = forward ? MSG_ISEARCH_TEXT_IS_EMPTY : MSG_RISEARCH_TEXT_IS_EMPTY;
		setStatusText(loadString(msg).c_str());
		return;
	} else if(result.getCode() == SearchError::SUCCEEDED)
		msg = forward ? MSG_ISEARCH_PROMPT : MSG_RISEARCH_PROMPT;
	else {
		if(result.getCode() == SearchError::NO_MATCH)
			msg = forward ? MSG_ISEARCH_NOT_FOUND_PROMPT : MSG_RISEARCH_NOT_FOUND_PROMPT;
		else
			msg = forward ? MSG_ISEARCH_BAD_REGEXP : MSG_RISEARCH_BAD_REGEXP;
		buffers_->getActiveView().beep();
	}

	string_t prompt = loadString(msg, MARGS % isearch.getSearchText());
	replace_if(prompt.begin(), prompt.end(), bind2nd(equal_to<wchar_t>(), L'\t'), L' ');
	setStatusText(prompt.c_str());
}

/// @see IncrementalSearcher::IEventListener::onISearchStarted
void AlphaApp::onISearchStarted() {
	// Xe[^Xo[̃tHgGfB^̂̂Ɉv
	if(toBoolean(readIntegerProfile(L"View", L"applyMainFontToSomeControls", 1)))
		statusBar_.setFont(editorFont_);
}

/// @see IEditViewEventListener::onInvokeURILink
void AlphaApp::onInvokeURILink(const char_t* uri) {
	::ShellExecuteW(0, 0, uri, 0, 0, SW_SHOWNORMAL);
}

/// [s]
void AlphaApp::onToolExecute() {
	const AlphaDoc& activeBuffer = buffers_->getActive();
	const basic_string<WCHAR> pathName = (activeBuffer.getPathName() != 0) ? activeBuffer.getPathName() : L"";
	const DocumentTypeManager& types = buffers_->getDocumentTypeManager();
	wstring command = types.getAt(types.find(activeBuffer.getDocumentType())).command;

	if(command.empty()) {	// R}hݒ肳ĂȂ
		messageBox(MSG_EXE_NOT_REGISTERED, MB_ICONEXCLAMATION, MARGS % activeBuffer.getDocumentType());
		return;
	}

	// '$F' WJ
	size_t i = 0;
	while(wstring::npos != (i = command.find(L"$F", i))) {
		command.replace(i, 2, L"\"" + pathName + L"\"");
		i += pathName.length() + 2;
	}

	AutoZeroS<STARTUPINFO, DWORD, &STARTUPINFO::cb> si;
	PROCESS_INFORMATION pi;
	if(!toBoolean(::CreateProcessW(0,
			const_cast<wchar_t*>(command.c_str()), 0, 0, false, NORMAL_PRIORITY_CLASS, 0, 0, &si, &pi)))
		messageBox(MSG_FAILED_TO_RUN_EXE, MB_ICONEXCLAMATION);
}

/// @see IEditViewEventListener::onChangedAbbreviationExpansionReadyState
void AlphaApp::onChangedAbbreviationExpansionReadyState(bool ready, const string_t& abbrev) {
	if(!statusBar_.isWindow())
		return;
	else if(ready) {
		if(!abbrev.empty()) {
			const wstring s = loadString(MSG_INDICATE_CAN_EXPAND_ABBREV,
					MARGS % abbrev % EditView::getAbbreviations().expand(abbrev));
			setStatusText(s.c_str());
		}
	} else
		setStatusText(0);
}

/// @see BufferList::IActiveBufferListener::onChangedActiveBuffer
void AlphaApp::onChangedActiveBuffer() {
	updateTitleBar();
	updateStatusBar(SBP_ALL);
}

/// @see BufferList::IActiveBufferListener::onChangedActiveBufferProperty
void AlphaApp::onChangedActiveBufferProperty() {
	updateTitleBar();
	updateStatusBar(SBP_ALL);
}

/// @see ClipboardRing::IEventListener::onClipboardRingChanged
void AlphaApp::onClipboardRingChanged() {
}

/// @see ClipboardRing::IEventListener::onClipboardRingDeniedAdding
void AlphaApp::onClipboardRingDeniedAdding() {
}

/// @see WM_CLOSE
bool AlphaApp::onClose() {
	AutoZero<DISPPARAMS> params;
	eventHandlerScript_->invoke(OLESTR("OnApplicationTerminating"), params);
	if(buffers_->closeAll(true)) {
		saveINISettings();
		getMainWindow().destroyWindow();
		return true;
	}
	return false;	// [ULZ
}

/// @see Window::onCommand
bool AlphaApp::onCommand(WORD id, WORD notifyCode, HWND control) {
//	if(::GetCurrentThreadId() != getMainWindow().getWindowThreadID())
//		getMainWindow().sendMessage(WM_COMMAND, MAKEWPARAM(id, notifyCode), reinterpret_cast<LPARAM>(control));
	if(id == CMD_SPECIAL_ILLEGAL2STROKE) {
		::MessageBeep(MB_OK);
		return true;
	} else if(id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END) {
		if(commandManager_->isEnabled(id, true))
			buffers_->setActive(buffers_->getAt(id - CMD_VIEW_BUFFERLIST_START));
	} else
		commandManager_->executeCommand(static_cast<CommandID>(id), true);
	return true;
}

/// @see WM_COPYDATA
void AlphaApp::onCopyData(HWND window, const COPYDATASTRUCT& cds) {
	const WCHAR* const data = static_cast<WCHAR*>(cds.lpData);
	parseCommandLine(data, data + MAX_PATH);
}

/// @see Window::onDestroy
void AlphaApp::onDestroy() {
	// nȂ (AlphaApp::onClose Q)
	getMainWindow().killTimer(ID_TIMER_QUERYCOMMAND);

	delete menu_;
	delete mruManager_;
//	toolbar_.destroyWindow();
//	statusBar_.destroyWindow();

	::PostQuitMessage(0);	// STA XbhI
}

/// @see WM_DRAWITEM
void AlphaApp::onDrawItem(UINT, const DRAWITEMSTRUCT& drawItem) {
	if(drawItem.CtlType != ODT_MENU)	// _ł̓j[̕`̂
		return;

	// wingdi.h  GetXValue ͌^SłȂ
#define R_VALUE(rgb) static_cast<uchar>((rgb & 0x000000FF) >> 0)
#define G_VALUE(rgb) static_cast<uchar>((rgb & 0x0000FF00) >> 8)
#define B_VALUE(rgb) static_cast<uchar>((rgb & 0x00FF0000) >> 16)

	AutoDC dc(drawItem.hDC);
	const RECT& itemRect = drawItem.rcItem;
	RECT captionRect;
	HPEN oldPen, pen;
	HBRUSH oldBrush, brush;
	wchar_t* caption = 0;
	wchar_t* accel = 0;	// ANZ[^At@C

	const bool checked = toBoolean(drawItem.itemState & ODS_CHECKED);
	const bool disabled = toBoolean(drawItem.itemState & ODS_DISABLED);
	const bool selected = toBoolean(drawItem.itemState & ODS_SELECTED);
	const CommandID id = drawItem.itemID;
	const COLORREF highlightFgColor = ::GetSysColor(COLOR_HIGHLIGHT);
	const COLORREF highlightBgColor =
		RGB(R_VALUE(highlightFgColor) / 3 + 170, G_VALUE(highlightFgColor) / 3 + 170, B_VALUE(highlightFgColor) / 3 + 170);
	const COLORREF highlightIconBgColor =
		RGB((R_VALUE(highlightBgColor) + 0xFF) / 2, (G_VALUE(highlightBgColor) + 0xFF) / 2, (B_VALUE(highlightBgColor) + 0xFF) / 2);

	// ̃j[̕`fUC͓Kɍl̂
	// WTL ̂悤Ȃ̂WƎv̂ŁA͕ύXǂƎv

	// wi̕`
	if(selected) {
		pen = ::CreatePen(PS_SOLID, 1, highlightFgColor);
		brush = ::CreateSolidBrush(highlightBgColor);
		oldPen = dc.selectObject(pen);
		oldBrush = dc.selectObject(brush);
		dc.rectangle(itemRect);
		dc.selectObject(oldPen);
		dc.selectObject(oldBrush);
		::DeleteObject(pen);
		::DeleteObject(brush);
	} else {
		dc.fillSolidRect(itemRect, ::GetSysColor(COLOR_MENU));
//		dc.fillSolidRect(itemRect.left, itemRect.top,
//			itemRect.bottom - itemRect.top, itemRect.bottom - itemRect.top,
//			::GetSysColor(COLOR_3DFACE));
	}

	if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {	// MRU Xg
		const wchar_t* number = getMenuLabel(id);
		const wchar_t* filePath = wcsstr(number, L"  ") + 2;
		const wchar_t* fileName = ::PathFindFileNameW(filePath);
		captionRect = itemRect;
		captionRect.left += 14;
		captionRect.right -= 14;
		dc.setBkMode(TRANSPARENT);

		// ԍ̕`
		dc.drawText(number, static_cast<int>(filePath - number), captionRect, DT_SINGLELINE | DT_VCENTER);
		dc.drawText(number, static_cast<int>(filePath - number), captionRect, DT_CALCRECT | DT_SINGLELINE | DT_VCENTER);
		::SetRect(&captionRect, captionRect.right, itemRect.top, itemRect.right, itemRect.bottom);

		// pX̕`
		if(filePath != fileName) {
			dc.drawText(filePath,
				static_cast<int>(fileName - filePath), captionRect, DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
			dc.drawText(filePath,
				static_cast<int>(fileName - filePath), captionRect, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
			::SetRect(&captionRect, captionRect.right, itemRect.top, itemRect.right, itemRect.bottom);
		}

		// t@C̕`
		dc.drawText(fileName, -1, captionRect, DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
		dc.drawText(fileName, -1, captionRect, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);

		// t@C̉ɉ
		pen = ::CreatePen(PS_SOLID, 1, dc.getTextColor());
		oldPen = dc.selectObject(pen);
		dc.moveTo(captionRect.left, captionRect.bottom - 1);
		dc.lineTo(captionRect.right, captionRect.bottom - 1);
		dc.selectObject(oldPen);
		::DeleteObject(pen);
	} else {
		// ACR̕`
		const bool isBuffers = id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END;
		const size_t icon = !isBuffers ? commandManager_->getIconIndex(id) : id - CMD_VIEW_BUFFERLIST_START;
		RECT iconRect;

		iconRect.left = itemRect.left + (itemRect.bottom - itemRect.top - 16) / 2 - 1;
		iconRect.top = itemRect.top + (itemRect.bottom - itemRect.top - 16) / 2 - 1;
		iconRect.right = iconRect.left + 18;
		iconRect.bottom = iconRect.top + 18;
		if(icon != -1 || isBuffers) {	// ACRpłꍇ
			if(checked) {	// `FbN
				pen = ::CreatePen(PS_SOLID, 1, highlightFgColor);
				brush = ::CreateSolidBrush(highlightIconBgColor);
				oldPen = dc.selectObject(pen);
				oldBrush = dc.selectObject(brush);
				dc.rectangle(iconRect);
				dc.selectObject(oldPen);
				dc.selectObject(oldBrush);
				::DeleteObject(pen);
				::DeleteObject(brush);
			}
			::InflateRect(&iconRect, -1, -1);
			if(isBuffers)
				dc.drawIconEx(iconRect.left, iconRect.top, buffers_->getBufferIcon(icon), 16, 16, 0, 0, DI_NORMAL);
			else {
				const CommandManager::IconState state =
					disabled ? CommandManager::ICONSTATE_DISABLED :
						(selected ? CommandManager::ICONSTATE_HOT : CommandManager::ICONSTATE_NORMAL);
				commandManager_->getImageList(state).draw(dc, static_cast<int>(icon), iconRect.left, iconRect.top, ILD_NORMAL);
			}
			::InflateRect(&iconRect, 1, 1);
		} else if(checked) {
			const int checkBoxWidth = itemRect.bottom - itemRect.top;
			pen = ::CreatePen(PS_SOLID, 1, highlightFgColor);
			brush = ::CreateSolidBrush(highlightIconBgColor);
			oldPen = dc.selectObject(pen);
			oldBrush = dc.selectObject(brush);
			dc.rectangle(itemRect.left + 1, itemRect.top + 1, itemRect.left + itemRect.bottom - itemRect.top - 1, itemRect.bottom - 1);
			dc.selectObject(oldPen);
			dc.selectObject(oldBrush);
			::DeleteObject(pen);
			::DeleteObject(brush);
			pen = ::CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));	// v񂩂?
			oldPen = dc.selectObject(pen);
			dc.moveTo(itemRect.left + checkBoxWidth / 2 - 3, itemRect.top + checkBoxWidth / 2 - 1);	// `FbN}[N
			dc.lineTo(itemRect.left + checkBoxWidth / 2 - 1, itemRect.top + checkBoxWidth / 2 + 1);
			dc.lineTo(itemRect.left + checkBoxWidth / 2 + 4, itemRect.top + checkBoxWidth / 2 - 4);
			dc.moveTo(itemRect.left + checkBoxWidth / 2 - 3, itemRect.top + checkBoxWidth / 2 + 0);
			dc.lineTo(itemRect.left + checkBoxWidth / 2 - 1, itemRect.top + checkBoxWidth / 2 + 2);
			dc.lineTo(itemRect.left + checkBoxWidth / 2 + 4, itemRect.top + checkBoxWidth / 2 - 3);
			dc.selectObject(oldPen);
			::DeleteObject(pen);
		}

		if(id == 0	// ؂̕`
				&& (drawItem.itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(drawItem.itemData)) == 0)) {
			oldPen = dc.selectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DSHADOW)));

			dc.moveTo(itemRect.left + 1, itemRect.top + 1);
			dc.lineTo(itemRect.right - 1, itemRect.top + 1);
			::DeleteObject(dc.selectObject(oldPen));
			dc.selectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DHIGHLIGHT)));
			dc.moveTo(itemRect.left + 1, itemRect.top + 2);
			dc.lineTo(itemRect.right - 1, itemRect.top + 2);
			::DeleteObject(dc.selectObject(oldPen));
		} else {	// LvV̕`
			dc.setBkMode(TRANSPARENT);
			captionRect = itemRect;
//			if(reinterpret_cast<HMENU>(drawItem.hwndItem) != menu_->getSafeHmenu()) {
				COLORREF captionColor = ::GetSysColor(disabled ? COLOR_GRAYTEXT : COLOR_MENUTEXT);
				const wchar_t* orgCaption = (drawItem.itemData == 0) ?
					getMenuLabel(drawItem.itemID) : reinterpret_cast<const wchar_t*>(drawItem.itemData);
				if(id != 0 && commandManager_->getLastCommand() == id)
					captionColor = RGB(R_VALUE(captionColor),
						(G_VALUE(captionColor) + 0xFF) / 2, B_VALUE(captionColor));
				dc.setTextColor(captionColor);
				captionRect.left = iconRect.right + 6;
				captionRect.right -= 6;
				caption = new wchar_t[wcslen(orgCaption) + 1];
				wcscpy(caption, orgCaption);
				accel = wcschr(caption, L'\t');
				if(accel != 0) {
					*accel = 0;
					dc.drawText(caption, -1, captionRect, DT_SINGLELINE | DT_VCENTER);
					dc.drawText(accel + 1, -1, captionRect, DT_RIGHT | DT_SINGLELINE | DT_VCENTER);
				} else
					dc.drawText(caption, -1, captionRect, DT_SINGLELINE | DT_VCENTER);
				delete[] caption;
//			} else {	// j[o[̏ꍇ
//				if(selected || drawItem.itemState & ODS_HOTLIGHT) {
//					dc.fillSolidRect(&captionRect, ::GetSysColor(COLOR_HIGHLIGHT));
//					dc.setTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
//				} else {
//					dc.fillSolidRect(&captionRect, ::GetSysColor(COLOR_BTNFACE));
//					dc.setTextColor(::GetSysColor(COLOR_MENUTEXT));
//				}
//				dc.drawText(reinterpret_cast<const wchar_t*>(drawItem.itemData),
//					-1, &captionRect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
//			}
		}
	}

#undef R_VALUE
#undef G_VALUE
#undef B_VALUE
}

/// @see WM_DROPFILES
void AlphaApp::onDropFiles(HDROP drop) {
	const uint c = ::DragQueryFileW(drop, 0xFFFFFFFF, 0, 0);
	WCHAR filePath[MAX_PATH];

	for(uint i = 0; i < c; ++i) {
		::DragQueryFileW(drop, i, filePath, MAX_PATH);
		if(!toBoolean(::PathIsDirectoryW(filePath)))
			buffers_->open(filePath);
		else
			buffers_->openDialog(filePath);
	}
	::DragFinish(drop);

	AlphaView& activeView = buffers_->getActiveView();
	if(activeView.isWindow())
		activeView.setFocus();
}

/// @see WM_ENTERMENULOOP
void AlphaApp::onEnterMenuLoop(bool isTrackPopup) {
	statusBar_.setSimple(true);
}

/// @see WM_EXITMENULOOP
void AlphaApp::onExitMenuLoop(bool isTrackPopup) {
	statusBar_.setSimple(false);
}

/// @see WM_INITMENUPOPUP
void AlphaApp::onInitMenuPopup(HMENU menu, UINT, bool sysMenu) {
	if(sysMenu)
		return;
	else if(appDocTypeMenu_->getSafeHmenu() == menu) {	// Kp^Cv
		const AlphaDoc& activeBuffer = buffers_->getActive();
		const DocumentTypeManager& types = buffers_->getDocumentTypeManager();
		const bool ctrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		while(appDocTypeMenu_->getItemCount() > 0)	// ׂč폜
			appDocTypeMenu_->deleteMenuItem<Controls::Menu::BY_POSITION>(0);
		for(size_t i = 0; i < types.getCount(); ++i) {
			const DocumentType& type = types.getAt(i);
			if(type.hidden && !ctrlPressed)
				continue;
			appDocTypeMenu_->appendMenuItem(CMD_TOOL_DOCTYPELIST_START + static_cast<UINT>(i), type.name.c_str(), MFT_OWNERDRAW);
		}
		appDocTypeMenu_->checkMenuItem<Controls::Menu::BY_COMMAND>(
			CMD_TOOL_DOCTYPELIST_START + static_cast<UINT>(types.find(activeBuffer.getDocumentType())));
	} else {
		Controls::Menu popup(menu);
		const int c = popup.getItemCount();
		for(int i = 0; i < c; ++i) {
			const CommandID id = popup.getMenuItemID(i);
			popup.enableMenuItem<Controls::Menu::BY_POSITION>(i, commandManager_->isEnabled(id, true));
			popup.checkMenuItem<Controls::Menu::BY_POSITION>(i, commandManager_->isChecked(id));
		}
	}
}

/// @see IEditViewEventListener::onMatchBracketFoundOutOfView
void AlphaApp::onMatchBracketFoundOutOfView(const CharPos& pos) {
	if(pos.line_ == -1 && pos.char_ == -1)
		setStatusText(0);
	else {
		const AlphaDoc& activeDocument = buffers_->getActive();
		const AlphaView& activeView = buffers_->getActiveView();
		const Lexer& lexer = activeView.getLexer();
		const length_t lineCount = activeDocument.getLineCount();
		const EditView::Options& options = activeView.getOptions();
		char_t prompt[50] = {0};

		// Ίʂ̎ӂ\ (NUL ܂ރeLXg͖Ή)
		for(length_t i = pos.line_; i < lineCount; ++i) {
			const string_t line = activeDocument.getLine(i);
			const length_t indentLength = lexer.eatWhiteSpaces(line.data(), line.data() + line.length(), true) - line.data();

			if(i == pos.line_) {	// Ίʂ̌s
				// Ίʂ̑O
				if(pos.char_ - indentLength <= 20)
					wcsncat(prompt, line.c_str() + indentLength, pos.char_ - indentLength + 1);
				else {
					wcscpy(prompt, L"... ");
					wcsncat(prompt, line.c_str() + pos.char_ - 16, 17);
				}
				// ʂ̌
				if(line.length() - pos.char_ - 1 <= 20)
					wcscat(prompt, line.c_str() + pos.char_ + 1);
				else {
					wcsncat(prompt, line.c_str() + pos.char_ + 1, 16);
					wcscat(prompt, L" ...");
					break;
				}
			} else {
				wcscat(prompt, L"^J");	// s
				if(indentLength != 0)
					wcscat(prompt, L" ");
				if(wcslen(prompt) >= 37) {
					wcscat(prompt, L" ...");
					break;
				}
				if(wcslen(prompt) + line.length() - indentLength >= 41) {
					wcsncat(prompt, line.c_str() + indentLength, 41 - wcslen(prompt));
					wcscat(prompt, L" ...");
					break;
				} else
					wcscat(prompt, line.c_str() + indentLength);
			}

			// Ίʂ̌
		}
		for(char_t* p = prompt; *p != 0; ++p) {
			if(*p == L'\t')
				*p = L' ';
		}
		const length_t startLine = activeView.getLayoutSetter().getSettings().lineNumberLayout.startLine;
		const wstring s = loadString(MSG_MATCH_BRACKET_OUT_OF_VIEW, MARGS % (pos.line_ + startLine) % prompt);
		setStatusText(s.c_str());
	}
}

/// @see WM_MEASUREITEM
void AlphaApp::onMeasureItem(UINT id, MEASUREITEMSTRUCT& mi) {
	// j[
	if(mi.CtlType == ODT_MENU) {
		if(mi.itemID == 0	// ؂
				&& (mi.itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(mi.itemData)) == 0)) {
			mi.itemHeight = 4;
			mi.itemWidth = 30;	// ̒l͑gȂ
		} else {
			// j[̃tHg擾
			AutoZeroCB<NONCLIENTMETRICSW> ncm;
			::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
			if(mi.itemID == CMD_FILE_CLOSE)	// 
				ncm.lfMenuFont.lfWeight = FW_BOLD;
			HFONT menuFont = ::CreateFontIndirectW(&ncm.lfMenuFont);
			ClientDC dc = getMainWindow().getDC();
			HFONT oldFont = static_cast<HFONT>(dc.selectObject(menuFont));
			RECT rect;
			dc.drawText(mi.itemData == 0 ?
				getMenuLabel(mi.itemID) : reinterpret_cast<wchar_t*>(mi.itemData),
				-1, rect, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE);
			dc.selectObject(oldFont);
			::DeleteObject(menuFont);

			if(mi.itemID == 0)	// |bvAbv̏ꍇA̕𑫂
				rect.right += 24;
			if(mi.itemID > COMMAND_END) {
				mi.itemHeight = rect.bottom - rect.top + 4;
				mi.itemWidth = rect.right - rect.left + 28;
			} else {
				mi.itemHeight = max(rect.bottom - rect.top, 20L);
				mi.itemWidth = rect.right - rect.left + ((mi.itemID >= COMMAND_START) ? 24 : 0);
			}
		}
	}
}

/// @see WM_MENUCHAR
LRESULT AlphaApp::onMenuChar(wchar_t ch, UINT flags, Controls::Menu& menu) {
	const UINT c = menu.getItemCount();
	Controls::Menu::ItemInfo item;

	item.fMask = MIIM_FTYPE | MIIM_ID;

	if(ch >= L'a' && ch <= L'z')	// 啶ɂ
		ch -= 0x20;
	for(UINT i = 0; i < c; ++i) {
		menu.getMenuItemInfo<Controls::Menu::BY_POSITION>(i, item);
		if(item.wID != 0 && !toBoolean(item.fType & MFT_SEPARATOR)) {
			const wchar_t* accel = wcschr(getMenuLabel(item.wID), L'&');
			if(accel != 0) {
				if(accel[1] == ch)
					return (i | 0x00020000);
			}
		}
	}
	return MNC_IGNORE;
}

/// @see WM_MENUSELECT
void AlphaApp::onMenuSelect(UINT itemID, UINT flags, HMENU) {
	// IڂɑΉXe[^Xo[ɕ\
	if(itemID >= CMD_EDIT_PLUGINLIST_START && itemID < CMD_EDIT_PLUGINLIST_END) {	// }N
		statusBar_.setText(statusBar_.isSimple() ? SB_SIMPLEID : 0,
			(scriptMacroManager_->getCount() != 0) ?
			scriptMacroManager_->getDescription(itemID - CMD_EDIT_PLUGINLIST_START).c_str() : L"", SBT_NOBORDERS);
	} else if(itemID >= CMD_VIEW_BUFFERLIST_START && itemID < CMD_VIEW_BUFFERLIST_END)	// obt@
		statusBar_.setText(statusBar_.isSimple() ? SB_SIMPLEID : 0,
			buffers_->getAt(itemID - CMD_VIEW_BUFFERLIST_START).getPathName(), SBT_NOBORDERS);
	else {
		const wstring prompt = (!toBoolean(flags & MF_POPUP) && !toBoolean(flags & MFT_SEPARATOR)) ? loadString(itemID) : L"";
		statusBar_.setText(statusBar_.isSimple() ? SB_SIMPLEID : 0,
			(!prompt.empty()) ? wcschr(prompt.data(), L'\n') + 1 : L"", SBT_NOBORDERS);
	}
}

/// @see IEditViewEventListener::onMoveCaret
void AlphaApp::onMoveCaret(const CharPos&) {
	updateStatusBar(SBP_POSITION);
}

/// @see Window::onNotify
bool AlphaApp::onNotify(int id, NMHDR& nmhdr) {
	if(id == IDC_BUFFERBAR)
		return toBoolean(buffers_->handleBufferBarNotification(*reinterpret_cast<NMTOOLBARW*>(&nmhdr)));
	else if(id == IDC_BUFFERBARPAGER)
		return toBoolean(buffers_->handleBufferBarPagerNotification(nmhdr));

	switch(nmhdr.code) {
	case RBN_HEIGHTCHANGE:	// o[̍ς
		onSize(0, -1, -1);
		return true;
	case RBN_CHEVRONPUSHED:	// c[o[̃VFuꂽ
		onRebarChevronPushed(*reinterpret_cast<LPNMREBARCHEVRON>(&nmhdr));
		return true;
	case TBN_DROPDOWN: {	// c[o[̃hbv_E
		RECT rect;
		POINT pt;
		const bool ctrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		toolbar_.getRect(reinterpret_cast<LPNMTOOLBAR>(&nmhdr)->iItem, rect);
		pt.x = rect.left;
		pt.y = rect.bottom;
		getMainWindow().clientToScreen(pt);
		switch(reinterpret_cast<LPNMTOOLBAR>(&nmhdr)->iItem) {
		case CMD_FILE_NEW:
			while(newDocTypeMenu_->getItemCount() > 0)	// ׂč폜
				newDocTypeMenu_->deleteMenuItem<Controls::Menu::BY_POSITION>(0);
			for(size_t i = 0; i < buffers_->getDocumentTypeManager().getCount(); ++i) {
				const DocumentType& type = buffers_->getDocumentTypeManager().getAt(i);
				if(type.hidden && !ctrlPressed)
					continue;
				newDocTypeMenu_->appendMenuItem(CMD_FILE_DOCTYPELIST_START + static_cast<UINT>(i), type.name.c_str(), MFT_OWNERDRAW);
			}
			newDocTypeMenu_->trackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, getMainWindow());
			return true;
		case CMD_FILE_OPEN:
			mruManager_->getPopupMenu().trackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, getMainWindow());
			return true;
		}
		break;
	}
	case TBN_GETOBJECT:
		onCommand(reinterpret_cast<LPNMOBJECTNOTIFY>(&nmhdr)->iItem, 0, 0);
		return 0;
	case TTN_GETDISPINFOW:	// c[o[̃c[`bv
		if(nmhdr.idFrom >= CMD_VIEW_BUFFERLIST_START && nmhdr.idFrom < CMD_VIEW_BUFFERLIST_END)
			return toBoolean(buffers_->handleBufferBarNotification(*reinterpret_cast<NMTOOLBARW*>(&nmhdr)));
		else {
			static wchar_t tipText[500];
			NMTTDISPINFOW& nmttdi = *reinterpret_cast<NMTTDISPINFOW*>(&nmhdr);

			nmttdi.hinst = getHandle();

			wstring name = commandManager_->getName(static_cast<CommandID>(nmhdr.idFrom));
			const wstring key = keyboardMap_.getKeyString(static_cast<CommandID>(nmhdr.idFrom), false);
			if(!key.empty()) {
				name += L" (";
				name += key;
				name += L")";
			}
			wcscpy(nmttdi.lpszText = tipText, name.c_str());
		}
		return true;
/*	case TBN_HOTITEMCHANGE:
		if(nmhdr.idFrom = IDC_TOOLBAR) {
			NMTBHOTITEM& nmtbhi = *reinterpret_cast<NMTBHOTITEM*>(&nmhdr);
			dout << L"flags=" << nmtbhi.dwFlags << L":old=" << nmtbhi.idOld << L":new=" << nmtbhi.idNew << L"\n";
			if(toBoolean(nmtbhi.dwFlags & HICF_LEAVING))
				setStatusText(L"");
			else if(nmtbhi.idNew == nmtbhi.idOld)
				break;
			else {
				static wchar_t caption[500];
				if(0 != loadString(nmtbhi.idNew, caption, countof(caption))) {
					if(const wchar_t* const lf = wcschr(caption, L'\n'))
						setStatusText(lf + 1);
				} else
					setStatusText(L"");
			}
		}
		break;
*/	}
	return false;
}

/// RBN_CHEVRONPUSHED ̏
void AlphaApp::onRebarChevronPushed(const NMREBARCHEVRON& chevron) {
	AutoZeroCB<REBARBANDINFOW> rbi;
	RECT bandRect;

	// c[o[𓾂 (obt@o[łʂ̃R[hg)
	rebar_.getRect(chevron.uBand, bandRect);
	rbi.fMask = RBBIM_CHILD | RBBIM_IDEALSIZE;
	rebar_.getBandInfo(chevron.uBand, rbi);
	const long buttonCount = static_cast<long>(::SendMessage(rbi.hwndChild, TB_BUTTONCOUNT, 0, 0L));

	// \̃{^܂Ői
	long i;
	RECT buttonRect;
	for(i = 0; i < buttonCount; ++i) {
		::SendMessage(rbi.hwndChild, TB_GETITEMRECT, i, reinterpret_cast<LPARAM>(&buttonRect));
		if(buttonRect.right + bandRect.left > chevron.rc.left)
			break;
	}

	// \̃{^j[ڂɕϊ
	Controls::Menu popup;
	POINT pt = {chevron.rc.left, chevron.rc.bottom};
	AutoZeroCB<TBBUTTONINFOW> tbbi;
	Controls::Menu::ItemInfo item;

    tbbi.dwMask = TBIF_BYINDEX | TBIF_COMMAND | TBIF_STYLE;
	item.fMask = MIIM_DATA | MIIM_FTYPE | MIIM_ID | MIIM_STATE;
	for(; i < buttonCount; ++i) {
		::SendMessage(rbi.hwndChild, TB_GETBUTTONINFOW, i, reinterpret_cast<LPARAM>(&tbbi));
		if(toBoolean(tbbi.fsStyle & TBSTYLE_SEP))
			popup.appendSeparator(MFT_OWNERDRAW);
		else {
			item.fType = MFT_OWNERDRAW;
			item.fState = commandManager_->isEnabled(tbbi.idCommand, true) ? MFS_ENABLED : MFS_DISABLED;
			item.fState |= (commandManager_->isChecked(tbbi.idCommand)) ? MFS_CHECKED : 0;
			item.wID = tbbi.idCommand;
			item.dwItemData = 0/*reinterpret_cast<DWORD>(getControls::MenuLabel(tbbi.idCommand))*/;
			popup.insertMenuItem<Controls::Menu::BY_POSITION>(popup.getItemCount(), item);
		}
	}
	rebar_.clientToScreen(pt);
	popup.trackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, getMainWindow());
}

/// @see Window::onSetCursor
bool AlphaApp::onSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT pt;		// J[\ʒu
	RECT clientRect, statusBarRect;

	getMainWindow().getClientRect(clientRect);
	if(statusBar_.isWindowVisible())	statusBar_.getWindowRect(statusBarRect);
	else								::SetRect(&statusBarRect, 0, 0, 0, 0);
	::GetCursorPos(&pt);
	getMainWindow().screenToClient(pt);

	if(pt.y >= clientRect.bottom - (statusBarRect.bottom - statusBarRect.top) - 3
			&& pt.y <= clientRect.bottom - (statusBarRect.bottom - statusBarRect.top)) {
		::SetCursor(loadStandardCursor(IDC_SIZENS));
		return true;
	}

	return false;
}

/// @see WM_SETTINGCHNAGE
void AlphaApp::onSettingChange(UINT, const wchar_t*) {
	AutoZeroCB<NONCLIENTMETRICSW> ncm;

	::DeleteObject(statusFont_);
	::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICSW), &ncm, 0);
	statusFont_ = ::CreateFontIndirectW(&ncm.lfStatusFont);
	updateStatusBar(SBP_ALL);
}

/**
 *	@see			Window::onSize
 *	@param type		Window::onSize Q
 *	@param cx, cy	-1ɂƂ̃\bh݂͌̃EBhETCYgB
 *					̃\bhs̏PɎgpꍇɂĂяoƂł
 */
void AlphaApp::onSize(UINT type, int cx, int cy) {
	RECT rebarRect, statusBarRect, editorRect;

	if(cx == -1 && cy == -1) {
		RECT rect;
		getMainWindow().getClientRect(rect);
		cx = rect.right - rect.left;
		cy = rect.bottom - rect.top;
	}

	if(statusBar_.isWindowVisible()) {
		statusBar_.sendMessage(WM_SIZE, cx, cy);
		statusBar_.getWindowRect(statusBarRect);
		updateStatusBar(SBP_ALL);
	} else
		::SetRect(&statusBarRect, 0, 0, 0, 0);

	if(rebar_.isWindowVisible()) {
		rebar_.sendMessage(WM_SIZE, cx, cy);
		rebar_.getWindowRect(rebarRect);
		toolbar_.sendMessage(WM_SIZE, cx, rebarRect.bottom - rebarRect.top - 2);
	} else
		::SetRect(&rebarRect, 0, 0, 0, 0);

	editorRect.left =  0;
	editorRect.top = rebarRect.bottom - rebarRect.top;
	editorRect.right = cx;
	editorRect.bottom = cy
		- (statusBar_.isWindowVisible() ? statusBarRect.bottom - statusBarRect.top : 0);
//	if(outputWindow.isWindow() && outputWindow.isWindowVisible())
//		editorRect.bottom -= outputWndHeight_;
	if(buffers_->getEditorWindow().isWindow())
		buffers_->getEditorWindow().moveWindow(editorRect, true);

//	if(outputWindow_.isWindow()) {
//		outputWindow_.moveWindow(0, editorRect.bottom + 2, cx, outputWndHeight_);
//		outputWindow_.showWindow(SW_SHOW);
//	}
}

/// @see WM_TIMER
void AlphaApp::onTimer(UINT timerID) {
	if(timerID == ID_TIMER_QUERYCOMMAND && buffers_->getCount() != 0) {
		// c[o[ACe̗L/
		if(toolbar_.isWindowVisible()) {
			const size_t buttonCount = toolbar_.getButtonCount();
			TBBUTTON button;

//			toolbar_.lockWindowUpdate();	// ꂪƃc[o[XN[Oɂ鎞ɉʂ
			for(size_t i = 0; i < buttonCount; ++i) {
				toolbar_.getButton(static_cast<int>(i), button);
				toolbar_.checkButton(button.idCommand, commandManager_->isChecked(button.idCommand));
				toolbar_.enableButton(button.idCommand, commandManager_->isEnabled(button.idCommand, true));
			}
//			toolbar_.unlockWindowUpdate();
		}
	} else if(timerID == ID_TIMER_MOUSEMOVE) {	// qg\
/*		if(GetActiveTab()->GetTextEditor() != 0
				&& m_pActiveDebugger != 0
				&& m_pActiveDebugger->IsDebugging()) {
			CAlphaView*			pActiveView = GetActiveTab()->GetTextEditor()->GetActiveView();
			DebugPropertyInfo	dpi;
			POINT				pt, ptView;
			wstring				strExpression;
			wostringstream		ssResult;

			::GetCursorPos(&pt);
			ptView = pt;
			pActiveView->ScreenToClient(&ptView);
			strExpression = (pActiveView->HasSelection() && pActiveView->IsOverSelection(ptView)) ?
				pActiveView->GetSelection() : pActiveView->GetNearestWordFromCursor();
			dpi.m_dwValidFields = DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE;
			if(!strExpression.empty()
						&& SUCCEEDED(m_pActiveDebugger->EvaluateExpression(strExpression, 10, true, &dpi))) {
				if(dpi.m_bstrType != 0
						&& wcscmp(dpi.m_bstrType, L"Error") != 0	// VC6
						&& wcscmp(dpi.m_bstrType, L"G[") != 0)	// VC7
					ssResult << dpi.m_bstrName << L" = " << dpi.m_bstrValue;
				if(dpi.m_dwValidFields & DBGPROP_INFO_NAME)		::SysFreeString(dpi.m_bstrName);
				if(dpi.m_dwValidFields & DBGPROP_INFO_TYPE)		::SysFreeString(dpi.m_bstrType);
				if(dpi.m_dwValidFields & DBGPROP_INFO_VALUE)	::SysFreeString(dpi.m_bstrValue);
			}
		}
*/		getMainWindow().killTimer(ID_TIMER_MOUSEMOVE);
	}
}

/* [EOF] */