// Alpha.h
// (c) 2003-2006 exeal

#ifndef ALPHA_H_
#define ALPHA_H_
#include "resource.h"
#include "BufferList.h"
#include "AlphaView.h"
//#include "Ambient.h"
#include "KeyboardMap.h"
#include "ScriptMacroManager.h"
//#include "AlphaApplicationDebugger.h"
#include "../Manah/WinApp.hpp"
#include "../Manah/Menu.hpp"
#include "../Manah/CommonControls.hpp"
#include <map>
#include <sstream>


// Literals
/////////////////////////////////////////////////////////////////////////////

// ^Cgo[ƂɎgAvP[V
#define __WTIMESTAMP__		_T(__TIMESTAMP__)
#define IDS_APPNAME			L"Alpha"
#define IDS_APPVERSION		L"0.7.5.16\x03B1 fix8"
#ifdef _DEBUG
#	define IDS_APPVERSIONINFO	L"debug version [" __WTIMESTAMP__ L"]"
#else
#	define IDS_APPVERSIONINFO	L"[" __WTIMESTAMP__ L"]"
#endif /* _DEBUG */
#define IDS_APPFULLVERSION	IDS_APPNAME L" " IDS_APPVERSION L" " IDS_APPVERSIONINFO

#define IDS_DEFAULTSTATUSTEXT	L""
#define IDS_EVENTSCRIPTFILENAME	L"events.*"
#define IDS_MACRO_DIRECTORY_NAME			L"macros\\"
#define IDS_KEYBOARDSCHEME_DIRECTORY_NAME	L"keyboardSchemes\\"
#define IDS_ICON_DIRECTORY_NAME				L"icons\\"
#define IDS_BREAK_CR	L"CR (Macintosh)"
#define IDS_BREAK_LF	L"LF (Unix)"
#define IDS_BREAK_CRLF	L"CR+LF (Windows)"
#define IDS_BREAK_NEL	L"NEL (U+0085)"
#define IDS_BREAK_LS	L"LS (U+2028)"
#define IDS_BREAK_PS	L"PS (U+2029)"

// INI sections
#define INI_SECTION_SCRIPTENGINES	L"ScriptEngines"

// Timer ID
#define ID_TIMER_QUERYCOMMAND	1	// c[o[ACe̗L
#define ID_TIMER_MOUSEMOVE		2	// J[\~1bɔ (qg\ȂǂɎgp)

// message ID (VOXbhɖ߂̂ŎgĂȂ̂)
#define MYWM_EVENTHANDLER	WM_APP + 1	// CXbhCxgnhXNvgĂяo
										// wParam => unused
										// lParam => std::pair<const OLECHAR*, DISPPARAMS*>*
										// lParam->first => Cxgnh
										// lParam->second => 
#define MYWM_ENDSCRIPTMACRO	WM_APP + 2	// }NXNvgIɑĂ
										// wParam, lParam => unused
#define MYWM_CALLOVERTHREAD	WM_APP + 3	// Cӂ̊֐Ăяo
										// wParam => unused
										// lParam => ߂lȂ̖֐


namespace Alpha {
/*
class ICallable {
public:
	virtual ~ICallable() {}
	virtual void call() = 0;
};
*/

// O錾
class EventHandlerScript;
class CommandManager;
class BuiltInCommand;
class MRUManager;
class FindDlg;
class BookmarkDlg;

namespace Ambient {
	class Application;
}

/// Xe[^Xo[̃yCBAlphaApp::updateStatusBar Ŏgp
typedef ushort StatusBarPane;
const StatusBarPane
	SBP_MESSAGE			= 0x0001,	///< bZ[W
	SBP_POSITION		= 0x0002,	///< GfB^̃Lbgʒu
	SBP_DOCUMENTTYPE	= 0x0004,	///< ^Cv
	SBP_ENCODING		= 0x0008,	///< GR[fBO
	SBP_TEMPORARYMACRO	= 0x0010,	///< ꎞ}N (ACR)
	SBP_DEBUGMODE		= 0x0020,	///< fobO[h (ACR)
	SBP_OVERTYPEMODE	= 0x0040,	///< ㏑/}[h (Œ蕝)
	SBP_NARROWING		= 0x0080,	///< i[CO (ACR)
	SBP_DUMMY			= 0x0100,
	SBP_ALL				= 0xFFFF;	///< S


/// Alpha ̃AvP[VNX
class AlphaApp :
		public Manah::Windows::ProfilableApplication<>,
		public Ascension::EditViewEventAdapter,
		virtual public BufferList::IActiveBufferListener,
		virtual public Ascension::ClipboardRing::IEventListener,
		virtual public Ascension::IncrementalSearcher::IEventListener/*,
		virtual public IAlphaApplicationDebuggerEventListener*/ {
	friend class AlphaApplication;
	friend class CommandManager;
	friend class BuiltInCommand;
	friend class AlphaView;

	// RXgN^
public:
	AlphaApp();
	virtual ~AlphaApp();

	// \bh
public:
//	void					callFunctionOnGUIThread(ICallable& func);
	HRESULT					getAutomation(Alpha::Ambient::Application*& application) const;
	const std::wstring*		getCodePageName(Ascension::Encodings::CodePage cp) const;
	const CommandManager&	getCommandManager() const throw();
	KeyboardMap&			getKeyboardMap() const throw();
	static AlphaApp&		getInstance();
	void					getScriptLanguageByFileName(const wchar_t* fileName, CLSID& clsid) const;
	void					getTextEditorFont(LOGFONTW& font) const throw();
	void					loadKeyBinds(const std::wstring& schemeName);
	int						messageBox(DWORD id, UINT type,
								Manah::Windows::Module::MessageArguments& args = MARGS);
	void					parseCommandLine(const WCHAR* currentDirectory, const WCHAR* commandLine);
	void					setFont(const LOGFONTW& font);
	void					setStatusText(const wchar_t* text);

	// obt@
	void		applyDocumentType(AlphaDoc& buffer, const std::wstring& typeName = L"");
	BufferList&	getBufferList() const throw();
	MRUManager&	getMRUManager() const throw();

	// 
	void	replaceAll();
	void	replaceAndSearchNext();
	void	searchAndBookmarkAll();
	bool	searchNext(bool forward, bool messageOnFailure);
	void	showSearchDialog();

	// BufferList::IActiveBufferListener C^[tFCX
	void	onChangedActiveBuffer();
	void	onChangedActiveBufferProperty();

	// IEditViewEventListener C^[tFCX
	void	onChangedAbbreviationExpansionReadyState(bool ready, const Ascension::string_t& abbrev);
	void	onInvokeURILink(const Ascension::char_t* uri);
	void	onMatchBracketFoundOutOfView(const Ascension::CharPos& pos);
	void	onMoveCaret(const Ascension::CharPos& pos);

	// ClipboardRing::IEventListener C^[tFCX
	void	onClipboardRingChanged();
	void	onClipboardRingDeniedAdding();

	// IncrementalSearcher::IEventLisetner C^[tFCX
	void	onISearchAborted();
	void	onISearchCompleted();
	void	onISearchPatternChanged(const Ascension::SearchResult& result);
	void	onISearchStarted();

private:
	void			changeFont();
	const wchar_t*	getMenuLabel(CommandID id) const;
	bool			handleKeyDown(VirtualKey key, KeyModifier modifiers);
	void			loadINISettings();
	void			readProfileList(const wchar_t* section, const wchar_t* key,
						std::list<std::wstring>& items, const wchar_t* defaultValue = 0);
	void			readProfileSet(const wchar_t* section, const wchar_t* key,
						std::set<std::wstring>& items, const wchar_t* defaultValue = 0);
	void			reloadScriptMacros();
	void			saveINISettings();
	void			setupMenus();
	void			setupToolbar();
	void			showRegexSearchError(const Ascension::SearchError& e);
	void			updateStatusBar(StatusBarPane panes);
	void			updateTitleBar();
protected:
	LRESULT	dispatchEvent(HWND window, UINT message, WPARAM wParam, LPARAM lParam);
	bool	initInstance(int showCommand);
	bool	preTranslateMessage(const MSG& msg);

	// bZ[Wnh
protected:
	void	onToolExecute();
	void	onToolExecuteCommand();

protected:
	bool	onClose();																	// WM_CLOSE
	bool	onCommand(WORD id, WORD notifyCode, HWND control);							// WM_COMMAND
	void	onCopyData(HWND window, const COPYDATASTRUCT& cds);							// WM_COPYDATA
	void	onDestroy();																// WM_DESTROY
	void	onDrawItem(UINT id, const DRAWITEMSTRUCT& drawItem);						// WM_DRAWITEM
	void	onDropFiles(HDROP drop);													// WM_DROPFILES
	void	onEnterMenuLoop(bool isTrackPopup);											// WM_ENTERMENULOOP
	void	onExitMenuLoop(bool isTrackPopup);											// WM_EXITMENULOOP
	void	onInitMenuPopup(HMENU menu, UINT index, bool sysMenu);						// WM_INITMENUPOPUP
	void	onMeasureItem(UINT id, MEASUREITEMSTRUCT& mi);								// WM_MEASUREITEM
	LRESULT	onMenuChar(wchar_t ch, UINT flags, Manah::Windows::Controls::Menu& menu);	// WM_MENUCHAR
	void	onMenuSelect(UINT itemID, UINT flags, HMENU sysMenu);						// WM_MENUSELECT
	bool	onNotify(int id, NMHDR& nmhdr);												// WM_NOTIFY
	bool	onSetCursor(HWND window, UINT hitTest, UINT message);						// WM_SETCURSOR
	void	onSettingChange(UINT flags, const wchar_t* section);						// WM_SETTINGCHANGE
	void	onSize(UINT type, int cx, int cy);											// WM_SIZE
	void	onTimer(UINT timerID);														// WM_TIMER

protected:
	void	onRebarChevronPushed(const NMREBARCHEVRON& nmRebarChevron);	// RBN_CHEVRONPUSHED

protected:
	/* EBhEvVW */
	static LRESULT CALLBACK appWndProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam);

	// f[^o
protected:
	/* CX^X */
	static AlphaApp* instance_;	// 1̃CX^X

private:
	/* EBhE */
	Manah::Windows::Controls::Menu*		menu_;				// Cj[
	Manah::Windows::Controls::Menu*		fileOpeMenu_;		// [t@C] |bvAbvj[
	Manah::Windows::Controls::Menu*		newDocTypeMenu_;	// VKhLg^Cv|bvAbvj[
	Manah::Windows::Controls::Menu*		appDocTypeMenu_;	// KphLg^Cv|bvAbvj[
	Manah::Windows::Controls::Rebar		rebar_;				// o[
	Manah::Windows::Controls::Toolbar	toolbar_;			// Wc[o[
	Manah::Windows::Controls::StatusBar	statusBar_;			// Xe[^Xo[
	std::auto_ptr<FindDlg>				searchDialog_;		// [ƒu]_CAO
	std::auto_ptr<BookmarkDlg>			bookmarkDialog_;	// [ubN}[N]_CAO

	/* GDI IuWFNg */
	HFONT	editorFont_;	// GfB^̃tHg
	HFONT	statusFont_;	// Xe[^Xo[̃tHg
	HICON	temporaryMacroDefiningIcon_;
	HICON	temporaryMacroPausingIcon_;
	HICON	narrowingIcon_;

	/* @\ƃR}h */
	EventHandlerScript*					eventHandlerScript_;	// events.* s錾GW
	std::auto_ptr<CommandManager>		commandManager_;		// R}h̊Ǘ
	KeyboardMap							keyboardMap_;			// gp̃L[{[h}bv
	MRUManager*							mruManager_;			// MRU Xg̊Ǘ
	std::auto_ptr<BufferList>			buffers_;				// obt@Xg̊Ǘ
	std::auto_ptr<ScriptMacroManager>	scriptMacroManager_;	// XNvg}N̊Ǘ
	VirtualKey							twoStroke1stKey_;		// ͒2Xg[NV[PX1Xg[Nڂ̃L[
	KeyModifier							twoStroke1stModifiers_;	// ͒2Xg[NV[PX1Xg[Nڂ̏CL[
	std::map<Ascension::Encodings::CodePage, std::wstring>	codePageNameTable_;

	/* I[g[VpC^[tFCX */
	Alpha::Ambient::Application*	automation_;

	/* IvV */
	bool	useShortKeyNames_;				// Z`̃L[̖Og
	bool	showMessageBoxOnFind_;			// ŃbZ[W{bNX\
	bool	initializeFindTextFromEditor_;	// [ƒu] _CAOJƂ
											// eLXgGfB^珉
};

/*
/// GUI XbhŔCӂ̊֐Ăяo
inline void AlphaApp::callFunctionOnGuiThread(ICallable& function) {
	getMainWindow().sendMessage(MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(&function));
}*/

/// obt@XgԂ
inline BufferList& AlphaApp::getBufferList() const throw() {return *const_cast<AlphaApp*>(this)->buffers_;}

/// R}hǗIuWFNgԂ
inline const CommandManager& AlphaApp::getCommandManager() const throw() {assertValid(); return *commandManager_;}

/// B̃AvP[VIuWFNgԂ
inline AlphaApp& AlphaApp::getInstance() {assert(AlphaApp::instance_ != 0); return *AlphaApp::instance_;}

/// L[蓖ăIuWFNgԂ
inline KeyboardMap& AlphaApp::getKeyboardMap() const throw() {assertValid(); return const_cast<AlphaApp*>(this)->keyboardMap_;}

/// MRU ǗIuWFNgԂ
inline MRUManager& AlphaApp::getMRUManager() const throw() {assertValid(); return *const_cast<AlphaApp*>(this)->mruManager_;}

/// eLXgGfB^ɎgtHgԂ
inline void AlphaApp::getTextEditorFont(LOGFONTW& font) const throw() {assertValid(); ::GetObject(editorFont_, sizeof(LOGFONTW), &font);}

/**
 *	Xe[^Xo[̐擪̃yC̃eLXgݒ肷
 *	@param text ݒ肷eLXgB@c null Ɗ̃eLXg
 */
inline void AlphaApp::setStatusText(const wchar_t* text) {
	assertValid(); statusBar_.setText(0, (text != 0) ? text : IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);}

} /* namespace Alpha */

#endif /* ALPHA_H_ */

/* [EOF] */