// AlphaDoc.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "AlphaDoc.h"
#include "BufferList.h"
#include "Ambient.h"
using Alpha::AlphaDoc;
using Alpha::BufferList;
using Alpha::AlphaView;
using namespace std;


/// RXgN^
AlphaDoc::AlphaDoc() : automation_(0) {
}

/// fXgN^
AlphaDoc::~AlphaDoc() {
	if(automation_ != 0) {
		automation_->dispose();
		automation_->Release();
	}
}

/// @see EditDoc::getView
AlphaView& AlphaDoc::getView(size_t index) const {
	assertValid();
	return reinterpret_cast<AlphaView&>(EditDoc::getView(index));
}

/// I[g[VpC^[tFCXIuWFNgԂ
HRESULT AlphaDoc::getAutomation(BufferList& buffers, IBuffer*& buffer) const {
	assertValid();

	AlphaDoc& self = *const_cast<AlphaDoc*>(this);
	if(self.automation_ == 0) {	// ܂΍쐬
		if(self.automation_ = new Alpha::Ambient::Buffer(buffers, self))
			self.automation_->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(buffer = self.automation_)->AddRef();
	return S_OK;
}

/// @see EditDoc::getFileName
const TCHAR* AlphaDoc::getFileName() const {
	static const wstring untitled = AlphaApp::getInstance().loadString(MSG_DEFAULT_UNTITLED_BUFFER);
	const TCHAR* const buffer = EditDoc::getFileName();
	return (buffer != 0) ? buffer : untitled.c_str();
}

/* [EOF] */