// AlphaEditController.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "Ambient.h"
#include "resource.h"

using namespace Alpha;
using namespace Ascension;
using namespace Manah::Windows;


// CAlphaEditController class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAlphaEditController::CAlphaEditController(CAlphaDoc& document) :
		CEditController(document), m_pAutomationEditor(0), m_pAutomationSelection(0) {
}

///	fXgN^
CAlphaEditController::~CAlphaEditController() {
	if(m_pAutomationEditor != 0)	m_pAutomationEditor->Release();
	if(m_pAutomationSelection != 0)	m_pAutomationSelection->Release();
}

///	@see	IDocumentContainer::DeleteInstance
void CAlphaEditController::DeleteInstance() {
//	GetDocument()->SetEventListener(0);	// r[̔j󒆂ɃNCAgɃR[obN\
	delete this;
}

/**
 *	r[̌JI[g[VIuWFNgԂ
 *	@param app			AvP[V
 *	@param riid			IuWFNg IIDBIID_ITextEditor AIID_ITextSelection ̂
 *	@param ppAutomation	[out] ߂l
 */
HRESULT CAlphaEditController::GetAutomation(CAlphaApp& app, REFIID riid, IDispatch** ppAutomation) const {
	AssertValid();
	assert(ppAutomation != 0);

	if(riid == IID_ITextEditor) {
		if(m_pAutomationEditor == 0) {
			m_pAutomationEditor = new Ambient::CTextEditor(app, *const_cast<CAlphaEditController*>(this));
			if(m_pAutomationEditor == 0)
				return (*ppAutomation = 0), E_OUTOFMEMORY;
			m_pAutomationEditor->AddRef();
		}
		*ppAutomation = m_pAutomationEditor;
	} else if(riid == IID_ITextSelection) {
		if(m_pAutomationSelection == 0) {
			m_pAutomationSelection = new Ambient::CTextSelection(*const_cast<CAlphaEditController*>(this));
			if(m_pAutomationSelection == 0)
				return (*ppAutomation = 0), E_OUTOFMEMORY;
			m_pAutomationSelection->AddRef();
		}
		*ppAutomation = m_pAutomationSelection;
	} else
		return E_NOINTERFACE;
	(*ppAutomation)->AddRef();
	return S_OK;
}

///	@see	IDocumentContainer::GetDescription
wstring CAlphaEditController::GetDescription() const {
	wstring	strDescription = GetDocument().GetPathName();
	if(strDescription.empty())
		strDescription = IDS_UNTITLED;
	if(GetDocument().IsModified())
		strDescription += L" *";
	return strDescription;
}

///	@see	IDocumentContainer::GetFilePath
inline wstring CAlphaEditController::GetFilePath() const {
	AssertValid();
	return GetDocument().GetPathName();
}

///	@see	IDocumentContainer::GetTitle
wstring CAlphaEditController::GetTitle() const {
	const bool	bReadOnly = GetDocument().IsReadOnly();
	const bool	bModified = GetDocument().IsModified();

	if(bReadOnly || bModified) {
		wostringstream	ssTitle;
		wchar_t			wszReadOnlyTag[100];

		::LoadStringW(::GetModuleHandle(0), MSG_READONLY_TITLE, wszReadOnlyTag, 100);
		ssTitle << GetDocument().GetFileName() << L" ";
		if(bReadOnly)
			ssTitle << wszReadOnlyTag;
		if(bModified)
			ssTitle << L"*";
		return ssTitle.str();
	} else
		return GetDocument().GetFileName();
}

///	@see	IDocumentContainer::GetWindow
inline HWND CAlphaEditController::GetWindow() const {
	AssertValid();
	return GetActiveView();
}

///	@see	IDocumentContainer::OnActivate
void CAlphaEditController::OnActivate(bool bActive) {
//	ShowWindow(bActive ? SW_SHOW : SW_HIDE);
}

///	@see	IDocumentContainer::RefreshWindow
void CAlphaEditController::RefreshWindow() {
//	GetActiveView()->Freeze();
//	GetActiveView()->Unfreeze();
}

/* [EOF] */