// AlphaEditController.h
// (c) 2003-2005 exeal

#ifndef _ALPHA_EDIT_CONTROLLER_H_
#define _ALPHA_EDIT_CONTROLLER_H_

#include "Ascension\EditController.h"
#include "DocumentManager.h"


interface ITextEditor;
interface ITextSelection;

namespace Alpha {
	class CAlphaApp;
	class CAlphaDoc;
	class CAlphaView;

	class CAlphaEditController :
			public Ascension::CEditController,
			virtual public IDocumentContainer {
		// RXgN^
	public:
		CAlphaEditController(CAlphaDoc& document);
		~CAlphaEditController();

		// \bh
	public:
		CAlphaView&	GetActiveView() const;
		HRESULT		GetAutomation(CAlphaApp& app, REFIID riid, IDispatch** ppAutomation) const;
		CAlphaDoc&	GetDocument() const;

		// IDocumentContainer C^[tFCX
	public:
		bool					CanDuplicate() const;
		void					DeleteInstance();
		std::wstring			GetDescription() const;
		std::wstring			GetFilePath() const;
		std::wstring			GetTitle() const;
		HWND					GetWindow() const;
		CAlphaEditController*	GetTextEditor();
		void					RefreshWindow();
		void					OnActivate(bool bActive);

		// f[^o
	private:
		mutable ITextEditor*	m_pAutomationEditor;
		mutable ITextSelection*	m_pAutomationSelection;
	};


	/// @see	IDocumentContainer::CanDuplicate
	inline bool CAlphaEditController::CanDuplicate() const {
		return true;
	}

	///	@see	CEditController::GetActiveView
	inline CAlphaView& CAlphaEditController::GetActiveView() const {
		AssertValid();
		return reinterpret_cast<CAlphaView&>(CEditController::GetActiveView());
	}

	///	@see	CController::GetDocument
	inline CAlphaDoc& CAlphaEditController::GetDocument() const {
		AssertValid();
		return reinterpret_cast<CAlphaDoc&>(m_document);
	}

	///	@see	IDocumentContainer::GetTextEditor
	inline CAlphaEditController* CAlphaEditController::GetTextEditor() {
		AssertValid();
		return this;
	}
} // namespace Alpha


#endif /* _ALPHA_EDIT_CONTROLLER_H_ */

/* [EOF] */