// AlphaScriptHost.cpp
// (c) 2003-2006 exeal

#include "StdAfx.h"
#include "AlphaScriptHost.h"
#include "Alpha.h"
#include "resource.h"
#include <shlwapi.h>	// PathXxxx
#include <comcat.h>		// ICatInformation
#include <objsafe.h>	// IObjectSafety
using namespace Alpha;
using namespace std;
using namespace Armaiti;


// ɂĂ͊ CLSID AIID `ɂȂB
// ȉ̐錾IIɗLɂƂ悢 (Ǝv)

// static const CLSID CLSID_ProcessDebugManager = {
//		0x78a51822, 0x51f4, 0x11d0, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
static const IID IID_IActiveScriptDebug = {
	0x51973C10, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID IID_IActiveScriptSiteDebug = {
	0x51973C11, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID IID_IProcessDebugManager = {
	0x51973C2f, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID IID_IDebugApplication = {
	0x51973C32, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};

namespace {
	/// CxgVNIuWFNg쐬̂ɕKvȏ
	struct ConnectionInfo {
		IStream*	scriptEngine_;				///< XNvgzXg
		HANDLE		connectionCompletionEvent;	///< ڑ/sƂ̃Cxg
		HRESULT		hr;							///< ڑ̌
		IStream*	connectionPoint;			///< ڑ|Cg
		IID			eventIID;					///< CxgVN IID
		wstring		prefix;						///< bZ[Wnh̐ړ
	};
	/// CxgnhĂяo
	struct EventHandlerInvocation {
		OLECHAR*	procedureName;		///< vVW
		DISPPARAMS*	arguments;			///< 
		LCID		lcid;				///< LCID
		IStream**	objectArguments;	///< arguments ̃}[VOꂽA̔z
	};
} // namespace `anonymous'


// AlphaScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

const wchar_t* 			AlphaScriptHost::NAME = L"Alpha Script Host";	///< XNvgzXg̖O
const unsigned short	AlphaScriptHost::MAJOR_VERSION = 0;				///< W[o[W
const unsigned short	AlphaScriptHost::MINOR_VERSION = 6;				///< }Ci[o[W
const unsigned short	AlphaScriptHost::BUILD_VERSION = 601;			///< rhԍ

/**
 *	RXgN^
 *	@param window		TCgEBhE (null ł悢)
 *	@param scriptEngine	GW
 */
AlphaScriptHost::AlphaScriptHost(HWND window, IActiveScript& scriptEngine)
		: ownerWindow_(window), scriptEngine_(scriptEngine),
		securityLevelForSafeObject_(SSSL_ALLOW), securityLevelForUnsafeObject_(SSSL_QUERYUSER),
		allowedErrorReport_(true), enteredScript_(false), interactive_(true), timeout_(0) {
	assert(ownerWindow_ == 0 || toBoolean(::IsWindow(ownerWindow_)));
	scriptEngine_.AddRef();
	scriptFileName_[0] = 0;

	// GWɎZLeB}l[WƂĎg킹
	ComPtr<IObjectSafety> objectSafety;
	if(SUCCEEDED(scriptEngine.QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&objectSafety)))) {
		DWORD supportedOpts, enabledOpts;
		if(SUCCEEDED(objectSafety->GetInterfaceSafetyOptions(IID_NULL, &supportedOpts, &enabledOpts))) {
			if(toBoolean(supportedOpts & INTERFACE_USES_SECURITY_MANAGER))
				objectSafety->SetInterfaceSafetyOptions(IID_NULL, supportedOpts, INTERFACE_USES_SECURITY_MANAGER);
			else {
				setSecurityLevel(true, securityLevelForSafeObject_);
				setSecurityLevel(false, securityLevelForUnsafeObject_);
			}
		}
	}
}

/// fXgN^
AlphaScriptHost::~AlphaScriptHost() {
	disconnectAllObjects();
	releaseTopLevelObjects();
	scriptEngine_.Close();
	scriptEngine_.Release();
}

/**
 *	ŏʃIuWFNg̐ݒ
 *	@param objectName				ŏʃIuWFNg̖O
 *	@param object					ŏʃIuWFNg
 *	@param itemTraits				IActiveScript::AddNamedItem Ɠ
 *	@throw std::invalid_argument	ɓ̃IuWFNg݂ꍇX[
 */
void AlphaScriptHost::addTopLevelObject(const OLECHAR* objectName, IDispatch& object, DWORD itemTraits) {
	assert(objectName != 0);

	// OɕϊĂ
	wchar_t* const buffer = new wchar_t[wcslen(objectName) + 1];
	wcscpy(buffer, objectName);
	::CharLowerW(buffer);
	if(topLevelObjects_.find(buffer) != topLevelObjects_.end()) {
		delete[] buffer;
		throw invalid_argument("There is already same name object.");
	}
	topLevelObjects_.insert(make_pair(buffer, &object));
	delete[] buffer;
	object.AddRef();
	scriptEngine_.AddNamedItem(objectName, itemTraits);
}

/**
 *	֐Ăяo
 *	@param function		֐
 *	@param lcid			P[ʎq
 *	@param params		 (svȏꍇ null)
 *	@param result		[out] ߂l (svȏꍇ null)
 *	@param exception	[out] O (svȏꍇ null)
 *	@return				IDispatch::Invoke ̖߂l
 */
HRESULT AlphaScriptHost::callFunction(IDispatch& function,
		LCID lcid /* = LOCALE_USER_DEFAULT */, DISPPARAMS* params /* = 0 */,
		VARIANT* result /* = 0 */, EXCEPINFO* exception /* = 0 */) {
	DISPPARAMS emptyParams = {0, 0, 0, 0};
	return function.Invoke(DISPID_VALUE, IID_NULL, lcid,
		DISPATCH_METHOD, (params != 0) ? params : &emptyParams, result, exception, 0);
}

#ifdef __IDispatchEx_INTERFACE_DEFINED__
/**
 *	this tĊ֐Ăяo (Ot͖T|[g)
 *	@param function		֐
 *	@param thisArg		this 
 *	@param lcid			P[ʎq
 *	@param params		 (svȏꍇ null)
 *	@param result		[out] ߂l (svȏꍇ null)
 *	@param exception	[out] O (svȏꍇ null)
 *	@return				IDispatchEx::InvokeEx ̖߂l
 */
HRESULT callFunction(IDispatchEx& function, IDispatch& thisArg,
		LCID lcid /* = LOCALE_USER_DEFAULT */, DISPPARAMS* params /* = 0 */,
		VARIANT* result /* = 0 */, EXCEPINFO* exception /* = 0 */) {
	DISPPARAMS	params = {0, 0, 0, 0};
	VARIANTARG	thisParam;
	DISPID		id = DISPID_THIS;

	params.cArgs = (params != 0) ? params->cArgs + 1 : 1;
	params.cNamedArgs = 1;
	params.rgvarg = new VARIANTARG[params.cArgs];
	params.rgvarg[0].vt = VT_DISPATCH;
	params.rgvarg[0].pdispVal = &thisArg;
	params.rgvarg[0].pdispVal->AddRef();
	params.rgdispidNamedArgs = &id;
	if(params != 0) {
		for(int i = 0; i < params.cArgs; ++i)
			params.rgvarg[i + 1] = params->rgvars[i];
	}

	const HRESULT hr = function.InvokeEx(DISPID_VALUE, lcid, DISPATCH_METHOD, &params, result, exception, 0);
	arg.pdispVal->Release();
	delete[] params.rgvars;
	return hr;
}
#endif /* __IDispatchEx_INTERFACE_DEFINED__ */

/**
 *	WSH ̂悤ȃIuWFNgƃCxg̐ڑs
 *	@param object	ڑmIuWFNg
 *	@param prefix	Cxgnh̐ړ
 *	@return			SCODE
 */
HRESULT AlphaScriptHost::connectObject(IDispatch& object, const OLECHAR* prefix) {
	assert(prefix != 0);

	HRESULT								hr;
	ComPtr<IConnectionPointContainer>	cpContainer;
	ComPtr<IEnumConnectionPoints>		cpEnumerator;
	ComPtr<IConnectionPoint>			connectionPoint;
	ComPtr<IProvideClassInfo2>			classInfoProvider;
	IID									eventIID;

	// ڑ|CgT
	if(FAILED(object.QueryInterface(IID_IConnectionPointContainer, reinterpret_cast<void**>(&cpContainer))))
		return E_NOINTERFACE;
	if(S_OK == object.QueryInterface(
			IID_IProvideClassInfo2, reinterpret_cast<void**>(&classInfoProvider))) {
		// IProvideClassInfo2::GetGUID Ŏ擾łꍇ
		if(FAILED(hr = classInfoProvider->GetGUID(GUIDKIND_DEFAULT_SOURCE_DISP_IID, &eventIID)))
			return hr;
		if(FAILED(hr = cpContainer->FindConnectionPoint(eventIID, &connectionPoint)))
			return hr;
	} else if(SUCCEEDED(hr = cpContainer->EnumConnectionPoints(&cpEnumerator))) {
		// SẴCxgɑΉ
		if(S_OK == cpEnumerator->Next(1, &connectionPoint, 0)) {
			if(FAILED(hr = connectionPoint->GetConnectionInterface(&eventIID)))
				return hr;
		}
	}
	if(connectionPoint == 0)
		return E_FAIL/*CONNECT_E_CANNOTCONNECT*/;

	AdhocEventSink* sink = new AdhocEventSink(scriptEngine_, eventIID, prefix);
	object.AddRef();
	sink->AddRef();
	eventSinks_.insert(make_pair(&object, sink));
	hr = sink->connect(*connectionPoint);

	if(FAILED(hr)) {
		eventSinks_.erase(&object);
		object.Release();
		sink->Release();
	}
	return hr;
}

/**
 *	AlphaScriptHost::connectObject ɂڑؒf
 *	@param object	ڑIuWFNg
 *	@return			SCODE
 */
HRESULT AlphaScriptHost::disconnectObject(IDispatch& object) {
	EventSinkTable::iterator it = eventSinks_.find(&object);

	if(it == eventSinks_.end())
		return E_INVALIDARG;
	const HRESULT hr = it->second->disconnect();

	it->first->Release();
	it->second->Release();
	eventSinks_.erase(it);
	return hr;
}

/// @see IActiveScriptSiteWindow::EnableModeless
STDMETHODIMP AlphaScriptHost::EnableModeless(BOOL fEnable) {
/*	if(!fEnable)	return interactive_ ? S_OK : E_FAIL;
	else	*/		return S_OK;
}

/**
 *	@brief XNvg猾GW肵A @c CLSID Ԃ
 *
 *	̃\bh̓WXg̊gq̐ݒ肩猾GWoA
 *	gq̐ݒ肪sĂȂꍇ (Ⴆ΃XNvgGWCXg[
 *	̃vO̊gqēo^ꍇ) ͌Ȃ\B
 *	gqƌGW̑Ή̓AvP[Vxōŝ
 *
 *	@param fileName	XNvg
 *	@param clsid	[out] GW @c CLSIDBɎsꍇ @c CLSID_NULL
 */
void AlphaScriptHost::findScriptEngine(const wchar_t* fileName, CLSID& clsid) {
	assert(fileName != 0);
	clsid = CLSID_NULL;

	wchar_t* const extension = ::PathFindExtensionW(fileName);
	if(extension == 0)
		return;

	HKEY key;
	if(ERROR_SUCCESS != ::RegOpenKeyExW(HKEY_CLASSES_ROOT, extension, 0, KEY_READ, &key))
		return;

	wchar_t fileType[100], progID[100], scriptEngine[100];
	DWORD dataSize = sizeof(fileType);
	long err = ::RegQueryValueExW(key, 0, 0, 0, reinterpret_cast<BYTE*>(fileType), &dataSize);
	::RegCloseKey(key);
	if(err != ERROR_SUCCESS)
		return;

	wcscpy(scriptEngine, fileType);
	wcscat(scriptEngine, L"\\ScriptEngine");
	err = ::RegOpenKeyExW(HKEY_CLASSES_ROOT, scriptEngine, 0, KEY_READ, &key);
	dataSize = sizeof(progID);
	if(err == ERROR_SUCCESS) {
		err = ::RegQueryValueExW(key, 0, 0, 0, reinterpret_cast<BYTE*>(progID), &dataSize);
		::RegCloseKey(key);
	} else {
		::RegCloseKey(key);
		// L[ "ScriptFile" tčĒ (PerlScript Ƃ)
		wcscpy(scriptEngine, fileType);
		wcscat(scriptEngine, L"ScriptFile\\ScriptEngine");
		if(ERROR_SUCCESS != ::RegOpenKeyExW(HKEY_CLASSES_ROOT, scriptEngine, 0, KEY_READ, &key))
			return;
		err = ::RegQueryValueExW(key, 0, 0, 0, reinterpret_cast<BYTE*>(progID), &dataSize);
		::RegCloseKey(key);
		if(err != ERROR_SUCCESS)
			return;
	}
	::CLSIDFromProgID(progID, &clsid);
}

/// @see IActiveScriptSite::GetItemInfo
STDMETHODIMP AlphaScriptHost::GetItemInfo(LPCOLESTR pstrName,
		DWORD dwReturnMask, IUnknown** ppunkItem, ITypeInfo** ppTypeInfo) {
	IDispatch* object = 0;
	wchar_t* const lowerName = new wchar_t[wcslen(pstrName) + 1];

	if(lowerName == 0)
		return E_OUTOFMEMORY;
	wcscpy(lowerName, pstrName);
	::CharLowerW(lowerName);

	MemberTable::const_iterator it = topLevelObjects_.find(lowerName);

	delete[] lowerName;
	if(it != topLevelObjects_.end())
		object = it->second;
	else {
		if(toBoolean(dwReturnMask & SCRIPTINFO_IUNKNOWN)) {
			VERIFY_POINTER(ppunkItem);
			*ppunkItem = 0;
		}
		if(toBoolean(dwReturnMask & SCRIPTINFO_ITYPEINFO)) {
			VERIFY_POINTER(ppTypeInfo);
			*ppTypeInfo = 0;
		}
		return TYPE_E_ELEMENTNOTFOUND;
	}

	if(toBoolean(dwReturnMask & SCRIPTINFO_IUNKNOWN)) {
		VERIFY_POINTER(ppunkItem);
		(*ppunkItem = object)->AddRef();
	}
	if(toBoolean(dwReturnMask & SCRIPTINFO_ITYPEINFO)) {
		VERIFY_POINTER(ppTypeInfo);
		object->GetTypeInfo(0, 0, ppTypeInfo);
	}

	return S_OK;
}

/**
 *	XNvg̔Cӂ̃vVWĂяo
 *	@param name		vVW
 *	@param lcid		ĂяoP[
 *	@param params	
 */
HRESULT AlphaScriptHost::invokeScriptGlobalProcedure(const OLECHAR* name, LCID lcid, DISPPARAMS* params) {
	if(name == 0 || params == 0)
		return E_INVALIDARG;

	ComPtr<IDispatch> topLevel;
	DISPID id;
	HRESULT hr;

	if(enteredScript_)
		hr = scriptEngine_.SetScriptState(SCRIPTSTATE_DISCONNECTED);
	if(FAILED(hr = scriptEngine_.GetScriptDispatch(0, &topLevel)))
		return hr;
	if(FAILED(hr = topLevel->GetIDsOfNames(IID_NULL, const_cast<OLECHAR**>(&name), 1, lcid, &id)))
		return hr;

	VARIANT result;
	AutoZero<EXCEPINFO> exception;
	unsigned int argErr;

	::VariantInit(&result);
	hr = topLevel->Invoke(id, IID_NULL, lcid, DISPATCH_METHOD, params, &result, &exception, &argErr);
	::VariantClear(&result);
	return hr;
}

/**
 *	^Cu (萔) ǂݍ *
 *	@param typeLib	^Cu
 *	@param guid		ǂݍޗ񋓂 @c GUIDBȗƃCȗSĂ̗񋓂ǂݍ
 *	@return			
 */
bool AlphaScriptHost::loadConstants(ITypeLib& typeLib, GUID guid /* = GUID_NULL */) {
	const UINT typeInfoCount = typeLib.GetTypeInfoCount();
	bool loadedOnce = false;

	for(UINT i = 0; i < typeInfoCount; ++i) {
		ComPtr<ITypeInfo> typeInfo;
		TYPEATTR* typeAttr;

		if(FAILED(typeLib.GetTypeInfo(i, &typeInfo)))
			continue;
		if(FAILED(typeInfo->GetTypeAttr(&typeAttr)))
			continue;
		if((guid != GUID_NULL && typeAttr->guid != guid) || typeAttr->typekind != TKIND_ENUM) {
			typeInfo->ReleaseTypeAttr(typeAttr);
			continue;
		}

		ComPtr<EnumImpl> enumerator(new EnumImpl);
		bool addedOnce = false;

		for(WORD j = 0; j < typeAttr->cVars; ++j) {
			VARDESC* varDesc;

			if(FAILED(typeInfo->GetVarDesc(j, &varDesc)))
				continue;
			if(varDesc->varkind != VAR_CONST
					|| toBoolean(varDesc->wVarFlags & VARFLAG_FHIDDEN)
					|| toBoolean(varDesc->wVarFlags & VARFLAG_FNONBROWSABLE)
					|| toBoolean(varDesc->wVarFlags & VARFLAG_FRESTRICTED)) {
				typeInfo->ReleaseVarDesc(varDesc);
				continue;
			}

			UINT fetchedCount;
			BSTR constantName;

			if(SUCCEEDED(typeInfo->GetNames(varDesc->memid, &constantName, 1, &fetchedCount))) {
				bool conflicted = false;
				try {
					enumerator->addProperty(constantName, varDesc->lpvarValue->lVal);
				} catch(invalid_argument& ) {	// 
					conflicted = true;
				}
				::SysFreeString(constantName);
				if(!conflicted)
					addedOnce = true;
			}
			typeInfo->ReleaseVarDesc(varDesc);
		}
		typeInfo->ReleaseTypeAttr(typeAttr);

		if(addedOnce) {
			BSTR enumName;

			if(SUCCEEDED(typeLib.GetDocumentation(i, &enumName, 0, 0, 0))) {
				bool conflicted = false;
				try {
					addTopLevelObject(enumName, *enumerator, SCRIPTITEM_ISVISIBLE);
				} catch(invalid_argument&) {
					conflicted = true;
				}
				::SysFreeString(enumName);
				if(!conflicted)
					loadedOnce = true;
			}
		}
	}
	return guid == GUID_NULL || loadedOnce;
}

/// @see IActiveScriptSite::OnEnterScript
STDMETHODIMP AlphaScriptHost::OnEnterScript() {
//	if(debugApplication_ != 0)
//		HRESULT	hr = debugApplication_->CauseBreak();	// fobKu[N|CgZbg邽߂Ɏ~߂
	enteredScript_ = true;
	return S_OK;
}

/// @see IActiveScriptSite::OnScriptError
STDMETHODIMP AlphaScriptHost::OnScriptError(IActiveScriptError* pscripterror) {
	if(pscripterror == 0)
		return E_INVALIDARG;

	AutoZero<EXCEPINFO> ei;	// Python ł̓[NAK{

	pscripterror->GetExceptionInfo(&ei);
	if(ei.scode == S_OK)	// G[ł͂Ȃ
		return S_OK;

	DWORD srcContext;
	unsigned long line;
	long column;

	isErrorReported_ = true;

	// G[bZ[Wo
	if(allowedErrorReport_) {
		AlphaApp& app = AlphaApp::getInstance();

		pscripterror->GetSourcePosition(&srcContext, &line, &column);
		app.messageBox(MSG_SCRIPT_ERROR_DIALOG, MB_ICONHAND, MARGS
			% ((scriptFileName_[0] != 0) ? scriptFileName_ : app.loadString(MSG_UNKNOWN))
			% (line + 1) % (column + 1)
			% ((ei.bstrDescription != 0) ? ei.bstrDescription : app.loadString(MSG_UNKNOWN))
			% ei.scode % ((ei.bstrSource != 0) ? ei.bstrSource : app.loadString(MSG_UNKNOWN)));
		::SysFreeString(ei.bstrSource);
		::SysFreeString(ei.bstrDescription);
		::SysFreeString(ei.bstrHelpFile);
	}

	return S_OK;
}

/// @see IInternetHostSecurityManager::ProcessUrlAction
STDMETHODIMP AlphaScriptHost::ProcessUrlAction(DWORD dwAction,
		BYTE* pPolicy, DWORD cbPolicy, BYTE* pContext, DWORD cbContext, DWORD dwFlags, DWORD dwReserved) {
	VERIFY_POINTER(pPolicy);
	if(dwReserved != 0)
		return (*pPolicy = URLPOLICY_DISALLOW), E_INVALIDARG;

	// Java ۂBASR  URLACTION_JAVA_IObjIObjCURR_MAX g悤 (Mar. 2004)
	if(dwAction >= URLACTION_JAVA_MIN && dwAction <= URLACTION_JAVA_MAX && cbPolicy >= sizeof(DWORD))
		return (*reinterpret_cast<DWORD*>(pPolicy) = URLPOLICY_JAVA_MEDIUM), S_FALSE;
	else if(dwAction != URLACTION_ACTIVEX_RUN)	// Active X IuWFNg̍쐬ȊO͖
		return (*pPolicy = URLPOLICY_ALLOW), S_OK;

	// ȉAΏۂ Active X IuWFNĝ
	ScriptSiteSecurityLevel securityLevel = securityLevelForUnsafeObject_;
	ComPtr<ICatInformation> pci;

	// KpZLeBx肷̂Ɏ\ɂIuWFNgSǂ𒲂ׂB
	// R|[lgJeS "Controls that are safely scripable" g
	if(cbContext == sizeof(CLSID)
			&& SUCCEEDED(pci.createInstance(CLSID_StdComponentCategoriesMgr))) {
		CATID id = CATID_SafeForScripting;
		if(S_OK == pci->IsClassOfCategories(*reinterpret_cast<CLSID*>(pContext), 1, &id, -1, 0))
			securityLevel = securityLevelForSafeObject_;
	}

	// ȉAΏۂ͈SłȂ\̂ Active X IuWFNĝ
	memset(pPolicy, 0, cbPolicy);

	if(securityLevel <= SSSL_ALLOW) {
		*pPolicy = URLPOLICY_ALLOW;
		return S_OK;
	} else if(securityLevel == SSSL_QUERYUSER
			&& toBoolean(::IsWindow(ownerWindow_))
			&& !toBoolean(dwFlags & PUAF_NOUI)) {
		// x_CAOo
		AlphaApp&	app = AlphaApp::getInstance();
		UINT		dialogType = MB_YESNO | MB_ICONEXCLAMATION | MB_DEFBUTTON2;
		OLECHAR*	progID = 0;
		OLECHAR*	clsid = 0;

		if(toBoolean(dwFlags & PUAF_FORCEUI_FOREGROUND))
			dialogType |= MB_SETFOREGROUND;

		if(cbContext == sizeof(CLSID)) {
			::ProgIDFromCLSID(*reinterpret_cast<CLSID*>(pContext), &progID);
			::StringFromCLSID(*reinterpret_cast<CLSID*>(pContext), &clsid);
		}
		*pPolicy = (app.messageBox(MSG_ACTIVEX_CAUTION, dialogType, MARGS
			% scriptFileName_
			% ((progID != 0) ? progID : app.loadString(MSG_NOT_OBTAINED))
			% ((clsid != 0) ? clsid : app.loadString(MSG_NOT_OBTAINED))) == IDYES) ? URLPOLICY_ALLOW : URLPOLICY_DISALLOW;

		if(progID != 0)	::CoTaskMemFree(progID);
		if(clsid != 0)	::CoTaskMemFree(clsid);

		return (*pPolicy == URLPOLICY_ALLOW) ? S_OK : S_FALSE;
	} else /*if(nSecurityLevel >= SSSL_DISALLOW)*/ {
		*pPolicy = URLPOLICY_DISALLOW;
		return S_FALSE;
	}
}

/// @see IInternetHostSecurityManager::QueryCustomPolicy
STDMETHODIMP AlphaScriptHost::QueryCustomPolicy(REFGUID guidKey,
		BYTE** ppPolicy, DWORD* pcbPolicy, BYTE* pContext, DWORD cbContext, DWORD dwReserved) {
	VERIFY_POINTER(ppPolicy);
	VERIFY_POINTER(pcbPolicy);

	*ppPolicy = 0;
	*pcbPolicy = 0;
	if(dwReserved != 0)
		return E_INVALIDARG;
//	if(guidKey = GUID_CUSTOM_CONFIRMSAFETY && cbContext >= sizeof(CONFIRMSAFETY*)) {
//		CONFIRMSAFETY*	pcs = reinterpret_cast<CONFIRMSAFETY*>(pContext);
//	}
	*ppPolicy = static_cast<BYTE*>(::CoTaskMemAlloc(sizeof(DWORD)));
	if(*ppPolicy == 0)
		return E_OUTOFMEMORY;
	*pcbPolicy = sizeof(DWORD);
	**ppPolicy = URLPOLICY_ALLOW;
	return S_OK;
}

/// ŏʃIuWFNgSč폜
void AlphaScriptHost::releaseTopLevelObjects() {
	for(MemberTable::iterator it = topLevelObjects_.begin(); it != topLevelObjects_.end(); ++it)
		it->second->Release();
	topLevelObjects_.clear();
}

/**
 *	ActiveX IuWFNg쐬ɑ΂ZLeBx̐ݒ
 *	@param forSafeObject	Sƃ}[NĂIuWFNgɂĐݒ肷ꍇ
 *							@c trueB}[NĂȂIuWFNg̏ꍇ @c false
 *	@param securityLevel	ZLeBx
 */
void AlphaScriptHost::setSecurityLevel(bool forSafeObject, ScriptSiteSecurityLevel securityLevel) {
	if(forSafeObject)
		securityLevelForSafeObject_ = securityLevel;
	else {
		ComPtr<IObjectSafety> safety;
		securityLevelForUnsafeObject_ = securityLevel;
		if(SUCCEEDED(scriptEngine_.QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&safety)))) {
			DWORD supportedOpts, enabledOpts;
			if(SUCCEEDED(safety->GetInterfaceSafetyOptions(IID_NULL, &supportedOpts, &enabledOpts))
					&& !toBoolean(supportedOpts & INTERFACE_USES_SECURITY_MANAGER)
					&& toBoolean(supportedOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER))
				safety->SetInterfaceSafetyOptions(IID_NULL,
					supportedOpts, (securityLevel == SSSL_DISALLOW) ? INTERFACESAFE_FOR_UNTRUSTED_CALLER : 0);
		}
	}
}

/**
 *	XNvgw莞Ԓ~ (Cxg̃nhO͌p)
 *	@param milliseconds	~~b (0ł)
 */
void AlphaScriptHost::sleep(unsigned long milliseconds) {
	::Sleep(milliseconds);
}


// AdhocEventSink class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param scriptEngine	GW
 *	@param eventIID		CxgC^[tFCX IID
 *	@param prefix		Cxgnh̐ړ
 */
AlphaScriptHost::AdhocEventSink::AdhocEventSink(IActiveScript& scriptEngine, const IID& eventIID, const wstring& prefix)
		: scriptEngine_(scriptEngine), connectionPointContainer_(0), eventIID_(eventIID), prefix_(prefix) {
	scriptEngine_.AddRef();
}

/// fXgN^
AlphaScriptHost::AdhocEventSink::~AdhocEventSink() {
	if(connectionPointContainer_ != 0)
		disconnect();
	scriptEngine_.Release();
}

/**
 *	CxgVNƂĐڑ
 *	@param connectionPoint	ڑ|Cg
 *	@return					IConnectionPoint::Advise Ɠ
 */
HRESULT AlphaScriptHost::AdhocEventSink::connect(IConnectionPoint& connectionPoint) {
	if(connectionPointContainer_ != 0)
		return E_UNEXPECTED;

	HRESULT hr;

	if(FAILED(hr = connectionPoint.Advise(static_cast<IUnknown*>(this), &cookie_)))
		return hr;
	connectionPoint.GetConnectionPointContainer(&connectionPointContainer_);

	// \bh̃G~[g
	// (̓G[NĂ S_OK Ԃ)
	ComPtr<IProvideClassInfo>	classInfoProvider;
	ComPtr<ITypeInfo>			typeInfo;
	ComPtr<IDispatch>			activeXObject;
	if((SUCCEEDED(connectionPointContainer_->QueryInterface(
			IID_IProvideClassInfo, reinterpret_cast<void**>(&classInfoProvider)))
			&& SUCCEEDED(classInfoProvider->GetClassInfo(&typeInfo)))
			|| (SUCCEEDED(connectionPointContainer_->QueryInterface(
			IID_IDispatch, reinterpret_cast<void**>(&activeXObject)))
			&& SUCCEEDED(activeXObject->GetTypeInfo(0, LOCALE_USER_DEFAULT, &typeInfo)))) {
		ComPtr<ITypeLib> typeLib;
		UINT i;
		if(SUCCEEDED(typeInfo->GetContainingTypeLib(&typeLib, &i))) {
			typeInfo = 0;
			if(SUCCEEDED(typeLib->GetTypeInfoOfGuid(eventIID_, &typeInfo))) {
				TYPEATTR* typeAttribute;
				if(SUCCEEDED(typeInfo->GetTypeAttr(&typeAttribute))) {
					for(WORD i = 0; i < typeAttribute->cFuncs; ++i) {
						FUNCDESC* methodDescription;
						if(SUCCEEDED(typeInfo->GetFuncDesc(i, &methodDescription))) {
							BSTR name;
							if(SUCCEEDED(typeInfo->GetDocumentation(methodDescription->memid, &name, 0, 0, 0))) {
								events_[name] = methodDescription->memid;
								handlers_[methodDescription->memid] = prefix_ + name;
								::SysFreeString(name);
							}
							typeInfo->ReleaseFuncDesc(methodDescription);
						}
					}
					typeInfo->ReleaseTypeAttr(typeAttribute);
				}
			}
		}
	}

	return S_OK;
}

/**
 *	ڑ
 *	@return	IConnectionPoint::Unadvise Ɠ
 */
HRESULT AlphaScriptHost::AdhocEventSink::disconnect() {
	if(connectionPointContainer_ == 0)
		return E_UNEXPECTED;

	HRESULT hr;
	ComPtr<IConnectionPoint> connectionPoint;

	if(FAILED(hr = connectionPointContainer_->FindConnectionPoint(eventIID_, &connectionPoint)))
		return hr;
	events_.clear();
	handlers_.clear();
	return connectionPoint->Unadvise(cookie_);
}

/// @see IDispatch::GetIDsOfNames
STDMETHODIMP AlphaScriptHost::AdhocEventSink::GetIDsOfNames(
		REFIID riid, OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId) {
	if(riid != IID_NULL)
		return E_INVALIDARG;
	VERIFY_POINTER(rgDispId);

	for(unsigned int i = 0; i < cNames; ++i) {
		map<wstring, DISPID>::const_iterator it = events_.find(rgszNames[i]);
		if(it == events_.end())
			return DISP_E_UNKNOWNNAME;
		rgDispId[i] = it->second;
	}
	return S_OK;
}

/// @see IDispatch::GetTypeInfo
STDMETHODIMP AlphaScriptHost::AdhocEventSink::GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
	VERIFY_POINTER(ppTypeInfo);
	*ppTypeInfo = 0;
	return TYPE_E_ELEMENTNOTFOUND;
}

/// @see IDispatch::GetTypeInfoCount
STDMETHODIMP AlphaScriptHost::AdhocEventSink::GetTypeInfoCount(UINT* pcTypeInfo) {
	VERIFY_POINTER(pcTypeInfo);
	*pcTypeInfo = 0;
	return S_OK;
}

/// @see IDispatch::Invoke
STDMETHODIMP AlphaScriptHost::AdhocEventSink::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pDispParams,
		VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return E_INVALIDARG;

	map<DISPID, wstring>::const_iterator it = handlers_.find(dispidMember);

	if(it == handlers_.end())
		return DISP_E_MEMBERNOTFOUND;

	HRESULT hr;
	ComPtr<IDispatch> topLevel;
	DISPID id;
	OLECHAR* name = const_cast<OLECHAR*>(it->second.c_str());

	if(FAILED(hr = scriptEngine_.GetScriptDispatch(0, &topLevel)))
		return hr;
	if(FAILED(hr = topLevel->GetIDsOfNames(riid, &name, 1, lcid, &id)))
		return hr;
	return topLevel->Invoke(id, riid, lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
}

/// @see IUnknown::QueryInterface
STDMETHODIMP AlphaScriptHost::AdhocEventSink::QueryInterface(REFIID riid, void** ppvObject) {
	VERIFY_POINTER(ppvObject);

	if(riid == eventIID_ || riid == IID_IDispatch || riid == IID_IUnknown)
		*ppvObject = static_cast<IDispatch*>(this);
	else
		return (*ppvObject = 0), E_NOINTERFACE;
	reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
	return S_OK;
}


// EnumImpl class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	vpeBǉ
 *	@param mame						vpeB
 *	@param value					l
 *	@throw std::invalid_argument	ɓ̃vpeB݂ƂX[
 */
void AlphaScriptHost::EnumImpl::addProperty(const OLECHAR* name, long value) {
	assert(name != 0);

	static DISPID id = 100;
	wchar_t* const lowerName = new wchar_t[wcslen(name) + 1];

	wcscpy(lowerName, name);
	::CharLowerW(lowerName);
	const NameToIDTable::const_iterator it = nameTable_.find(lowerName);
	if(it != nameTable_.end()) {
		delete[] lowerName;
		throw std::invalid_argument("There is a property has same name.");
	}
	nameTable_[lowerName] = id;
	idTable_[id++] = value;
	delete[] lowerName;
}

/// IDispatch::GetTypeInfo
STDMETHODIMP AlphaScriptHost::EnumImpl::GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
	VERIFY_POINTER(ppTypeInfo);
	*ppTypeInfo = 0;
	return E_NOTIMPL;
}

/// IDispatch::GetTypeInfoCount
STDMETHODIMP AlphaScriptHost::EnumImpl::GetTypeInfoCount(UINT* pcTypeInfo) {
	VERIFY_POINTER(pcTypeInfo);
	*pcTypeInfo = 0;
	return S_OK;
}

/// IDispatch::GetIDsOfNames
STDMETHODIMP AlphaScriptHost::EnumImpl::GetIDsOfNames(
		REFIID riid, LPOLESTR* rgszNames, UINT cNames, LCID lcid, DISPID* rgDispId) {
	VERIFY_POINTER(rgDispId);
	if(riid != IID_NULL || rgszNames == 0)
		return E_INVALIDARG;

	wchar_t* const lowerName = new wchar_t[wcslen(rgszNames[0]) + 1];

	wcscpy(lowerName, rgszNames[0]);
	::CharLowerW(lowerName);

	NameToIDTable::const_iterator it = nameTable_.find(lowerName);

	delete[] lowerName;
	rgDispId[0] = (it != nameTable_.end()) ? it->second : DISPID_UNKNOWN;
	for(UINT i = 1; i < cNames; ++i)
		rgDispId[i] = DISPID_UNKNOWN;
	return (rgDispId[0] != DISPID_UNKNOWN) ? S_OK : DISP_E_UNKNOWNNAME;
}

/// @see IDispatch::Invoke
STDMETHODIMP AlphaScriptHost::EnumImpl::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS *pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, UINT* puArgErr) {
	if(riid != IID_NULL)
		return E_INVALIDARG;
	else if(pVarResult == 0)
		return S_OK;
	else if((wFlags & DISPATCH_PROPERTYGET) == 0)
		return DISP_E_MEMBERNOTFOUND;

	const IDToValueTable::const_iterator it = idTable_.find(dispidMember);
	if(it == idTable_.end())
		return DISP_E_MEMBERNOTFOUND;

	pVarResult->vt = VT_I4;
	pVarResult->lVal = it->second;
	return S_OK;
}

/* [EOF] */